/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import java.net.URL;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

public class DownloadScrapeResultImpl
implements DownloadScrapeResult {
    protected DownloadImpl download;
    protected TRTrackerScraperResponse response;

    protected DownloadScrapeResultImpl(DownloadImpl _download, TRTrackerScraperResponse _response) {
        this.download = _download;
        this.response = _response;
    }

    protected void setContent(TRTrackerScraperResponse _response) {
        this.response = _response;
    }

    public Download getDownload() {
        return this.download;
    }

    public int getResponseType() {
        if (this.response != null && this.response.isValid()) {
            return 1;
        }
        return 2;
    }

    public int getSeedCount() {
        return this.response == null ? -1 : this.response.getSeeds();
    }

    public int getNonSeedCount() {
        return this.response == null ? -1 : this.response.getPeers();
    }

    public long getScrapeStartTime() {
        return this.response == null ? -1L : this.response.getScrapeStartTime();
    }

    public void setNextScrapeStartTime(long nextScrapeStartTime) {
        TRTrackerScraperResponse current_response = this.getCurrentResponse();
        if (current_response != null) {
            current_response.setNextScrapeStartTime(nextScrapeStartTime);
        }
    }

    public long getNextScrapeStartTime() {
        TRTrackerScraperResponse current_response = this.getCurrentResponse();
        return current_response == null ? -1L : current_response.getNextScrapeStartTime();
    }

    public String getStatus() {
        if (this.response != null) {
            return this.response.getStatusString();
        }
        return "";
    }

    public URL getURL() {
        return this.response.getURL();
    }

    protected TRTrackerScraperResponse getCurrentResponse() {
        TRTrackerScraperResponse current = this.download.getDownload().getTrackerScrapeResponse();
        if (current == null) {
            current = this.response;
        }
        return current;
    }
}

