/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileIsADirectoryException;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;

public class TorrentUtils {
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_ENABLE = "dht_backup_enable";
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED = "dht_backup_requested";
    private static final Set torrent_az_reserved_properties = new HashSet();
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return new HashMap();
        }
    };
    private static volatile Set ignore_set;
    private static boolean bSaveTorrentBackup;
    private static final int PIECE_HASH_TIMEOUT = 180000;
    private static Map torrent_delegates;

    public static TOTorrent readFromFile(File file, boolean create_delegate) throws TOTorrentException {
        return TorrentUtils.readFromFile(file, create_delegate, false);
    }

    public static TOTorrent readFromFile(File file, boolean create_delegate, boolean force_initial_discard) throws TOTorrentException {
        TOTorrent torrent;
        try {
            File torrent_file_bak;
            torrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
            if (bSaveTorrentBackup && !(torrent_file_bak = new File(file.getParent(), file.getName() + ".bak")).exists()) {
                try {
                    torrent.serialiseToBEncodedFile(torrent_file_bak);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (TOTorrentException e) {
            Debug.outNoStack(e.getMessage());
            File torrentBackup = new File(file.getParent(), file.getName() + ".bak");
            if (torrentBackup.exists()) {
                torrent = TOTorrentFactory.deserialiseFromBEncodedFile(torrentBackup);
            }
            throw e;
        }
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        if (create_delegate) {
            torrentDelegate res = new torrentDelegate(torrent, file);
            if (force_initial_discard) {
                res.discardPieces(SystemTime.getCurrentTime(), true);
            }
            return res;
        }
        return torrent;
    }

    public static TOTorrent readFromBEncodedInputStream(InputStream is) throws TOTorrentException {
        TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
        torrent.removeAdditionalProperties();
        return torrent;
    }

    public static void writeToFile(TOTorrent torrent) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(TOTorrent torrent, boolean force_backup) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            torrent.getPieces();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::writeToFile: no 'torrent filename' attribute defined", 1);
            }
            File torrent_file = new File(str);
            if ((force_backup || COConfigurationManager.getBooleanParameter("Save Torrent Backup", false)) && torrent_file.exists()) {
                File torrent_file_bak = new File(str + ".bak");
                try {
                    if (torrent_file_bak.exists()) {
                        torrent_file_bak.delete();
                    }
                    torrent_file.renameTo(torrent_file_bak);
                }
                catch (SecurityException e) {
                    Debug.printStackTrace(e);
                }
            }
            torrent.serialiseToBEncodedFile(torrent_file);
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void writeToFile(TOTorrent torrent, File file) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, file, false);
    }

    public static void writeToFile(TOTorrent torrent, File file, boolean force_backup) throws TOTorrentException {
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        TorrentUtils.writeToFile(torrent, force_backup);
    }

    public static String getTorrentFileName(TOTorrent torrent) throws TOTorrentException {
        String str = torrent.getAdditionalStringProperty("torrent filename");
        if (str == null) {
            throw new TOTorrentException("TorrentUtils::getTorrentFileName: no 'torrent filename' attribute defined", 1);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(TOTorrent torrent, File file) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            torrent.getPieces();
            torrent.serialiseToBEncodedFile(file);
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(TOTorrent torrent) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::delete: no 'torrent filename' attribute defined", 1);
            }
            if (!new File(str).delete()) {
                throw new TOTorrentException("TorrentUtils::delete: failed to delete '" + str + "'", 5);
            }
            new File(str + ".bak").delete();
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void delete(File torrent_file) {
        if (!FileUtil.deleteWithRecycle(torrent_file)) {
            Debug.out("TorrentUtils::delete: failed to delete '" + torrent_file + "'");
        }
        new File(torrent_file.toString() + ".bak").delete();
    }

    public static boolean move(File from_torrent, File to_torrent) {
        if (!FileUtil.renameFile(from_torrent, to_torrent)) {
            return false;
        }
        if (new File(from_torrent.toString() + ".bak").exists()) {
            FileUtil.renameFile(new File(from_torrent.toString() + ".bak"), new File(to_torrent.toString() + ".bak"));
        }
        return true;
    }

    public static String exceptionToText(TOTorrentException e) {
        return TorrentUtils.exceptionToText(e, false);
    }

    public static String exceptionToText(TOTorrentException e, boolean verbose) {
        int reason = e.getReason();
        String errorDetail = reason == 1 ? MessageText.getString("DownloadManager.error.filenotfound") : (reason == 2 ? MessageText.getString("DownloadManager.error.fileempty") : (reason == 3 ? MessageText.getString("DownloadManager.error.filetoobig") : (reason == 6 ? MessageText.getString("DownloadManager.error.filewithouttorrentinfo") + " (" + e.getMessage() + ")" : (reason == 7 ? MessageText.getString("DownloadManager.error.unsupportedencoding") : (reason == 4 ? MessageText.getString("DownloadManager.error.ioerror") : (reason == 8 ? MessageText.getString("DownloadManager.error.sha1") : (reason == 9 ? MessageText.getString("DownloadManager.error.operationcancancelled") : e.getMessage())))))));
        if (verbose) {
            String msg = e.getMessage();
            if (msg == null) {
                errorDetail = errorDetail + "(" + e.toString() + ")";
            } else if (!errorDetail.equals(msg)) {
                errorDetail = errorDetail + "(" + e.getMessage() + ")";
            }
        }
        return errorDetail;
    }

    public static List announceGroupsToList(TOTorrent torrent) {
        ArrayList groups = new ArrayList();
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        if (sets.length == 0) {
            ArrayList<String> s = new ArrayList<String>();
            s.add(torrent.getAnnounceURL().toString());
            groups.add(s);
        } else {
            for (int i = 0; i < sets.length; ++i) {
                ArrayList<String> s = new ArrayList<String>();
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                for (int j = 0; j < urls.length; ++j) {
                    s.add(urls[j].toString());
                }
                if (s.size() <= 0) continue;
                groups.add(s);
            }
        }
        return groups;
    }

    public static void listToAnnounceGroups(List groups, TOTorrent torrent) {
        try {
            List set;
            TOTorrentAnnounceURLGroup tg = torrent.getAnnounceURLGroup();
            if (groups.size() == 1 && (set = (List)groups.get(0)).size() == 1) {
                torrent.setAnnounceURL(new URL((String)set.get(0)));
                tg.setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                return;
            }
            Vector<TOTorrentAnnounceURLSet> g = new Vector<TOTorrentAnnounceURLSet>();
            for (int i = 0; i < groups.size(); ++i) {
                List set2 = (List)groups.get(i);
                URL[] urls = new URL[set2.size()];
                for (int j = 0; j < set2.size(); ++j) {
                    urls[j] = new URL((String)set2.get(j));
                }
                if (urls.length <= 0) continue;
                g.add(tg.createAnnounceURLSet(urls));
            }
            Object[] sets = new TOTorrentAnnounceURLSet[g.size()];
            g.copyInto(sets);
            tg.setAnnounceURLSets((TOTorrentAnnounceURLSet[])sets);
            if (sets.length == 0) {
                torrent.setAnnounceURL(new URL("http://no.valid.urls.defined/announce"));
            }
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, String first_url) {
        try {
            TorrentUtils.announceGroupsInsertFirst(torrent, new URL(first_url));
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL first_url) {
        TorrentUtils.announceGroupsInsertFirst(torrent, new URL[]{first_url});
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[0] = set1;
            System.arraycopy(sets, 0, new_sets, 1, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set1, set2});
        }
    }

    public static void announceGroupsInsertLast(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[sets.length] = set1;
            System.arraycopy(sets, 0, new_sets, 0, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set2, set1});
        }
    }

    public static void announceGroupsSetFirst(TOTorrent torrent, String first_url) {
        List groups = TorrentUtils.announceGroupsToList(torrent);
        boolean found = false;
        block0: for (int i = 0; i < groups.size(); ++i) {
            List set = (List)groups.get(i);
            for (int j = 0; j < set.size(); ++j) {
                if (!first_url.equals(set.get(j))) continue;
                set.remove(j);
                set.add(0, first_url);
                groups.remove(set);
                groups.add(0, set);
                found = true;
                break block0;
            }
        }
        if (!found) {
            System.out.println("TorrentUtils::announceGroupsSetFirst - failed to find '" + first_url + "'");
        }
        TorrentUtils.listToAnnounceGroups(groups, torrent);
    }

    public static boolean announceGroupsContainsURL(TOTorrent torrent, String url) {
        List groups = TorrentUtils.announceGroupsToList(torrent);
        for (int i = 0; i < groups.size(); ++i) {
            List set = (List)groups.get(i);
            for (int j = 0; j < set.size(); ++j) {
                if (!url.equals(set.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean mergeAnnounceURLs(TOTorrent new_torrent, TOTorrent dest_torrent) {
        int i;
        if (new_torrent == null || dest_torrent == null) {
            return false;
        }
        List new_groups = TorrentUtils.announceGroupsToList(new_torrent);
        List dest_groups = TorrentUtils.announceGroupsToList(dest_torrent);
        ArrayList<List> groups_to_add = new ArrayList<List>();
        for (i = 0; i < new_groups.size(); ++i) {
            List new_set = (List)new_groups.get(i);
            boolean match = false;
            for (int j = 0; j < dest_groups.size(); ++j) {
                boolean same;
                List dest_set = (List)dest_groups.get(j);
                boolean bl = same = new_set.size() == dest_set.size();
                if (same) {
                    for (int k = 0; k < new_set.size(); ++k) {
                        String new_url = (String)new_set.get(k);
                        if (dest_set.contains(new_url)) continue;
                        same = false;
                        break;
                    }
                }
                if (!same) continue;
                match = true;
                break;
            }
            if (match) continue;
            groups_to_add.add(new_set);
        }
        if (groups_to_add.size() == 0) {
            return false;
        }
        for (i = 0; i < groups_to_add.size(); ++i) {
            dest_groups.add(i, groups_to_add.get(i));
        }
        TorrentUtils.listToAnnounceGroups(dest_groups, dest_torrent);
        return true;
    }

    public static boolean replaceAnnounceURL(TOTorrent torrent, URL old_url, URL new_url) {
        boolean found = false;
        String old_str = old_url.toString();
        String new_str = new_url.toString();
        List l = TorrentUtils.announceGroupsToList(torrent);
        for (int i = 0; i < l.size(); ++i) {
            List set = (List)l.get(i);
            for (int j = 0; j < set.size(); ++j) {
                if (!((String)set.get(j)).equals(old_str)) continue;
                found = true;
                set.set(j, new_str);
            }
        }
        if (found) {
            TorrentUtils.listToAnnounceGroups(l, torrent);
        }
        if (torrent.getAnnounceURL().toString().equals(old_str)) {
            torrent.setAnnounceURL(new_url);
            found = true;
        }
        if (found) {
            try {
                TorrentUtils.writeToFile(torrent);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return false;
            }
        }
        return found;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState download_manager_state) {
        DiskManagerFactory.setResumeDataCompletelyValid(download_manager_state);
    }

    public static String getLocalisedName(TOTorrent torrent) {
        try {
            LocaleUtilDecoder decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(torrent);
            if (decoder == null) {
                return new String(torrent.getName(), "UTF8");
            }
            return decoder.decodeString(torrent.getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new String(torrent.getName());
        }
    }

    public static void setTLSTorrentHash(HashWrapper hash) {
        ((Map)tls.get()).put("hash", hash);
    }

    public static TOTorrent getTLSTorrent() {
        HashWrapper hash = (HashWrapper)((Map)tls.get()).get("hash");
        if (hash != null) {
            try {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                DownloadManager dm = core.getGlobalManager().getDownloadManager(hash);
                if (dm != null) {
                    return dm.getTorrent();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static URL getDecentralisedEmptyURL() {
        try {
            return new URL("dht://");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static void setDecentralised(TOTorrent torrent) {
        try {
            byte[] hash = torrent.getHash();
            torrent.setAnnounceURL(new URL("dht://" + ByteFormatter.encodeString(hash) + ".dht/announce"));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean isDecentralised(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        return TorrentUtils.isDecentralised(torrent.getAnnounceURL());
    }

    public static boolean isDecentralised(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().equalsIgnoreCase("dht");
    }

    public static void setPluginStringProperty(TOTorrent torrent, String name, String value) {
        HashMap<String, byte[]> p;
        Object obj;
        HashMap m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            m = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", m);
        }
        if ((obj = m.get("plugins")) instanceof Map) {
            p = (HashMap<String, byte[]>)obj;
        } else {
            p = new HashMap<String, byte[]>();
            m.put("plugins", p);
        }
        if (value == null) {
            p.remove(name);
        } else {
            p.put(name, value.getBytes());
        }
    }

    public static String getPluginStringProperty(TOTorrent torrent, String name) {
        Map p;
        Map m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            return null;
        }
        Object obj = m.get("plugins");
        if (obj instanceof Map && (obj = (p = (Map)obj).get(name)) instanceof byte[]) {
            return new String((byte[])obj);
        }
        return null;
    }

    public static void setPluginMapProperty(TOTorrent torrent, String name, Map value) {
        HashMap<String, Map> p;
        Object obj;
        HashMap m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            m = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", m);
        }
        if ((obj = m.get("plugins")) instanceof Map) {
            p = (HashMap<String, Map>)obj;
        } else {
            p = new HashMap<String, Map>();
            m.put("plugins", p);
        }
        if (value == null) {
            p.remove(name);
        } else {
            p.put(name, value);
        }
    }

    public static Map getPluginMapProperty(TOTorrent torrent, String name) {
        Map p;
        Map m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            return null;
        }
        Object obj = m.get("plugins");
        if (obj instanceof Map && (obj = (p = (Map)obj).get(name)) instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static void setDHTBackupEnabled(TOTorrent torrent, boolean enabled) {
        HashMap<String, Long> m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            m = new HashMap<String, Long>();
            torrent.setAdditionalMapProperty("azureus_properties", m);
        }
        m.put(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE, new Long(enabled ? 1L : 0L));
    }

    public static boolean getDHTBackupEnabled(TOTorrent torrent) {
        Map m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            return true;
        }
        Object obj = m.get(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        return true;
    }

    public static boolean isDHTBackupRequested(TOTorrent torrent) {
        Map m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            return false;
        }
        Object obj = m.get(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        return false;
    }

    public static void setDHTBackupRequested(TOTorrent torrent, boolean requested) {
        HashMap<String, Long> m = torrent.getAdditionalMapProperty("azureus_properties");
        if (m == null) {
            m = new HashMap<String, Long>();
            torrent.setAdditionalMapProperty("azureus_properties", m);
        }
        m.put(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED, new Long(requested ? 1L : 0L));
    }

    public static boolean getDHTTrackerEnabled() {
        PluginInterface dht_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_pi == null) {
            return false;
        }
        DHTPlugin dht = (DHTPlugin)dht_pi.getPlugin();
        return dht.peekEnabled();
    }

    public static boolean getPrivate(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        return torrent.getPrivate();
    }

    public static void setPrivate(TOTorrent torrent, boolean _private) {
        if (torrent == null) {
            return;
        }
        try {
            torrent.setPrivate(_private);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static Set getIgnoreSet() {
        return TorrentUtils.getIgnoreSetSupport(false);
    }

    public static synchronized Set getIgnoreSetSupport(boolean force) {
        if (ignore_set == null || force) {
            int p1;
            HashSet<String> new_ignore_set = new HashSet<String>();
            String ignore_list = COConfigurationManager.getStringParameter("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
            if (ignore_set == null) {
                COConfigurationManager.addParameterListener("File.Torrent.IgnoreFiles", new ParameterListener(){

                    public void parameterChanged(String parameterName) {
                        TorrentUtils.getIgnoreSetSupport(true);
                    }
                });
            }
            int pos = 0;
            do {
                String bit;
                if ((p1 = ignore_list.indexOf(";", pos)) == -1) {
                    bit = ignore_list.substring(pos);
                } else {
                    bit = ignore_list.substring(pos, p1);
                    pos = p1 + 1;
                }
                new_ignore_set.add(bit.trim().toLowerCase());
            } while (p1 != -1);
            ignore_set = new_ignore_set;
        }
        return ignore_set;
    }

    public static File copyTorrentFileToSaveDir(File f, boolean persistent) throws IOException {
        File cFile;
        boolean saveTorrents = persistent && COConfigurationManager.getBooleanParameter("Save Torrent Files", true);
        File torrentDir = saveTorrents ? new File(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory")) : new File(f.getParent());
        boolean moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done", false);
        String completedDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        if (moveWhenDone && completedDir.length() > 0 && (cFile = new File(completedDir, f.getName())).exists()) {
            torrentDir = new File(completedDir);
        }
        torrentDir.mkdirs();
        File fDest = new File(torrentDir, f.getName().replaceAll("%20", "."));
        if (fDest.equals(f)) {
            return f;
        }
        while (fDest.exists()) {
            fDest = new File(torrentDir, "_" + fDest.getName());
        }
        fDest.createNewFile();
        if (!FileUtil.copyFile(f, fDest)) {
            throw new IOException("File copy failed");
        }
        return fDest;
    }

    public static DownloadManager getDownloadManager(HashWrapper hash) {
        try {
            return AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(hash);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void recursiveEmptyDirDelete(File f) {
        TorrentUtils.recursiveEmptyDirDelete(f, true);
    }

    public static void recursiveEmptyDirDelete(File f, boolean log_warnings) {
        Set ignore_map = TorrentUtils.getIgnoreSet();
        FileUtil.recursiveEmptyDirDelete(f, ignore_map, log_warnings);
    }

    public static String nicePrintTorrentHash(TOTorrent torrent) {
        return TorrentUtils.nicePrintTorrentHash(torrent, false);
    }

    public static String nicePrintTorrentHash(TOTorrent torrent, boolean tight) {
        byte[] hash;
        if (torrent == null) {
            hash = new byte[20];
        } else {
            try {
                hash = torrent.getHash();
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                hash = new byte[20];
            }
        }
        return ByteFormatter.nicePrint(hash, tight);
    }

    public static boolean isTorrentFile(String filename) throws FileNotFoundException, IOException {
        File check = new File(filename);
        if (!check.exists()) {
            throw new FileNotFoundException("File " + filename + " not found.");
        }
        if (!check.canRead()) {
            throw new IOException("File " + filename + " cannot be read.");
        }
        if (check.isDirectory()) {
            throw new FileIsADirectoryException("File " + filename + " is a directory.");
        }
        try {
            TOTorrentFactory.deserialiseFromBEncodedFile(check);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("Save Torrent Backup", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bSaveTorrentBackup = COConfigurationManager.getBooleanParameter(parameterName, false);
            }
        });
        torrent_delegates = new WeakHashMap();
        SimpleTimer.addPeriodicEvent("TorrentUtils:pieceDiscard", 90000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                long now = SystemTime.getCurrentTime();
                Map map = torrent_delegates;
                synchronized (map) {
                    Iterator it = torrent_delegates.keySet().iterator();
                    while (it.hasNext()) {
                        ((torrentDelegate)it.next()).discardPieces(now, false);
                    }
                }
            }
        });
    }

    protected static class torrentDelegate
    extends LogRelation
    implements TOTorrent {
        protected TOTorrent delegate;
        protected File file;
        protected long last_pieces_read_time = SystemTime.getCurrentTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected torrentDelegate(TOTorrent _delegate, File _file) {
            this.delegate = _delegate;
            this.file = _file;
            Map map = torrent_delegates;
            synchronized (map) {
                torrent_delegates.put(this, null);
            }
        }

        public byte[] getName() {
            return this.delegate.getName();
        }

        public boolean isSimpleTorrent() {
            return this.delegate.isSimpleTorrent();
        }

        public byte[] getComment() {
            return this.delegate.getComment();
        }

        public void setComment(String comment) {
            this.delegate.setComment(comment);
        }

        public long getCreationDate() {
            return this.delegate.getCreationDate();
        }

        public void setCreationDate(long date) {
            this.delegate.setCreationDate(date);
        }

        public byte[] getCreatedBy() {
            return this.delegate.getCreatedBy();
        }

        public URL getAnnounceURL() {
            return this.delegate.getAnnounceURL();
        }

        public boolean setAnnounceURL(URL url) {
            return this.delegate.setAnnounceURL(url);
        }

        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            return this.delegate.getAnnounceURLGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void discardPieces(long now, boolean force) {
            block7: {
                if (now < this.last_pieces_read_time && !force) {
                    this.last_pieces_read_time = now;
                } else {
                    try {
                        if (now - this.last_pieces_read_time <= 180000L && !force || this.delegate.getPieces() == null) break block7;
                        try {
                            this.getMonitor().enter();
                            this.delegate.setPieces(null);
                        }
                        finally {
                            this.getMonitor().exit();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[][] getPieces() throws TOTorrentException {
            byte[][] res = this.delegate.getPieces();
            this.last_pieces_read_time = SystemTime.getCurrentTime();
            if (res == null) {
                try {
                    this.getMonitor().enter();
                    TOTorrent temp = TorrentUtils.readFromFile(this.file, false);
                    res = temp.getPieces();
                    this.delegate.setPieces(res);
                }
                finally {
                    this.getMonitor().exit();
                }
            }
            return res;
        }

        public void setPieces(byte[][] pieces) throws TOTorrentException {
            throw new TOTorrentException("Unsupported Operation", 5);
        }

        public long getPieceLength() {
            return this.delegate.getPieceLength();
        }

        public int getNumberOfPieces() {
            return this.delegate.getNumberOfPieces();
        }

        public long getSize() {
            return this.delegate.getSize();
        }

        public TOTorrentFile[] getFiles() {
            return this.delegate.getFiles();
        }

        public byte[] getHash() throws TOTorrentException {
            return this.delegate.getHash();
        }

        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.delegate.getHashWrapper();
        }

        public boolean getPrivate() {
            return this.delegate.getPrivate();
        }

        public void setPrivate(boolean _private) throws TOTorrentException {
            throw new TOTorrentException("Can't amend private attribute", 5);
        }

        public boolean hasSameHashAs(TOTorrent other) {
            return this.delegate.hasSameHashAs(other);
        }

        public void setAdditionalStringProperty(String name, String value) {
            this.delegate.setAdditionalStringProperty(name, value);
        }

        public String getAdditionalStringProperty(String name) {
            return this.delegate.getAdditionalStringProperty(name);
        }

        public void setAdditionalByteArrayProperty(String name, byte[] value) {
            this.delegate.setAdditionalByteArrayProperty(name, value);
        }

        public byte[] getAdditionalByteArrayProperty(String name) {
            return this.delegate.getAdditionalByteArrayProperty(name);
        }

        public void setAdditionalLongProperty(String name, Long value) {
            this.delegate.setAdditionalLongProperty(name, value);
        }

        public Long getAdditionalLongProperty(String name) {
            return this.delegate.getAdditionalLongProperty(name);
        }

        public void setAdditionalListProperty(String name, List value) {
            this.delegate.setAdditionalListProperty(name, value);
        }

        public List getAdditionalListProperty(String name) {
            return this.delegate.getAdditionalListProperty(name);
        }

        public void setAdditionalMapProperty(String name, Map value) {
            this.delegate.setAdditionalMapProperty(name, value);
        }

        public Map getAdditionalMapProperty(String name) {
            return this.delegate.getAdditionalMapProperty(name);
        }

        public Object getAdditionalProperty(String name) {
            return this.delegate.getAdditionalProperty(name);
        }

        public void setAdditionalProperty(String name, Object value) {
            this.delegate.setAdditionalProperty(name, value);
        }

        public void removeAdditionalProperty(String name) {
            this.delegate.removeAdditionalProperty(name);
        }

        public void removeAdditionalProperties() {
            this.delegate.removeAdditionalProperties();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialiseToBEncodedFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                this.getPieces();
                this.delegate.serialiseToBEncodedFile(target_file);
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map serialiseToMap() throws TOTorrentException {
            try {
                this.getMonitor().enter();
                this.getPieces();
                Map map = this.delegate.serialiseToMap();
                return map;
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialiseToXMLFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                this.getPieces();
                this.delegate.serialiseToXMLFile(target_file);
            }
            finally {
                this.getMonitor().exit();
            }
        }

        public AEMonitor getMonitor() {
            return this.delegate.getMonitor();
        }

        public void print() {
            this.delegate.print();
        }

        public String getRelationText() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getRelationText();
            }
            return this.delegate.toString();
        }

        public Object[] getQueryableInterfaces() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getQueryableInterfaces();
            }
            return super.getQueryableInterfaces();
        }
    }
}

