/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.SystemTime;

public class ListenerManager {
    protected String name;
    protected ListenerManagerDispatcher target;
    protected ListenerManagerDispatcherWithException target_with_exception;
    protected boolean async;
    protected Thread async_thread;
    protected List listeners = new ArrayList();
    protected List dispatch_queue;
    protected AESemaphore dispatch_sem;

    public static ListenerManager createManager(String name, ListenerManagerDispatcher target) {
        return new ListenerManager(name, target, false);
    }

    public static ListenerManager createAsyncManager(String name, ListenerManagerDispatcher target) {
        return new ListenerManager(name, target, true);
    }

    protected ListenerManager(String _name, ListenerManagerDispatcher _target, boolean _async) {
        this.name = _name;
        this.target = _target;
        this.async = _async;
        if (this.target instanceof ListenerManagerDispatcherWithException) {
            this.target_with_exception = (ListenerManagerDispatcherWithException)this.target;
        }
        if (this.async) {
            this.dispatch_sem = new AESemaphore("ListenerManager::" + this.name);
            this.dispatch_queue = new LinkedList();
            if (this.target_with_exception != null) {
                throw new RuntimeException("Can't have an async manager with exceptions!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object listener) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList<Object> new_listeners = new ArrayList<Object>(this.listeners);
            if (new_listeners.contains(listener)) {
                Logger.log(new LogEvent(LogIDs.CORE, 1, "addListener called but listener already added for " + this.name + "\n\t" + Debug.getStackTrace(true, false)));
            }
            new_listeners.add(listener);
            if (new_listeners.size() > 50) {
                Logger.log(new LogEvent(LogIDs.CORE, 1, "addListener: over 50 listeners added for " + this.name + "\n\t" + Debug.getStackTrace(true, false)));
            }
            this.listeners = new_listeners;
            if (this.async && this.async_thread == null) {
                this.async_thread = new AEThread(this.name){

                    public void runSupport() {
                        ListenerManager.this.dispatchLoop();
                    }
                };
                this.async_thread.setDaemon(true);
                this.async_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object listener) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(listener);
            this.listeners = new_listeners;
            if (this.async && this.listeners.size() == 0) {
                this.async_thread = null;
                this.dispatch_sem.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            this.listeners = new ArrayList();
            if (this.async) {
                this.async_thread = null;
                this.dispatch_sem.release();
            }
        }
    }

    public List getListenersCopy() {
        return this.listeners;
    }

    public void dispatch(int type, Object value) {
        this.dispatch(type, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(int type, Object value, boolean blocking) {
        if (this.async) {
            AESemaphore sem = null;
            if (blocking) {
                sem = new AESemaphore("ListenerManager:blocker");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.listeners.size() == 0) {
                    return;
                }
                this.dispatch_queue.add(new Object[]{this.listeners, new Integer(type), value, sem});
            }
            this.dispatch_sem.release();
            if (sem != null) {
                sem.reserve();
            }
        } else {
            List listeners_ref;
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                listeners_ref = this.listeners;
            }
            try {
                this.dispatchInternal(listeners_ref, type, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchWithException(int type, Object value) throws Throwable {
        List listeners_ref;
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            listeners_ref = this.listeners;
        }
        this.dispatchInternal(listeners_ref, type, value);
    }

    public void dispatch(Object listener, int type, Object value) {
        this.dispatch(listener, type, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Object listener, int type, Object value, boolean blocking) {
        if (this.async) {
            AESemaphore sem = null;
            if (blocking) {
                sem = new AESemaphore("ListenerManager:blocker");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                this.dispatch_queue.add(new Object[]{listener, new Integer(type), value, sem, null});
                if (this.async_thread == null) {
                    this.async_thread = new AEThread(this.name){

                        public void runSupport() {
                            ListenerManager.this.dispatchLoop();
                        }
                    };
                    this.async_thread.setDaemon(true);
                    this.async_thread.start();
                }
            }
            this.dispatch_sem.release();
            if (sem != null) {
                sem.reserve();
            }
        } else {
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            try {
                this.target.dispatch(listener, type, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void dispatchInternal(List listeners_ref, int type, Object value) throws Throwable {
        for (int i = 0; i < listeners_ref.size(); ++i) {
            if (this.target_with_exception != null) {
                this.target_with_exception.dispatchWithException(listeners_ref.get(i), type, value);
                continue;
            }
            try {
                this.target.dispatch(listeners_ref.get(i), type, value);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void dispatchInternal(Object listener, int type, Object value) throws Throwable {
        if (this.target_with_exception != null) {
            this.target_with_exception.dispatchWithException(listener, type, value);
        } else {
            try {
                this.target.dispatch(listener, type, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchLoop() {
        while (true) {
            Object var5_4;
            this.dispatch_sem.reserve();
            Object[] data = null;
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.async_thread != Thread.currentThread()) {
                    this.dispatch_sem.release();
                    return;
                }
                if (this.dispatch_queue.size() > 0) {
                    data = (Object[])this.dispatch_queue.remove(0);
                }
                if (data == null) continue;
            }
            try {
                try {
                    if (data.length == 4) {
                        this.dispatchInternal((List)data[0], (int)((Integer)data[1]), data[2]);
                    } else {
                        this.dispatchInternal(data[0], (int)((Integer)data[1]), data[2]);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    var5_4 = null;
                    if (data[3] == null) continue;
                    ((AESemaphore)data[3]).release();
                    continue;
                }
                var5_4 = null;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                if (data[3] == null) throw throwable;
                ((AESemaphore)data[3]).release();
                throw throwable;
            }
            if (data[3] == null) continue;
            ((AESemaphore)data[3]).release();
        }
    }

    public static void dispatchWithTimeout(List _listeners, final ListenerManagerDispatcher _dispatcher, long _timeout) {
        final ArrayList listeners = new ArrayList(_listeners);
        final boolean[] completed = new boolean[listeners.size()];
        final AESemaphore timeout_sem = new AESemaphore("ListenerManager:dwt:timeout");
        int i = 0;
        while (i < listeners.size()) {
            final int f_i = i++;
            new AEThread("ListenerManager:dwt:dispatcher", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        try {
                            _dispatcher.dispatch(listeners.get(f_i), -1, null);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            Object var3_2 = null;
                            completed[f_i] = true;
                            timeout_sem.release();
                        }
                        Object var3_1 = null;
                        completed[f_i] = true;
                        timeout_sem.release();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        completed[f_i] = true;
                        timeout_sem.release();
                        throw throwable;
                    }
                }
            }.start();
        }
        boolean timeout_occurred = false;
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            if (_timeout <= 0L) {
                timeout_occurred = true;
                break;
            }
            long start = SystemTime.getCurrentTime();
            if (!timeout_sem.reserve(_timeout)) {
                timeout_occurred = true;
                break;
            }
            long end = SystemTime.getCurrentTime();
            if (end <= start) continue;
            _timeout -= end - start;
        }
        if (timeout_occurred) {
            String str = "";
            for (int i3 = 0; i3 < completed.length; ++i3) {
                if (completed[i3]) continue;
                str = str + (str.length() == 0 ? "" : ",") + listeners.get(i3);
            }
            if (str.length() > 0) {
                Debug.out("Listener dispatch timeout: failed = " + str);
            }
        }
    }

    public long size() {
        if (this.listeners == null) {
            return 0L;
        }
        return this.listeners.size();
    }
}

