/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.IPToHostNameResolverRequest;

public class IPToHostNameResolver {
    protected static Thread resolver_thread;
    protected static List request_queue;
    protected static AEMonitor request_mon;
    protected static AESemaphore request_semaphore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPToHostNameResolverRequest addResolverRequest(String ip, IPToHostNameResolverListener l) {
        try {
            request_mon.enter();
            IPToHostNameResolverRequest request2 = new IPToHostNameResolverRequest(ip, l);
            request_queue.add(request2);
            request_semaphore.release();
            if (resolver_thread == null) {
                resolver_thread = new AEThread("IPToHostNameResolver"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        block7: while (true) {
                            try {
                                while (true) {
                                    IPToHostNameResolverRequest req;
                                    request_semaphore.reserve();
                                    try {
                                        request_mon.enter();
                                        req = (IPToHostNameResolverRequest)request_queue.remove(0);
                                    }
                                    finally {
                                        request_mon.exit();
                                    }
                                    IPToHostNameResolverListener listener = req.getListener();
                                    if (listener == null) continue;
                                    try {
                                        InetAddress addr = InetAddress.getByName(req.getIP());
                                        req.getListener().IPResolutionComplete(addr.getHostName(), true);
                                        continue block7;
                                    }
                                    catch (Throwable e) {
                                        req.getListener().IPResolutionComplete(req.getIP(), false);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                continue;
                            }
                            break;
                        }
                    }
                };
                resolver_thread.setDaemon(true);
                resolver_thread.start();
            }
            IPToHostNameResolverRequest iPToHostNameResolverRequest = request2;
            return iPToHostNameResolverRequest;
        }
        finally {
            request_mon.exit();
        }
    }

    static {
        request_queue = new ArrayList();
        request_mon = new AEMonitor("IPToHostNameResolver");
        request_semaphore = new AESemaphore("IPToHostNameResolver");
    }
}

