/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.AEMonSem;
import org.gudy.azureus2.core3.util.Debug;

public class AESemaphore
extends AEMonSem {
    private int dont_wait = 0;
    private int total_reserve = 0;
    private int total_release = 0;
    private boolean released_forever = false;
    protected Thread latest_waiter;

    public AESemaphore(String _name) {
        this(_name, 0);
    }

    public AESemaphore(String _name, int count) {
        super(_name, false);
        this.dont_wait = count;
        this.total_release = count;
    }

    public void reserve() {
        if (!this.reserve(0L)) {
            Debug.out("AESemaphore: reserve completed without acquire [" + this.getString() + "]");
        }
    }

    public boolean reserve(long millis) {
        return this.reserveSupport(millis, 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserveIfAvailable() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            if (this.released_forever || this.dont_wait > 0) {
                this.reserve();
                return true;
            }
            return false;
        }
    }

    public int reserveSet(int max_to_reserve, long millis) {
        return this.reserveSupport(millis, max_to_reserve);
    }

    public int reserveSet(int max_to_reserve) {
        return this.reserveSupport(0L, max_to_reserve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int reserveSupport(long millis, int max_to_reserve) {
        if (DEBUG) {
            super.debugEntry();
        }
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            ++this.entry_count;
            if (this.released_forever) {
                return 1;
            }
            if (this.dont_wait == 0) {
                try {
                    int spurious_count;
                    ++this.waiting;
                    this.latest_waiter = Thread.currentThread();
                    if (this.waiting > 1) {
                        // empty if block
                    }
                    if (millis == 0L) {
                        spurious_count = 0;
                        while (true) {
                            this.wait();
                            if (this.total_reserve == this.total_release) {
                                if (++spurious_count > 1024) {
                                    Debug.out("AESemaphore: spurious wakeup limit exceeded");
                                    throw new Throwable("die die die");
                                }
                                Debug.out("AESemaphore: spurious wakeup, ignoring");
                                continue;
                            }
                            break;
                        }
                    } else {
                        this.wait(millis);
                    }
                    if (this.total_reserve == this.total_release) {
                        --this.waiting;
                        spurious_count = 0;
                        return spurious_count;
                    }
                    ++this.total_reserve;
                    spurious_count = 1;
                    return spurious_count;
                }
                catch (Throwable e) {
                    --this.waiting;
                    Debug.out("**** semaphore operation interrupted ****");
                    throw new RuntimeException("Semaphore: operation interrupted", e);
                }
                finally {
                    this.latest_waiter = null;
                }
            }
            int num_to_get = max_to_reserve > this.dont_wait ? this.dont_wait : max_to_reserve;
            this.dont_wait -= num_to_get;
            this.total_reserve += num_to_get;
            return num_to_get;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            AESemaphore aESemaphore = this;
            synchronized (aESemaphore) {
                ++this.total_release;
                if (this.waiting != 0) {
                    --this.waiting;
                    this.notify();
                } else {
                    ++this.dont_wait;
                }
            }
        }
        finally {
            if (DEBUG) {
                this.debugExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllWaiters() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            int x = this.waiting;
            for (int i = 0; i < x; ++i) {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseForever() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            this.releaseAllWaiters();
            this.released_forever = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReleasedForever() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            return this.released_forever;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValue() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            return this.dont_wait - this.waiting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            return "value=" + this.dont_wait + ",waiting=" + this.waiting + ",res=" + this.total_reserve + ",rel=" + this.total_release;
        }
    }
}

