/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.net.InetAddress;
import java.util.Arrays;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNatCheckerListener;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class TRTrackerServerPeerImpl
implements TRTrackerServerPeer,
HostNameToIPResolverListener,
TRTrackerServerNatCheckerListener {
    private HashWrapper peer_id;
    private int key_hash_code;
    private byte[] ip;
    private boolean ip_override;
    private short tcp_port;
    private short udp_port;
    private byte crypto_level;
    private String ip_str;
    private byte[] ip_bytes;
    private byte NAT_status = 0;
    private long timeout;
    private long uploaded;
    private long downloaded;
    private long amount_left;
    private long last_contact_time;
    private boolean download_completed;

    protected TRTrackerServerPeerImpl(HashWrapper _peer_id, int _key_hash_code, byte[] _ip, boolean _ip_override, int _tcp_port, int _udp_port, byte _crypto_level, long _last_contact_time, boolean _download_completed, byte _last_nat_status) {
        this.peer_id = _peer_id;
        this.key_hash_code = _key_hash_code;
        this.ip = _ip;
        this.ip_override = _ip_override;
        this.tcp_port = (short)_tcp_port;
        this.udp_port = (short)_udp_port;
        this.crypto_level = _crypto_level;
        this.last_contact_time = _last_contact_time;
        this.download_completed = _download_completed;
        this.NAT_status = _last_nat_status;
        this.resolveAndCheckNAT();
    }

    protected boolean checkForIPOrPortChange(byte[] _ip, int _port, int _udp_port, byte _crypto_level) {
        this.udp_port = (short)_udp_port;
        this.crypto_level = _crypto_level;
        boolean res = false;
        if (_port != this.getTCPPort()) {
            this.tcp_port = (short)_port;
            res = true;
        }
        if (!Arrays.equals(_ip, this.ip)) {
            this.ip = _ip;
            res = true;
        }
        if (res) {
            this.resolveAndCheckNAT();
        }
        return res;
    }

    public void NATCheckComplete(boolean ok) {
        this.NAT_status = ok ? (byte)3 : (byte)4;
    }

    protected void setNATStatus(byte status) {
        this.NAT_status = status;
    }

    public byte getNATStatus() {
        return this.NAT_status;
    }

    protected boolean isNATStatusBad() {
        return this.NAT_status == 4 || this.NAT_status == 5;
    }

    protected void resolveAndCheckNAT() {
        this.ip_str = new String(this.ip);
        this.ip_bytes = null;
        HostNameToIPResolver.addResolverRequest(this.ip_str, this);
        if (this.tcp_port == 0) {
            this.NAT_status = (byte)5;
        } else if (this.NAT_status == 0) {
            this.NAT_status = (byte)2;
            if (!TRTrackerServerNATChecker.getSingleton().addNATCheckRequest(this.ip_str, this.getTCPPort(), this)) {
                this.NAT_status = 1;
            }
        }
    }

    public void hostNameResolutionComplete(InetAddress address) {
        if (address != null) {
            this.ip_str = address.getHostAddress();
            this.ip_bytes = address.getAddress();
        }
    }

    protected long getLastContactTime() {
        return this.last_contact_time;
    }

    protected boolean getDownloadCompleted() {
        return this.download_completed;
    }

    protected void setDownloadCompleted() {
        this.download_completed = true;
    }

    protected HashWrapper getPeerId() {
        return this.peer_id;
    }

    public byte[] getPeerID() {
        return this.peer_id.getBytes();
    }

    protected int getKeyHashCode() {
        return this.key_hash_code;
    }

    protected byte[] getIPAsRead() {
        return this.ip;
    }

    public String getIPRaw() {
        return new String(this.ip);
    }

    public String getIP() {
        return this.ip_str;
    }

    protected boolean isIPOverride() {
        return this.ip_override;
    }

    public byte[] getIPBytes() {
        return this.ip_bytes;
    }

    public int getTCPPort() {
        return this.tcp_port & 0xFFFF;
    }

    protected int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    protected byte getCryptoLevel() {
        return this.crypto_level;
    }

    protected void setTimeout(long _now, long _timeout) {
        this.last_contact_time = _now;
        this.timeout = _timeout;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected void setStats(long _uploaded, long _downloaded, long _amount_left) {
        this.uploaded = _uploaded;
        this.downloaded = _downloaded;
        this.amount_left = _amount_left;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getAmountLeft() {
        return this.amount_left;
    }

    protected boolean isSeed() {
        return this.amount_left == 0L;
    }

    protected String getString() {
        return new String(this.ip) + ":" + this.getTCPPort() + "(" + new String(this.peer_id.getHash()) + ")";
    }
}

