/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class TOTorrentXMLDeserialiser {
    public TOTorrent deserialise(File file) throws TOTorrentException {
        try {
            SimpleXMLParserDocument doc = SimpleXMLParserDocumentFactory.create(file);
            TOTorrent res = this.decodeRoot(doc);
            return res;
        }
        catch (SimpleXMLParserDocumentException e) {
            throw new TOTorrentException("XML Parse Fails: " + e.getMessage(), 6);
        }
    }

    protected TOTorrent decodeRoot(SimpleXMLParserDocument doc) throws TOTorrentException {
        String root_name = doc.getName();
        if (root_name.equalsIgnoreCase("TORRENT")) {
            TOTorrentImpl torrent = new TOTorrentImpl();
            SimpleXMLParserDocumentNode[] kids = doc.getChildren();
            URL announce_url = null;
            Object info_node = null;
            byte[] torrent_hash = null;
            for (int i = 0; i < kids.length; ++i) {
                SimpleXMLParserDocumentNode kid = kids[i];
                String name = kid.getName();
                if (name.equalsIgnoreCase("ANNOUNCE_URL")) {
                    try {
                        announce_url = new URL(kid.getValue());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new TOTorrentException("ANNOUNCE_URL malformed", 6);
                    }
                }
                if (name.equalsIgnoreCase("ANNOUNCE_LIST")) {
                    SimpleXMLParserDocumentNode[] set_nodes = kid.getChildren();
                    TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                    TOTorrentAnnounceURLSet[] sets = new TOTorrentAnnounceURLSet[set_nodes.length];
                    for (int j = 0; j < sets.length; ++j) {
                        SimpleXMLParserDocumentNode[] url_nodes = set_nodes[j].getChildren();
                        URL[] urls = new URL[url_nodes.length];
                        for (int k = 0; k < urls.length; ++k) {
                            try {
                                urls[k] = new URL(url_nodes[k].getValue());
                                continue;
                            }
                            catch (MalformedURLException e) {
                                throw new TOTorrentException("ANNOUNCE_LIST malformed", 6);
                            }
                        }
                        sets[j] = group.createAnnounceURLSet(urls);
                    }
                    group.setAnnounceURLSets(sets);
                    continue;
                }
                if (name.equalsIgnoreCase("COMMENT")) {
                    torrent.setComment(this.readLocalisableString(kid));
                    continue;
                }
                if (name.equalsIgnoreCase("CREATED_BY")) {
                    torrent.setCreatedBy(this.readLocalisableString(kid));
                    continue;
                }
                if (name.equalsIgnoreCase("CREATION_DATE")) {
                    torrent.setCreationDate(this.readGenericLong(kid));
                    continue;
                }
                if (name.equalsIgnoreCase("TORRENT_HASH")) {
                    torrent_hash = this.readGenericBytes(kid);
                    continue;
                }
                if (name.equalsIgnoreCase("INFO")) {
                    this.decodeInfo(kid, torrent);
                    continue;
                }
                mapEntry entry = this.readGenericMapEntry(kid);
                torrent.addAdditionalProperty(entry.name, entry.value);
            }
            if (announce_url == null) {
                throw new TOTorrentException("ANNOUNCE_URL missing", 6);
            }
            torrent.setAnnounceURL(announce_url);
            if (torrent_hash != null && !Arrays.equals(torrent.getHash(), torrent_hash)) {
                throw new TOTorrentException("Hash differs - declared TORRENT_HASH and computed hash differ. If this really is the intent (unlikely) then remove the TORRENT_HASH element", 6);
            }
            return torrent;
        }
        throw new TOTorrentException("Invalid root element", 6);
    }

    protected void decodeInfo(SimpleXMLParserDocumentNode doc, TOTorrentImpl torrent) throws TOTorrentException {
        SimpleXMLParserDocumentNode[] kids = doc.getChildren();
        Object torrent_name = null;
        long torrent_length = 0L;
        for (int i = 0; i < kids.length; ++i) {
            int j;
            SimpleXMLParserDocumentNode kid = kids[i];
            String name = kid.getName();
            if (name.equalsIgnoreCase("PIECE_LENGTH")) {
                torrent.setPieceLength(this.readGenericLong(kid));
                continue;
            }
            if (name.equalsIgnoreCase("LENGTH")) {
                torrent.setSimpleTorrent(true);
                torrent_length = this.readGenericLong(kid);
                continue;
            }
            if (name.equalsIgnoreCase("NAME")) {
                torrent.setName(this.readLocalisableString(kid));
                continue;
            }
            if (name.equalsIgnoreCase("FILES")) {
                torrent.setSimpleTorrent(false);
                SimpleXMLParserDocumentNode[] file_nodes = kid.getChildren();
                TOTorrentFileImpl[] files = new TOTorrentFileImpl[file_nodes.length];
                for (j = 0; j < files.length; ++j) {
                    int k;
                    SimpleXMLParserDocumentNode file_node = file_nodes[j];
                    SimpleXMLParserDocumentNode[] file_entries = file_node.getChildren();
                    long file_length = 0L;
                    boolean length_entry_found = false;
                    Object path_comps = null;
                    Vector<mapEntry> additional_props = new Vector<mapEntry>();
                    for (k = 0; k < file_entries.length; ++k) {
                        SimpleXMLParserDocumentNode file_entry = file_entries[k];
                        String entry_name = file_entry.getName();
                        if (entry_name.equalsIgnoreCase("LENGTH")) {
                            file_length = this.readGenericLong(file_entry);
                            length_entry_found = true;
                            continue;
                        }
                        if (entry_name.equalsIgnoreCase("PATH")) {
                            SimpleXMLParserDocumentNode[] path_nodes = file_entry.getChildren();
                            path_comps = new byte[path_nodes.length][];
                            for (int n = 0; n < path_nodes.length; ++n) {
                                path_comps[n] = this.readLocalisableString(path_nodes[n]);
                            }
                            continue;
                        }
                        additional_props.addElement(this.readGenericMapEntry(file_entry));
                    }
                    if (!length_entry_found || path_comps == null) {
                        throw new TOTorrentException("FILE element invalid (file length = " + file_length + ")", 6);
                    }
                    files[j] = new TOTorrentFileImpl((TOTorrent)torrent, file_length, (byte[][])path_comps);
                    for (k = 0; k < additional_props.size(); ++k) {
                        mapEntry entry = (mapEntry)additional_props.elementAt(k);
                        files[j].setAdditionalProperty(entry.name, entry.value);
                    }
                }
                torrent.setFiles(files);
                continue;
            }
            if (name.equalsIgnoreCase("PIECES")) {
                SimpleXMLParserDocumentNode[] piece_nodes = kid.getChildren();
                byte[][] pieces = new byte[piece_nodes.length][];
                for (j = 0; j < pieces.length; ++j) {
                    pieces[j] = this.readGenericBytes(piece_nodes[j]);
                }
                torrent.setPieces(pieces);
                continue;
            }
            mapEntry entry = this.readGenericMapEntry(kid);
            torrent.addAdditionalInfoProperty(entry.name, entry.value);
        }
        if (torrent.isSimpleTorrent()) {
            torrent.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)torrent, torrent_length, new byte[][]{torrent.getName()})});
        }
    }

    protected mapEntry readGenericMapEntry(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        if (!node.getName().equalsIgnoreCase("KEY")) {
            throw new TOTorrentException("Additional property invalid, must be KEY node", 6);
        }
        String name = node.getAttribute("name").getValue();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        if (kids.length != 1) {
            throw new TOTorrentException("Additional property invalid, KEY must have one child", 6);
        }
        String type = kids[0].getName();
        Object value = this.readGenericValue(kids[0]);
        return new mapEntry(name, value);
    }

    protected Object readGenericValue(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String name = node.getName();
        if (name.equalsIgnoreCase("BYTES")) {
            return this.readGenericBytes(node);
        }
        if (name.equalsIgnoreCase("LONG")) {
            return this.readGenericLong(node);
        }
        if (name.equalsIgnoreCase("LIST")) {
            return this.readGenericList(node);
        }
        if (name.equalsIgnoreCase("MAP")) {
            return this.readGenericMap(node);
        }
        throw new TOTorrentException("Additional property invalid, sub-key '" + name + "' not recognised", 6);
    }

    protected byte[] readGenericBytes(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String value = node.getValue();
        byte[] res = new byte[value.length() / 2];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16);
        }
        return res;
    }

    protected Long readGenericLong(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String value = node.getValue();
        try {
            return new Long(value);
        }
        catch (Throwable e) {
            throw new TOTorrentException("long value invalid for '" + node.getName() + "'", 6);
        }
    }

    protected Map readGenericMap(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            mapEntry entry = this.readGenericMapEntry(kids[i]);
            res.put(entry.name, entry.value);
        }
        return res;
    }

    protected byte[] readLocalisableString(SimpleXMLParserDocumentNode kid) throws TOTorrentException {
        SimpleXMLParserDocumentAttribute attr = kid.getAttribute("encoding");
        if (attr == null || attr.getValue().equalsIgnoreCase("bytes")) {
            return this.readGenericBytes(kid);
        }
        try {
            return kid.getValue().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("bytes invalid - unsupported encoding", 6);
        }
    }

    protected List readGenericList(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        ArrayList<Object> res = new ArrayList<Object>();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            res.add(this.readGenericValue(kids[i]));
        }
        return res;
    }

    protected class mapEntry {
        String name;
        Object value;

        mapEntry(String _name, Object _value) {
            this.name = _name;
            this.value = _value;
        }
    }
}

