/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentAnnounceURLGroupImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentAnnounceURLSetImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentXMLSerialiser;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class TOTorrentImpl
extends LogRelation
implements TOTorrent {
    protected static final String TK_ANNOUNCE = "announce";
    protected static final String TK_ANNOUNCE_LIST = "announce-list";
    protected static final String TK_COMMENT = "comment";
    protected static final String TK_CREATION_DATE = "creation date";
    protected static final String TK_CREATED_BY = "created by";
    protected static final String TK_INFO = "info";
    protected static final String TK_NAME = "name";
    protected static final String TK_LENGTH = "length";
    protected static final String TK_PATH = "path";
    protected static final String TK_FILES = "files";
    protected static final String TK_PIECE_LENGTH = "piece length";
    protected static final String TK_PIECES = "pieces";
    protected static final String TK_PRIVATE = "private";
    protected static final String TK_NAME_UTF8 = "name.utf-8";
    protected static final String TK_PATH_UTF8 = "path.utf-8";
    protected static final String TK_COMMENT_UTF8 = "comment.utf-8";
    protected static final List TK_ADDITIONAL_OK_ATTRS = Arrays.asList("comment.utf-8", "azureus_properties");
    private byte[] torrent_name;
    private byte[] torrent_name_utf8;
    private byte[] comment;
    private URL announce_url;
    private TOTorrentAnnounceURLGroupImpl announce_group = new TOTorrentAnnounceURLGroupImpl(this);
    private long piece_length;
    private int number_of_pieces;
    private byte[][] pieces;
    private byte[] torrent_hash;
    private HashWrapper torrent_hash_wrapper;
    private boolean simple_torrent;
    private TOTorrentFileImpl[] files;
    private long creation_date;
    private byte[] created_by;
    private Map additional_properties = new HashMap();
    private Map additional_info_properties = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("TOTorrent");

    protected TOTorrentImpl() {
    }

    protected TOTorrentImpl(String _torrent_name, URL _announce_url, boolean _simple_torrent) throws TOTorrentException {
        try {
            this.torrent_name = _torrent_name.getBytes("UTF8");
            this.torrent_name_utf8 = this.torrent_name;
            this.setAnnounceURL(_announce_url);
            this.simple_torrent = _simple_torrent;
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("TOTorrent: unsupported encoding for '" + _torrent_name + "'", 7);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialiseToBEncodedFile(File output_file) throws TOTorrentException {
        FilterOutputStream bos;
        block17: {
            byte[] res = this.serialiseToByteArray();
            bos = null;
            File parent = output_file.getParentFile();
            if (parent == null || parent.exists() && !parent.isDirectory()) {
                throw new TOTorrentException("Path '" + output_file + "' is invalid", 5);
            }
            if (!parent.exists() && !parent.mkdirs()) {
                throw new TOTorrentException("Failed to create directory '" + parent + "'", 5);
            }
            File temp = new File(parent, output_file.getName() + ".saving");
            if (temp.exists()) {
                if (!temp.delete()) {
                    throw new TOTorrentException("Insufficient permissions to delete '" + temp + "'", 5);
                }
            } else {
                boolean ok = false;
                try {
                    ok = temp.createNewFile();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (!ok) {
                    throw new TOTorrentException("Insufficient permissions to write '" + temp + "'", 5);
                }
            }
            bos = new BufferedOutputStream(new FileOutputStream(temp, false), 8192);
            bos.write(res);
            ((BufferedOutputStream)bos).flush();
            bos.close();
            bos = null;
            if (temp.length() <= 1L) break block17;
            if (output_file.exists()) {
                output_file.delete();
            }
            temp.renameTo(output_file);
        }
        Object var9_10 = null;
        if (bos == null) return;
        try {
            bos.close();
            return;
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
        return;
        {
            catch (TOTorrentException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new TOTorrentException("TOTorrent::serialise: fails '" + e.toString() + "'", 5);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (bos == null) throw throwable;
            try {
                bos.close();
                throw throwable;
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
            }
            throw throwable;
        }
    }

    protected byte[] serialiseToByteArray() throws TOTorrentException {
        Map root = this.serialiseToMap();
        try {
            return BEncoder.encode(root);
        }
        catch (IOException e) {
            throw new TOTorrentException("TOTorrent::serialiseToByteArray: fails '" + e.toString() + "'", 5);
        }
    }

    public Map serialiseToMap() throws TOTorrentException {
        HashMap<String, Object> root = new HashMap<String, Object>();
        this.writeStringToMetaData(root, TK_ANNOUNCE, this.announce_url.toString());
        TOTorrentAnnounceURLSet[] sets = this.announce_group.getAnnounceURLSets();
        if (sets.length > 0) {
            ArrayList announce_list = new ArrayList();
            for (int i = 0; i < sets.length; ++i) {
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                if (urls.length == 0) continue;
                ArrayList<byte[]> sub_list = new ArrayList<byte[]>();
                announce_list.add(sub_list);
                for (int j = 0; j < urls.length; ++j) {
                    sub_list.add(this.writeStringToMetaData(urls[j].toString()));
                }
            }
            if (announce_list.size() > 0) {
                root.put(TK_ANNOUNCE_LIST, announce_list);
            }
        }
        if (this.comment != null) {
            root.put(TK_COMMENT, this.comment);
        }
        if (this.creation_date != 0L) {
            root.put(TK_CREATION_DATE, new Long(this.creation_date));
        }
        if (this.created_by != null) {
            root.put(TK_CREATED_BY, this.created_by);
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        root.put(TK_INFO, info);
        info.put(TK_PIECE_LENGTH, new Long(this.piece_length));
        if (this.pieces == null) {
            throw new TOTorrentException("Pieces is null", 5);
        }
        byte[] flat_pieces = new byte[this.pieces.length * 20];
        for (int i = 0; i < this.pieces.length; ++i) {
            System.arraycopy(this.pieces[i], 0, flat_pieces, i * 20, 20);
        }
        info.put(TK_PIECES, flat_pieces);
        info.put(TK_NAME, this.torrent_name);
        if (this.torrent_name_utf8 != null) {
            info.put(TK_NAME_UTF8, this.torrent_name_utf8);
        }
        if (this.simple_torrent) {
            TOTorrentFileImpl file = this.files[0];
            info.put(TK_LENGTH, new Long(file.getLength()));
        } else {
            ArrayList meta_files = new ArrayList();
            info.put(TK_FILES, meta_files);
            for (int i = 0; i < this.files.length; ++i) {
                TOTorrentFileImpl file = this.files[i];
                HashMap<String, Serializable> file_map = new HashMap<String, Serializable>();
                meta_files.add(file_map);
                file_map.put(TK_LENGTH, new Long(file.getLength()));
                ArrayList<byte[]> path = new ArrayList<byte[]>();
                file_map.put(TK_PATH, path);
                byte[][] path_comps = file.getPathComponents();
                for (int j = 0; j < path_comps.length; ++j) {
                    path.add(path_comps[j]);
                }
                if (file.isUTF8()) {
                    ArrayList<byte[]> utf8_path = new ArrayList<byte[]>();
                    file_map.put(TK_PATH_UTF8, utf8_path);
                    for (int j = 0; j < path_comps.length; ++j) {
                        utf8_path.add(path_comps[j]);
                    }
                }
                Map file_additional_properties = file.getAdditionalProperties();
                Iterator prop_it = file_additional_properties.keySet().iterator();
                while (prop_it.hasNext()) {
                    String key = (String)prop_it.next();
                    file_map.put(key, (Serializable)file_additional_properties.get(key));
                }
            }
        }
        Iterator info_it = this.additional_info_properties.keySet().iterator();
        while (info_it.hasNext()) {
            String key = (String)info_it.next();
            info.put(key, this.additional_info_properties.get(key));
        }
        Iterator it = this.additional_properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this.additional_properties.get(key);
            if (value == null) continue;
            root.put(key, value);
        }
        return root;
    }

    public void serialiseToXMLFile(File file) throws TOTorrentException {
        TOTorrentXMLSerialiser serialiser = new TOTorrentXMLSerialiser(this);
        serialiser.serialiseToFile(file);
    }

    public byte[] getName() {
        return this.torrent_name;
    }

    protected void setName(byte[] _name) {
        this.torrent_name = _name;
    }

    public boolean isSimpleTorrent() {
        return this.simple_torrent;
    }

    public byte[] getComment() {
        return this.comment;
    }

    protected void setComment(byte[] _comment) {
        this.comment = _comment;
    }

    public void setComment(String _comment) {
        try {
            byte[] utf8_comment = _comment.getBytes("UTF8");
            this.setComment(utf8_comment);
            this.setAdditionalByteArrayProperty(TK_COMMENT_UTF8, utf8_comment);
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            this.comment = null;
        }
    }

    public URL getAnnounceURL() {
        return this.announce_url;
    }

    public boolean setAnnounceURL(URL url) {
        String s1;
        URL newURL = this.anonymityTransform(url);
        String s0 = newURL == null ? "" : newURL.toString();
        String string = s1 = this.announce_url == null ? "" : this.announce_url.toString();
        if (s0.equals(s1)) {
            return false;
        }
        this.announce_url = newURL;
        return true;
    }

    public long getCreationDate() {
        return this.creation_date;
    }

    public void setCreationDate(long _creation_date) {
        this.creation_date = _creation_date;
    }

    protected void setCreatedBy(byte[] _created_by) {
        this.created_by = _created_by;
    }

    protected void setCreatedBy(String _created_by) {
        try {
            this.setCreatedBy(_created_by.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            this.created_by = null;
        }
    }

    public byte[] getCreatedBy() {
        return this.created_by;
    }

    public byte[] getHash() throws TOTorrentException {
        if (this.torrent_hash == null) {
            Map root = this.serialiseToMap();
            Map info = (Map)root.get(TK_INFO);
            this.setHashFromInfo(info);
        }
        return this.torrent_hash;
    }

    public HashWrapper getHashWrapper() throws TOTorrentException {
        if (this.torrent_hash_wrapper == null) {
            this.getHash();
        }
        return this.torrent_hash_wrapper;
    }

    public boolean hasSameHashAs(TOTorrent other) {
        try {
            byte[] other_hash = other.getHash();
            return Arrays.equals(this.getHash(), other_hash);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    protected void setHashFromInfo(Map info) throws TOTorrentException {
        try {
            SHA1Hasher s = new SHA1Hasher();
            this.torrent_hash = s.calculateHash(BEncoder.encode(info));
            this.torrent_hash_wrapper = new HashWrapper(this.torrent_hash);
        }
        catch (Throwable e) {
            throw new TOTorrentException("TOTorrent::setHashFromInfo: fails '" + e.toString() + "'", 8);
        }
    }

    public void setPrivate(boolean _private_torrent) throws TOTorrentException {
        this.additional_info_properties.put(TK_PRIVATE, new Long(_private_torrent ? 1L : 0L));
        this.torrent_hash = null;
        this.getHash();
    }

    public boolean getPrivate() {
        Object o = this.additional_info_properties.get(TK_PRIVATE);
        if (o instanceof Long) {
            return ((Long)o).intValue() != 0;
        }
        return false;
    }

    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return this.announce_group;
    }

    protected void addTorrentAnnounceURLSet(URL[] urls) {
        this.announce_group.addSet(new TOTorrentAnnounceURLSetImpl(this, urls));
    }

    public long getSize() {
        long res = 0L;
        for (int i = 0; i < this.files.length; ++i) {
            res += this.files[i].getLength();
        }
        return res;
    }

    public long getPieceLength() {
        return this.piece_length;
    }

    protected void setPieceLength(long _length) {
        this.piece_length = _length;
    }

    public int getNumberOfPieces() {
        return this.number_of_pieces;
    }

    public byte[][] getPieces() {
        return this.pieces;
    }

    public void setPieces(byte[][] _pieces) {
        this.pieces = _pieces;
        if (this.pieces != null) {
            this.number_of_pieces = this.pieces.length;
        }
    }

    public TOTorrentFile[] getFiles() {
        return this.files;
    }

    protected void setFiles(TOTorrentFileImpl[] _files) {
        this.files = _files;
    }

    protected boolean getSimpleTorrent() {
        return this.simple_torrent;
    }

    protected void setSimpleTorrent(boolean _simple_torrent) {
        this.simple_torrent = _simple_torrent;
    }

    protected Map getAdditionalProperties() {
        return this.additional_properties;
    }

    public void setAdditionalStringProperty(String name, String value) {
        try {
            this.setAdditionalByteArrayProperty(name, this.writeStringToMetaData(value));
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    public String getAdditionalStringProperty(String name) {
        try {
            return this.readStringFromMetaData(this.getAdditionalByteArrayProperty(name));
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public void setAdditionalByteArrayProperty(String name, byte[] value) {
        this.additional_properties.put(name, value);
    }

    public void setAdditionalProperty(String name, Object value) {
        if (name instanceof String) {
            this.setAdditionalStringProperty(name, (String)value);
        } else {
            this.additional_properties.put(name, value);
        }
    }

    public byte[] getAdditionalByteArrayProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public void setAdditionalLongProperty(String name, Long value) {
        this.additional_properties.put(name, value);
    }

    public Long getAdditionalLongProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }

    public void setAdditionalListProperty(String name, List value) {
        this.additional_properties.put(name, value);
    }

    public List getAdditionalListProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    public void setAdditionalMapProperty(String name, Map value) {
        this.additional_properties.put(name, value);
    }

    public Map getAdditionalMapProperty(String name) {
        Object obj = this.additional_properties.get(name);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public Object getAdditionalProperty(String name) {
        return this.additional_properties.get(name);
    }

    public void removeAdditionalProperty(String name) {
        this.additional_properties.remove(name);
    }

    public void removeAdditionalProperties() {
        HashMap new_props = new HashMap();
        Iterator it = this.additional_properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!TK_ADDITIONAL_OK_ATTRS.contains(key)) continue;
            new_props.put(key, this.additional_properties.get(key));
        }
        this.additional_properties = new_props;
    }

    protected void addAdditionalProperty(String name, Object value) {
        this.additional_properties.put(name, value);
    }

    protected void addAdditionalInfoProperty(String name, Object value) {
        this.additional_info_properties.put(name, value);
    }

    protected Map getAdditionalInfoProperties() {
        return this.additional_info_properties;
    }

    protected String readStringFromMetaData(Map meta_data, String name) throws TOTorrentException {
        Object obj = meta_data.get(name);
        if (obj instanceof byte[]) {
            return this.readStringFromMetaData((byte[])obj);
        }
        return null;
    }

    protected String readStringFromMetaData(byte[] value) throws TOTorrentException {
        try {
            if (value == null) {
                return null;
            }
            return new String(value, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("TOTorrentDeserialise: unsupported encoding for '" + value + "'", 7);
        }
    }

    protected void writeStringToMetaData(Map meta_data, String name, String value) throws TOTorrentException {
        meta_data.put(name, this.writeStringToMetaData(value));
    }

    protected byte[] writeStringToMetaData(String value) throws TOTorrentException {
        try {
            return value.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("TOTorrent::writeStringToMetaData: unsupported encoding for '" + value + "'", 7);
        }
    }

    protected URL anonymityTransform(URL url) {
        return url;
    }

    public void print() {
        try {
            byte[] hash = this.getHash();
            System.out.println("name = " + this.torrent_name);
            System.out.println("announce url = " + this.announce_url);
            System.out.println("announce group = " + this.announce_group.getAnnounceURLSets().length);
            System.out.println("creation date = " + this.creation_date);
            System.out.println("creation by = " + this.created_by);
            System.out.println("comment = " + this.comment);
            System.out.println("hash = " + ByteFormatter.nicePrint(hash));
            System.out.println("piece length = " + this.getPieceLength());
            System.out.println("pieces = " + this.getNumberOfPieces());
            Iterator info_it = this.additional_info_properties.keySet().iterator();
            while (info_it.hasNext()) {
                String key = (String)info_it.next();
                Object value = this.additional_info_properties.get(key);
                try {
                    System.out.println("info prop '" + key + "' = '" + (value instanceof byte[] ? new String((byte[])value, "UTF8") : value.toString()) + "'");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("info prop '" + key + "' = unsupported encoding!!!!");
                }
            }
            Iterator it = this.additional_properties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = this.additional_properties.get(key);
                try {
                    System.out.println("prop '" + key + "' = '" + (value instanceof byte[] ? new String((byte[])value, "UTF8") : value.toString()) + "'");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("prop '" + key + "' = unsupported encoding!!!!");
                }
            }
            if (this.pieces == null) {
                System.out.println("\tpieces = null");
            } else {
                for (int i = 0; i < this.pieces.length; ++i) {
                    System.out.println("\t" + ByteFormatter.nicePrint(this.pieces[i]));
                }
            }
            for (int i = 0; i < this.files.length; ++i) {
                byte[][] path_comps = this.files[i].getPathComponents();
                String path_str = "";
                for (int j = 0; j < path_comps.length; ++j) {
                    try {
                        path_str = path_str + (j == 0 ? "" : File.separator) + new String(path_comps[j], "UTF8");
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("file - unsupported encoding!!!!");
                    }
                }
                System.out.println("\t" + path_str + " (" + this.files[i].getLength() + ")");
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    public String getRelationText() {
        return "Torrent: '" + new String(this.torrent_name) + "'";
    }

    public Object[] getQueryableInterfaces() {
        try {
            return new Object[]{AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(this)};
        }
        catch (Exception exception) {
            return null;
        }
    }
}

