/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class BasicConstraints
extends ASN1Encodable {
    DERBoolean cA = new DERBoolean(false);
    DERInteger pathLenConstraint = null;

    public static BasicConstraints getInstance(ASN1TaggedObject obj, boolean explicit) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static BasicConstraints getInstance(Object obj) {
        if (obj == null || obj instanceof BasicConstraints) {
            return (BasicConstraints)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new BasicConstraints((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public BasicConstraints(ASN1Sequence seq) {
        if (seq.size() == 0) {
            this.cA = null;
            this.pathLenConstraint = null;
        } else {
            this.cA = (DERBoolean)seq.getObjectAt(0);
            if (seq.size() > 1) {
                this.pathLenConstraint = (DERInteger)seq.getObjectAt(1);
            }
        }
    }

    public BasicConstraints(boolean cA, int pathLenConstraint) {
        if (cA) {
            this.cA = new DERBoolean(cA);
            this.pathLenConstraint = new DERInteger(pathLenConstraint);
        } else {
            this.cA = null;
            this.pathLenConstraint = null;
        }
    }

    public BasicConstraints(boolean cA) {
        this.cA = cA ? new DERBoolean(true) : null;
        this.pathLenConstraint = null;
    }

    public BasicConstraints(int pathLenConstraint) {
        this.cA = new DERBoolean(true);
        this.pathLenConstraint = new DERInteger(pathLenConstraint);
    }

    public boolean isCA() {
        return this.cA != null && this.cA.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.pathLenConstraint != null) {
            return this.pathLenConstraint.getValue();
        }
        return null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.cA != null) {
            v.add(this.cA);
            if (this.pathLenConstraint != null) {
                v.add(this.pathLenConstraint);
            }
        }
        return new DERSequence(v);
    }

    public String toString() {
        if (this.pathLenConstraint == null) {
            if (this.cA == null) {
                return "BasicConstraints: isCa(false)";
            }
            return "BasicConstraints: isCa(" + this.isCA() + ")";
        }
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.pathLenConstraint.getValue();
    }
}

