/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.VivaldiClient;

public class Vec {
    protected static final int CLASS_HASH = Vec.class.hashCode();
    protected final double[] direction;

    public static Vec add(Vec lhs, Vec rhs) {
        Vec sum = new Vec(lhs);
        sum.add(rhs);
        return sum;
    }

    public static Vec subtract(Vec lhs, Vec rhs) {
        Vec diff = new Vec(lhs);
        diff.subtract(rhs);
        return diff;
    }

    public static Vec scale(Vec lhs, double k) {
        Vec scaled = new Vec(lhs);
        scaled.scale(k);
        return scaled;
    }

    public static Vec makeUnit(Vec v) {
        Vec unit = new Vec(v);
        unit.makeUnit();
        return unit;
    }

    public static Vec makeRandomUnit(int num_dims) {
        Vec v = Vec.makeRandom(num_dims, 1.0);
        v.makeUnit();
        return v;
    }

    public static Vec makeRandom(int num_dims, double axisLength) {
        Vec v = new Vec(num_dims);
        for (int i = 0; i < num_dims; ++i) {
            double length = VivaldiClient.random.nextDouble() * axisLength;
            if (VivaldiClient.random.nextBoolean()) {
                length *= -1.0;
            }
            v.direction[i] = length;
        }
        return v;
    }

    public Vec(int num_dims) {
        this.direction = new double[num_dims];
    }

    public Vec(Vec v) {
        this(v.direction, true);
    }

    public Vec(double[] init_dir, boolean make_copy) {
        if (make_copy) {
            int num_dims = init_dir.length;
            this.direction = new double[num_dims];
            System.arraycopy(init_dir, 0, this.direction, 0, num_dims);
        } else {
            this.direction = init_dir;
        }
    }

    public int getNumDimensions() {
        return this.direction.length;
    }

    public double[] getComponents() {
        int num_dims = this.direction.length;
        double[] dir_copy = new double[num_dims];
        System.arraycopy(this.direction, 0, dir_copy, 0, num_dims);
        return dir_copy;
    }

    public void add(Vec v) {
        int num_dims = this.direction.length;
        for (int i = 0; i < num_dims; ++i) {
            int n = i;
            this.direction[n] = this.direction[n] + v.direction[i];
        }
    }

    public void subtract(Vec v) {
        int num_dims = this.direction.length;
        for (int i = 0; i < num_dims; ++i) {
            int n = i;
            this.direction[n] = this.direction[n] - v.direction[i];
        }
    }

    public void scale(double k) {
        int num_dims = this.direction.length;
        int i = 0;
        while (i < num_dims) {
            int n = i++;
            this.direction[n] = this.direction[n] * k;
        }
    }

    public boolean isUnit() {
        return this.getLength() == 1.0;
    }

    public double getLength() {
        double sum = 0.0;
        int num_dims = this.direction.length;
        for (int i = 0; i < num_dims; ++i) {
            sum += this.direction[i] * this.direction[i];
        }
        return Math.sqrt(sum);
    }

    public void makeUnit() {
        double length = this.getLength();
        if (length != 1.0) {
            int num_dims = this.direction.length;
            int i = 0;
            while (i < num_dims) {
                int n = i++;
                this.direction[n] = this.direction[n] / length;
            }
        }
    }

    public Coordinate asCoordinateFromZero(boolean make_copy) {
        return new Coordinate(this.direction, make_copy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec) {
            Vec v = (Vec)obj;
            int num_dims = this.direction.length;
            for (int i = 0; i < num_dims; ++i) {
                if (this.direction[i] == v.direction[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int num_dims = this.direction.length;
        int hc = CLASS_HASH;
        for (int i = 0; i < num_dims; ++i) {
            hc ^= new Double(this.direction[i]).hashCode();
        }
        return hc;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(1024);
        sbuf.append("[");
        int num_dims = this.direction.length;
        int i = 0;
        while (true) {
            sbuf.append(VivaldiClient.nf.format(this.direction[i]));
            if (++i >= num_dims) break;
            sbuf.append(",");
        }
        sbuf.append("]");
        return sbuf.toString();
    }
}

