/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManager;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.net.natpmp.NATPMPDeviceAdapter;
import com.aelitis.net.natpmp.NatPMPDeviceFactory;
import com.aelitis.net.natpmp.upnp.NatPMPUPnP;
import com.aelitis.net.natpmp.upnp.NatPMPUPnPFactory;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionListener;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPPlugin
implements Plugin,
UPnPListener,
UPnPMappingListener,
UPnPWANConnectionListener {
    private static final String UPNP_PLUGIN_CONFIGSECTION_ID = "UPnP";
    private static final String NATPMP_PLUGIN_CONFIGSECTION_ID = "NATPMP";
    private static final String STATS_DISCOVER = "discover";
    private static final String STATS_FOUND = "found";
    private static final String STATS_READ_OK = "read_ok";
    private static final String STATS_READ_BAD = "read_bad";
    private static final String STATS_MAP_OK = "map_ok";
    private static final String STATS_MAP_BAD = "map_bad";
    private static final String[] STATS_KEYS = new String[]{"discover", "found", "read_ok", "read_bad", "map_ok", "map_bad"};
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private UPnPMappingManager mapping_manager = UPnPMappingManager.getSingleton(this);
    private UPnP upnp;
    private NatPMPUPnP nat_pmp_upnp;
    private BooleanParameter natpmp_enable_param;
    private StringParameter nat_pmp_router;
    private BooleanParameter upnp_enable_param;
    private BooleanParameter alert_success_param;
    private BooleanParameter grab_ports_param;
    private BooleanParameter alert_other_port_param;
    private BooleanParameter alert_device_probs_param;
    private BooleanParameter release_mappings_param;
    private StringParameter selected_interfaces_param;
    private BooleanParameter ignore_bad_devices;
    private LabelParameter ignored_devices_list;
    private List mappings = new ArrayList();
    private List services = new ArrayList();
    private Map root_info_map = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("UPnPPlugin");

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Universal Plug and Play (UPnP)");
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(UPNP_PLUGIN_CONFIGSECTION_ID);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(UPNP_PLUGIN_CONFIGSECTION_ID);
        model.setConfigSectionID(UPNP_PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel upnp_config = ui_manager.createBasicPluginConfigModel("plugins", UPNP_PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel natpmp_config = ui_manager.createBasicPluginConfigModel(UPNP_PLUGIN_CONFIGSECTION_ID, NATPMP_PLUGIN_CONFIGSECTION_ID);
        natpmp_config.addLabelParameter2("natpmp.info");
        ActionParameter natpmp_wiki = natpmp_config.addActionParameter2("Utils.link.visit", "MainWindow.about.internet.wiki");
        natpmp_wiki.setStyle(2);
        natpmp_wiki.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                try {
                    UPnPPlugin.this.plugin_interface.getUIManager().openURL(new URL("http://azureus.aelitis.com/wiki/index.php/NATPMP"));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.natpmp_enable_param = natpmp_config.addBooleanParameter2("natpmp.enable", "natpmp.enable", false);
        this.nat_pmp_router = natpmp_config.addStringParameter2("natpmp.routeraddress", "natpmp.routeraddress", "");
        this.natpmp_enable_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                UPnPPlugin.this.setNATPMPEnableState();
            }
        });
        this.natpmp_enable_param.addEnabledOnSelection(this.nat_pmp_router);
        upnp_config.addLabelParameter2("upnp.info");
        ActionParameter upnp_wiki = upnp_config.addActionParameter2("Utils.link.visit", "MainWindow.about.internet.wiki");
        upnp_wiki.setStyle(2);
        upnp_wiki.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                try {
                    UPnPPlugin.this.plugin_interface.getUIManager().openURL(new URL("http://azureus.aelitis.com/wiki/index.php/UPnP"));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.upnp_enable_param = upnp_config.addBooleanParameter2("upnp.enable", "upnp.enable", true);
        this.grab_ports_param = upnp_config.addBooleanParameter2("upnp.grabports", "upnp.grabports", false);
        this.release_mappings_param = upnp_config.addBooleanParameter2("upnp.releasemappings", "upnp.releasemappings", true);
        ActionParameter refresh_param = upnp_config.addActionParameter2("upnp.refresh.label", "upnp.refresh.button");
        refresh_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                UPnPPlugin.this.upnp.reset();
            }
        });
        upnp_config.addLabelParameter2("blank.resource");
        this.alert_success_param = upnp_config.addBooleanParameter2("upnp.alertsuccess", "upnp.alertsuccess", false);
        this.alert_other_port_param = upnp_config.addBooleanParameter2("upnp.alertothermappings", "upnp.alertothermappings", true);
        this.alert_device_probs_param = upnp_config.addBooleanParameter2("upnp.alertdeviceproblems", "upnp.alertdeviceproblems", true);
        this.selected_interfaces_param = upnp_config.addStringParameter2("upnp.selectedinterfaces", "upnp.selectedinterfaces", "");
        this.ignore_bad_devices = upnp_config.addBooleanParameter2("upnp.ignorebaddevices", "upnp.ignorebaddevices", true);
        this.ignored_devices_list = upnp_config.addLabelParameter2("upnp.ignorebaddevices.info");
        ActionParameter reset_param = upnp_config.addActionParameter2("upnp.ignorebaddevices.reset", "upnp.ignorebaddevices.reset.action");
        reset_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                PluginConfig pc = UPnPPlugin.this.plugin_interface.getPluginconfig();
                for (int i = 0; i < STATS_KEYS.length; ++i) {
                    String key = "upnp.device.stats." + STATS_KEYS[i];
                    pc.setPluginMapParameter(key, new HashMap());
                }
                pc.setPluginMapParameter("upnp.device.ignorelist", new HashMap());
                UPnPPlugin.this.updateIgnoreList();
            }
        });
        this.upnp_enable_param.addEnabledOnSelection(this.alert_success_param);
        this.upnp_enable_param.addEnabledOnSelection(this.grab_ports_param);
        this.upnp_enable_param.addEnabledOnSelection(refresh_param);
        this.upnp_enable_param.addEnabledOnSelection(this.alert_other_port_param);
        this.upnp_enable_param.addEnabledOnSelection(this.alert_device_probs_param);
        this.upnp_enable_param.addEnabledOnSelection(this.release_mappings_param);
        this.upnp_enable_param.addEnabledOnSelection(this.selected_interfaces_param);
        this.upnp_enable_param.addEnabledOnSelection(this.ignore_bad_devices);
        this.upnp_enable_param.addEnabledOnSelection(this.ignored_devices_list);
        this.upnp_enable_param.addEnabledOnSelection(reset_param);
        final boolean enabled = this.upnp_enable_param.getValue();
        this.natpmp_enable_param.setEnabled(enabled);
        model.getStatus().setText(enabled ? "Running" : "Disabled");
        this.upnp_enable_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter p) {
                boolean e = UPnPPlugin.this.upnp_enable_param.getValue();
                UPnPPlugin.this.natpmp_enable_param.setEnabled(e);
                model.getStatus().setText(e ? "Running" : "Disabled");
                if (e) {
                    UPnPPlugin.this.startUp();
                } else {
                    UPnPPlugin.this.closeDown(true);
                }
                UPnPPlugin.this.setNATPMPEnableState();
            }
        });
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                if (enabled) {
                    UPnPPlugin.this.updateIgnoreList();
                    UPnPPlugin.this.startUp();
                }
            }

            public void closedownInitiated() {
                if (UPnPPlugin.this.services.size() == 0) {
                    UPnPPlugin.this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", "");
                }
            }

            public void closedownComplete() {
                UPnPPlugin.this.closeDown(true);
            }
        });
    }

    protected void updateIgnoreList() {
        try {
            String param = "";
            PluginConfig pc = this.plugin_interface.getPluginconfig();
            Map ignored = pc.getPluginMapParameter("upnp.device.ignorelist", new HashMap());
            Iterator it = ignored.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Map value = (Map)entry.getValue();
                param = param + "\n    " + entry.getKey() + ": " + new String((byte[])value.get("Location"));
            }
            if (ignored.size() > 0) {
                this.log.log("Devices currently being ignored: " + param);
            }
            String text = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("upnp.ignorebaddevices.info", new String[]{param});
            this.ignored_devices_list.setLabelText(text);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void ignoreDevice(String USN, URL location) {
        try {
            PluginConfig pc = this.plugin_interface.getPluginconfig();
            Map ignored = pc.getPluginMapParameter("upnp.device.ignorelist", new HashMap());
            HashMap<String, byte[]> entry = (HashMap<String, byte[]>)ignored.get(USN);
            if (entry == null) {
                entry = new HashMap<String, byte[]>();
                entry.put("Location", location.toString().getBytes());
                ignored.put(USN, entry);
                pc.setPluginMapParameter("upnp.device.ignorelist", ignored);
                this.updateIgnoreList();
                String text = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("upnp.ignorebaddevices.alert", new String[]{location.toString()});
                this.log.logAlertRepeatable(2, text);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void startUp() {
        if (this.upnp != null) {
            this.upnp.reset();
            return;
        }
        final LoggerChannel core_log = this.plugin_interface.getLogger().getChannel("UPnP Core");
        try {
            this.upnp = UPnPFactory.getSingleton(new UPnPAdapter(){
                Set exception_traces = new HashSet();

                public SimpleXMLParserDocument parseXML(String data) throws SimpleXMLParserDocumentException {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(data);
                }

                public ResourceDownloaderFactory getResourceDownloaderFactory() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                }

                public UTTimer createTimer(String name) {
                    return UPnPPlugin.this.plugin_interface.getUtilities().createTimer(name, true);
                }

                public void createThread(String name, Runnable runnable) {
                    UPnPPlugin.this.plugin_interface.getUtilities().createThread(name, runnable);
                }

                public Comparator getAlphanumericComparator() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
                }

                public void trace(String str) {
                    core_log.log(str);
                }

                public void log(Throwable e) {
                    String nested = Debug.getNestedExceptionMessage(e);
                    if (!this.exception_traces.contains(nested)) {
                        this.exception_traces.add(nested);
                        if (this.exception_traces.size() > 128) {
                            this.exception_traces.clear();
                        }
                        core_log.log(e);
                    } else {
                        core_log.log(nested);
                    }
                }

                public void log(String str) {
                    UPnPPlugin.this.log.log(str);
                }

                public String getTraceDir() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getAzureusUserDir();
                }
            }, this.getSelectedInterfaces());
            this.upnp.addRootDeviceListener(this);
            this.upnp.addLogListener(new UPnPLogListener(){

                public void log(String str) {
                    UPnPPlugin.this.log.log(str);
                }

                public void logAlert(String str, boolean error, int type) {
                    boolean logged = false;
                    if (UPnPPlugin.this.alert_device_probs_param.getValue()) {
                        if (type == 1) {
                            UPnPPlugin.this.log.logAlertRepeatable(error ? 3 : 2, str);
                            logged = true;
                        } else {
                            boolean do_it = false;
                            if (type == 3) {
                                byte[] fp = UPnPPlugin.this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(str.getBytes());
                                String key = "upnp.alert.fp." + UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(fp);
                                PluginConfig pc = UPnPPlugin.this.plugin_interface.getPluginconfig();
                                if (!pc.getPluginBooleanParameter(key, false)) {
                                    pc.setPluginParameter(key, true);
                                    do_it = true;
                                }
                            } else {
                                do_it = true;
                            }
                            if (do_it) {
                                UPnPPlugin.this.log.logAlert(error ? 3 : 2, str);
                                logged = true;
                            }
                        }
                    }
                    if (!logged) {
                        UPnPPlugin.this.log.log(str);
                    }
                }
            });
            this.mapping_manager.addListener(new UPnPMappingManagerListener(){

                public void mappingAdded(UPnPMapping mapping) {
                    UPnPPlugin.this.addMapping(mapping);
                }
            });
            UPnPMapping[] upnp_mappings = this.mapping_manager.getMappings();
            for (int i = 0; i < upnp_mappings.length; ++i) {
                this.addMapping(upnp_mappings[i]);
            }
            this.setNATPMPEnableState();
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    protected void closeDown(boolean end_of_day) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
            if (!mapping.isEnabled()) continue;
            for (int j = 0; j < this.services.size(); ++j) {
                UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                service.removeMapping(this.log, mapping, end_of_day);
            }
        }
    }

    public boolean deviceDiscovered(String USN, URL location) {
        if (!this.ignore_bad_devices.getValue()) {
            return true;
        }
        this.incrementDeviceStats(USN, STATS_DISCOVER);
        boolean ok = this.checkDeviceStats(USN, location);
        String stats = "";
        for (int i = 0; i < STATS_KEYS.length; ++i) {
            stats = stats + (i == 0 ? "" : ",") + STATS_KEYS[i] + "=" + this.getDeviceStats(USN, STATS_KEYS[i]);
        }
        if (!ok) {
            this.log.log("Device '" + location + "' is being ignored: " + stats);
        } else {
            this.log.log("Device '" + location + "' is ok: " + stats);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootDeviceFound(UPnPRootDevice device) {
        this.incrementDeviceStats(device.getUSN(), STATS_FOUND);
        this.checkDeviceStats(device);
        try {
            this.processDevice(device.getDevice());
            try {
                this.this_mon.enter();
                this.root_info_map.put(device.getLocation(), device.getInfo());
                Iterator it = this.root_info_map.values().iterator();
                String all_info = "";
                ArrayList<String> reported_info = new ArrayList<String>();
                while (it.hasNext()) {
                    String info = (String)it.next();
                    if (info == null || reported_info.contains(info)) continue;
                    reported_info.add(info);
                    all_info = all_info + (all_info.length() == 0 ? "" : ",") + info;
                }
                if (all_info.length() > 0) {
                    this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", all_info);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        catch (Throwable e) {
            this.log.log("Root device processing fails", e);
        }
    }

    protected boolean checkDeviceStats(UPnPRootDevice root) {
        return this.checkDeviceStats(root.getUSN(), root.getLocation());
    }

    protected boolean checkDeviceStats(String USN, URL location) {
        long discovers = this.getDeviceStats(USN, STATS_DISCOVER);
        long founds = this.getDeviceStats(USN, STATS_FOUND);
        if (discovers > 3L && founds == 0L) {
            this.ignoreDevice(USN, location);
            return false;
        }
        if (founds > 0L) {
            this.setDeviceStats(USN, STATS_DISCOVER, 0L);
            this.setDeviceStats(USN, STATS_FOUND, 0L);
        }
        long map_ok = this.getDeviceStats(USN, STATS_MAP_OK);
        long map_bad = this.getDeviceStats(USN, STATS_MAP_BAD);
        if (map_bad > 5L && map_ok == 0L) {
            this.ignoreDevice(USN, location);
            return false;
        }
        if (map_ok > 0L) {
            this.setDeviceStats(USN, STATS_MAP_OK, 0L);
            this.setDeviceStats(USN, STATS_MAP_BAD, 0L);
        }
        return true;
    }

    protected long incrementDeviceStats(String USN, String stat_key) {
        String key = "upnp.device.stats." + stat_key;
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        Map counts = pc.getPluginMapParameter(key, new HashMap());
        Long count = (Long)counts.get(USN);
        count = count == null ? new Long(1L) : new Long(count + 1L);
        counts.put(USN, count);
        pc.getPluginMapParameter(key, counts);
        return count;
    }

    protected long getDeviceStats(String USN, String stat_key) {
        String key = "upnp.device.stats." + stat_key;
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        Map counts = pc.getPluginMapParameter(key, new HashMap());
        Long count = (Long)counts.get(USN);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    protected void setDeviceStats(String USN, String stat_key, long value) {
        String key = "upnp.device.stats." + stat_key;
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        Map counts = pc.getPluginMapParameter(key, new HashMap());
        counts.put(USN, new Long(value));
        pc.getPluginMapParameter(key, counts);
    }

    public void mappingResult(UPnPWANConnection connection, boolean ok) {
        UPnPRootDevice root = connection.getGenericService().getDevice().getRootDevice();
        this.incrementDeviceStats(root.getUSN(), ok ? STATS_MAP_OK : STATS_MAP_BAD);
        this.checkDeviceStats(root);
    }

    public void mappingsReadResult(UPnPWANConnection connection, boolean ok) {
        UPnPRootDevice root = connection.getGenericService().getDevice().getRootDevice();
        this.incrementDeviceStats(root.getUSN(), ok ? STATS_READ_OK : STATS_READ_BAD);
    }

    protected String[] getSelectedInterfaces() {
        String si = this.selected_interfaces_param.getValue().trim();
        StringTokenizer tok = new StringTokenizer(si, ";");
        ArrayList<String> res = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            if (s.length() <= 0) continue;
            res.add(s);
        }
        return res.toArray(new String[res.size()]);
    }

    protected void processDevice(UPnPDevice device) throws UPnPException {
        this.processServices(device, device.getServices());
        UPnPDevice[] kids = device.getSubDevices();
        for (int i = 0; i < kids.length; ++i) {
            this.processDevice(kids[i]);
        }
    }

    protected void processServices(UPnPDevice device, UPnPService[] device_services) throws UPnPException {
        for (int i = 0; i < device_services.length; ++i) {
            UPnPService s = device_services[i];
            String service_type = s.getServiceType();
            if (service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1") || service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
                final UPnPWANConnection wan_service = (UPnPWANConnection)s.getSpecificService();
                device.getRootDevice().addListener(new UPnPRootDeviceListener(){

                    public void lost(UPnPRootDevice root, boolean replaced) {
                        UPnPPlugin.this.removeService(wan_service, replaced);
                    }
                });
                this.addService(wan_service);
                continue;
            }
            if (!service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1")) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addService(UPnPWANConnection wan_service) throws UPnPException {
        wan_service.addListener(this);
        this.mapping_manager.serviceFound(wan_service);
        try {
            UPnPWANConnectionPortMapping[] ports;
            this.this_mon.enter();
            this.log.log("    Found " + (wan_service.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection"));
            String usn = wan_service.getGenericService().getDevice().getRootDevice().getUSN();
            if (this.getDeviceStats(usn, STATS_READ_OK) == 0L && this.getDeviceStats(usn, STATS_READ_BAD) > 2L) {
                ports = new UPnPWANConnectionPortMapping[]{};
                wan_service.periodicallyRecheckMappings(false);
                this.log.log("    Not reading port mappings from device due to previous failures");
            } else {
                ports = wan_service.getPortMappings();
            }
            for (int j = 0; j < ports.length; ++j) {
                this.log.log("      mapping [" + j + "] " + ports[j].getExternalPort() + "/" + (ports[j].isTCP() ? "TCP" : "UDP") + " [" + ports[j].getDescription() + "] -> " + ports[j].getInternalHost());
            }
            this.services.add(new UPnPPluginService(wan_service, ports, this.alert_success_param, this.grab_ports_param, this.alert_other_port_param, this.release_mappings_param));
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeService(UPnPWANConnection wan_service, boolean replaced) {
        try {
            this.this_mon.enter();
            String name = wan_service.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection";
            String text = MessageText.getString("upnp.alert.lostdevice", new String[]{name, wan_service.getGenericService().getDevice().getRootDevice().getLocation().getHost()});
            this.log.log(text);
            if (!replaced && this.alert_device_probs_param.getValue()) {
                this.log.logAlertRepeatable(2, text);
            }
            for (int i = 0; i < this.services.size(); ++i) {
                UPnPPluginService ps = (UPnPPluginService)this.services.get(i);
                if (ps.getService() != wan_service) continue;
                this.services.remove(i);
                break;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMapping(UPnPMapping mapping) {
        try {
            this.this_mon.enter();
            this.mappings.add(mapping);
            this.log.log("Mapping request: " + mapping.getString() + ", enabled = " + mapping.isEnabled());
            mapping.addListener(this);
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void mappingChanged(UPnPMapping mapping) {
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappingDestroyed(UPnPMapping mapping) {
        try {
            this.this_mon.enter();
            this.mappings.remove(mapping);
            for (int j = 0; j < this.services.size(); ++j) {
                UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                service.removeMapping(this.log, mapping, false);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.mappings.size(); ++i) {
                UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
                for (int j = 0; j < this.services.size(); ++j) {
                    UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                    service.checkMapping(this.log, mapping);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExternalIPAddresses() {
        ArrayList<String> res = new ArrayList<String>();
        try {
            this.this_mon.enter();
            for (int j = 0; j < this.services.size(); ++j) {
                UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                try {
                    String address = service.getService().getExternalIPAddress();
                    if (address == null) continue;
                    res.add(address);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        return res.toArray(new String[res.size()]);
    }

    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        return this.mapping_manager.addMapping(desc_resource, tcp, port, enabled);
    }

    public UPnPMapping getMapping(boolean tcp, int port) {
        return this.mapping_manager.getMapping(tcp, port);
    }

    protected void setNATPMPEnableState() {
        boolean enabled = this.natpmp_enable_param.getValue() && this.upnp_enable_param.getValue();
        try {
            if (enabled) {
                if (this.nat_pmp_upnp == null) {
                    this.nat_pmp_upnp = NatPMPUPnPFactory.create(this.upnp, NatPMPDeviceFactory.getSingleton(new NATPMPDeviceAdapter(){

                        public String getRouterAddress() {
                            return UPnPPlugin.this.nat_pmp_router.getValue();
                        }

                        public void log(String str) {
                            UPnPPlugin.this.log.log("NAT-PMP: " + str);
                        }
                    }));
                    this.nat_pmp_upnp.addListener(this);
                }
                this.nat_pmp_upnp.setEnabled(true);
            } else if (this.nat_pmp_upnp != null) {
                this.nat_pmp_upnp.setEnabled(false);
            }
        }
        catch (Throwable e) {
            this.log.log("Failed to initialise NAT-PMP subsystem", e);
        }
    }

    protected void logAlert(int type, String resource, String[] params) {
        String text = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText(resource, params);
        this.log.logAlertRepeatable(type, text);
    }
}

