/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderGetRight
extends ExternalSeedReaderImpl {
    private static final int TARGET_REQUEST_SIZE_DEFAULT = 262144;
    private URL url;
    private String ip;
    private int port;
    private ExternalSeedHTTPDownloader http_downloader;
    private int piece_size;
    private int min_availability;
    private int min_speed;
    private long valid_until;
    private int piece_group_size;

    protected ExternalSeedReaderGetRight(ExternalSeedPlugin _plugin, Torrent _torrent, URL _url, Map _params) {
        super(_plugin, _torrent);
        this.min_availability = this.getIntParam(_params, "min_avail", 1);
        this.min_speed = this.getIntParam(_params, "min_speed", 0);
        this.valid_until = this.getIntParam(_params, "valid_ms", 0);
        int target_request_size = this.getIntParam(_params, "req_size", 262144);
        if (this.valid_until > 0L) {
            this.valid_until += this.getSystemTime();
        }
        this.url = _url;
        this.ip = this.url.getHost();
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        this.http_downloader = new ExternalSeedHTTPDownloader(this.url, this.getUserAgent());
        this.piece_size = (int)this.getTorrent().getPieceSize();
        this.piece_group_size = target_request_size / this.piece_size;
        if (this.piece_group_size == 0) {
            this.piece_group_size = 1;
        }
    }

    public boolean sameAs(ExternalSeedReader other) {
        if (other instanceof ExternalSeedReaderGetRight) {
            return this.url.toString().equals(((ExternalSeedReaderGetRight)other).url.toString());
        }
        return false;
    }

    protected int getIntParam(Map map, String name, int def) {
        Object obj = map.get(name);
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        return def;
    }

    public String getName() {
        return "GR: " + this.url;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    protected boolean readyToActivate(PeerManager peer_manager, Peer peer) {
        int fail_count = this.getFailureCount();
        if (fail_count > 0) {
            int delay = 30000;
            for (int i = 1; i < fail_count && (delay += delay) <= 1800000; ++i) {
            }
            long now = this.getSystemTime();
            long last_fail = this.getLastFailTime();
            if (last_fail < now && now - last_fail < (long)delay) {
                return false;
            }
        }
        try {
            float availability;
            if (this.valid_until > 0L && this.getSystemTime() > this.valid_until) {
                return false;
            }
            if (peer_manager.getDownload().getState() == 5) {
                return false;
            }
            if (this.min_availability > 0 && (availability = peer_manager.getDownload().getStats().getAvailability()) < (float)this.min_availability) {
                this.log(this.getName() + ": activating as availability is poor");
                return true;
            }
            if (this.min_speed > 0 && peer_manager.getStats().getDownloadAverage() < (long)this.min_speed) {
                this.log(this.getName() + ": activating as speed is slow");
                return true;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    protected boolean readyToDeactivate(PeerManager peer_manager, Peer peer) {
        try {
            float availability;
            if (this.valid_until > 0L && this.getSystemTime() > this.valid_until) {
                return true;
            }
            if (peer_manager.getDownload().getState() == 5) {
                return true;
            }
            if (this.min_availability > 0 && (availability = peer_manager.getDownload().getStats().getAvailability()) >= (float)(this.min_availability + 1)) {
                this.log(this.getName() + ": deactivating as availability is good");
                return true;
            }
            if (this.min_speed > 0) {
                long my_speed = peer.getStats().getDownloadAverage();
                long overall_speed = peer_manager.getStats().getDownloadAverage();
                if (overall_speed - my_speed > (long)(2 * this.min_speed)) {
                    this.log(this.getName() + ": deactivating as speed is good");
                    return true;
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return false;
    }

    protected int getPieceGroupSize() {
        return this.piece_group_size;
    }

    protected boolean getRequestCanSpanPieces() {
        return true;
    }

    protected void readData(ExternalSeedReaderRequest request2) throws ExternalSeedException {
        this.http_downloader.downloadRange(request2.getStartPieceNumber() * this.piece_size + request2.getStartPieceOffset(), request2.getLength(), request2);
    }
}

