/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderListener;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.Piece;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Semaphore;

public abstract class ExternalSeedReaderImpl
implements ExternalSeedReader {
    private ExternalSeedPlugin plugin;
    private Torrent torrent;
    private String status;
    private boolean active;
    private boolean permanent_fail;
    private long last_failed_read;
    private int consec_failures;
    private String user_agent;
    private long peer_manager_change_time;
    private volatile PeerManager current_manager;
    private List requests = new LinkedList();
    private volatile int request_count;
    private Thread request_thread;
    private Semaphore request_sem;
    private Monitor requests_mon;
    private int[] priority_offsets;
    private List listeners = new ArrayList();

    protected ExternalSeedReaderImpl(ExternalSeedPlugin _plugin, Torrent _torrent) {
        this.plugin = _plugin;
        this.torrent = _torrent;
        this.requests_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        this.request_sem = this.plugin.getPluginInterface().getUtilities().getSemaphore();
        PluginInterface pi = this.plugin.getPluginInterface();
        this.user_agent = pi.getAzureusName();
        try {
            Properties props = new Properties();
            pi.getClientIDManager().getGenerator().generateHTTPProperties(props);
            String ua = props.getProperty("User-Agent");
            if (ua != null) {
                this.user_agent = ua;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.setActive(false);
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    public String getStatus() {
        return this.status;
    }

    protected void log(String str) {
        this.plugin.log(str);
    }

    protected String getUserAgent() {
        return this.user_agent;
    }

    protected long getSystemTime() {
        return this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
    }

    protected int getFailureCount() {
        return this.consec_failures;
    }

    protected long getLastFailTime() {
        return this.last_failed_read;
    }

    public boolean isPermanentlyUnavailable() {
        return this.permanent_fail;
    }

    protected abstract boolean readyToActivate(PeerManager var1, Peer var2);

    protected abstract boolean readyToDeactivate(PeerManager var1, Peer var2);

    public boolean checkActivation(PeerManager peer_manager, Peer peer) {
        long now = this.getSystemTime();
        if (peer_manager == this.current_manager) {
            if (this.peer_manager_change_time > now) {
                this.peer_manager_change_time = now;
            }
            if (peer_manager != null) {
                if (this.active) {
                    if (now - this.peer_manager_change_time > 30000L && this.readyToDeactivate(peer_manager, peer)) {
                        this.setActive(false);
                    }
                } else if (!this.isPermanentlyUnavailable() && now - this.peer_manager_change_time > 30000L && this.readyToActivate(peer_manager, peer)) {
                    this.setActive(true);
                }
            }
        } else {
            this.peer_manager_change_time = now;
            this.current_manager = peer_manager;
            this.setActive(false);
        }
        return this.active;
    }

    public void deactivate(String reason) {
        this.plugin.log(this.getName() + ": deactivating (" + reason + ")");
        this.checkActivation(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean _active) {
        try {
            this.requests_mon.enter();
            this.active = _active;
            this.status = this.active ? "Active" : "Idle";
        }
        finally {
            this.requests_mon.exit();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequests() {
        try {
            this.requests_mon.enter();
            if (this.request_thread != null) {
                return;
            }
            this.request_thread = Thread.currentThread();
        }
        finally {
            this.requests_mon.exit();
        }
        block12: while (true) {
            try {
                while (true) {
                    if (!this.request_sem.reserve(30000L)) {
                        try {
                            this.requests_mon.enter();
                            if (this.requests.size() != 0) continue;
                            this.request_thread = null;
                            break block12;
                        }
                        finally {
                            this.requests_mon.exit();
                            continue;
                        }
                    }
                    ArrayList<PeerReadRequest> selected_requests = new ArrayList<PeerReadRequest>();
                    PeerReadRequest cancelled_request = null;
                    try {
                        this.requests_mon.enter();
                        int count = this.selectRequests(this.requests);
                        if (count <= 0 || count > this.requests.size()) {
                            Debug.out("invalid count");
                            count = 1;
                        }
                        for (int i = 0; i < count; ++i) {
                            PeerReadRequest request2 = (PeerReadRequest)this.requests.remove(0);
                            if (request2.isCancelled()) {
                                if (i == 0) {
                                    cancelled_request = request2;
                                } else {
                                    this.requests.add(0, request2);
                                }
                                break;
                            }
                            selected_requests.add(request2);
                            --this.request_count;
                            if (i <= 0) continue;
                            this.request_sem.reserve();
                        }
                    }
                    finally {
                        this.requests_mon.exit();
                    }
                    if (cancelled_request != null) {
                        this.informCancelled(cancelled_request);
                        continue;
                    }
                    this.processRequests(selected_requests);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public int getMaximumNumberOfRequests() {
        if (this.getRequestCount() == 0) {
            return (int)((long)this.getPieceGroupSize() * this.torrent.getPieceSize() / 16384L);
        }
        return 0;
    }

    public void calculatePriorityOffsets(PeerManager peer_manager, int[] base_priorities) {
        try {
            Piece[] pieces = peer_manager.getPieces();
            int piece_group_size = this.getPieceGroupSize();
            int[] contiguous_best_pieces = new int[piece_group_size];
            int[] contiguous_highest_pri = new int[piece_group_size];
            Arrays.fill(contiguous_highest_pri, -1);
            int contiguous = 0;
            int contiguous_best_pri = -1;
            int max_contiguous = 0;
            int max_free_reqs = 0;
            int max_free_reqs_piece = -1;
            for (int i = 0; i < pieces.length; ++i) {
                int free_reqs;
                Piece piece = pieces[i];
                if (piece.isFullyAllocatable()) {
                    ++contiguous;
                    int base_pri = base_priorities[i];
                    if (base_pri > contiguous_best_pri) {
                        contiguous_best_pri = base_pri;
                    }
                    for (int j = 0; j < contiguous && j < contiguous_highest_pri.length; ++j) {
                        if (contiguous_best_pri > contiguous_highest_pri[j]) {
                            contiguous_highest_pri[j] = contiguous_best_pri;
                            contiguous_best_pieces[j] = i - j;
                        }
                        if (j + 1 <= max_contiguous) continue;
                        max_contiguous = j + 1;
                    }
                    continue;
                }
                contiguous = 0;
                contiguous_best_pri = -1;
                if (max_contiguous != 0 || (free_reqs = piece.getAllocatableRequestCount()) <= max_free_reqs) continue;
                max_free_reqs = free_reqs;
                max_free_reqs_piece = i;
            }
            if (max_contiguous == 0) {
                if (max_free_reqs_piece >= 0) {
                    this.priority_offsets = new int[(int)this.getTorrent().getPieceCount()];
                    this.priority_offsets[max_free_reqs_piece] = 10000;
                } else {
                    this.priority_offsets = null;
                }
            } else {
                int start_piece;
                this.priority_offsets = new int[(int)this.getTorrent().getPieceCount()];
                for (int i = start_piece = contiguous_best_pieces[max_contiguous - 1]; i < start_piece + max_contiguous; ++i) {
                    this.priority_offsets[i] = 10000 - (i - start_piece);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.priority_offsets = null;
        }
    }

    protected abstract int getPieceGroupSize();

    protected abstract boolean getRequestCanSpanPieces();

    public int[] getPriorityOffsets() {
        return this.priority_offsets;
    }

    protected int selectRequests(List requests) {
        long next_start = -1L;
        int last_piece_number = -1;
        for (int i = 0; i < requests.size(); ++i) {
            PeerReadRequest request2 = (PeerReadRequest)requests.get(i);
            int this_piece_number = request2.getPieceNumber();
            if (last_piece_number != -1 && last_piece_number != this_piece_number && !this.getRequestCanSpanPieces()) {
                return i;
            }
            long this_start = (long)this_piece_number * this.torrent.getPieceSize() + (long)request2.getOffset();
            if (next_start != -1L && this_start != next_start) {
                return i;
            }
            next_start = this_start + (long)request2.getLength();
            last_piece_number = this_piece_number;
        }
        return requests.size();
    }

    protected abstract void readData(ExternalSeedReaderRequest var1) throws ExternalSeedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequests(List requests) {
        block14: {
            boolean ok = false;
            ExternalSeedReaderRequest request2 = new ExternalSeedReaderRequest(this, requests);
            try {
                try {
                    this.readData(request2);
                    ok = true;
                }
                catch (ExternalSeedException e) {
                    if (e.isPermanentFailure()) {
                        this.permanent_fail = true;
                    }
                    this.status = "Failed: " + Debug.getNestedExceptionMessage(e);
                    request2.failed();
                    Object var6_5 = null;
                    if (ok) {
                        this.last_failed_read = 0L;
                        this.consec_failures = 0;
                    } else {
                        this.last_failed_read = this.getSystemTime();
                        ++this.consec_failures;
                    }
                    break block14;
                }
                catch (Throwable e) {
                    this.status = "Failed: " + Debug.getNestedExceptionMessage(e);
                    request2.failed();
                    Object var6_6 = null;
                    if (ok) {
                        this.last_failed_read = 0L;
                        this.consec_failures = 0;
                    } else {
                        this.last_failed_read = this.getSystemTime();
                        ++this.consec_failures;
                    }
                }
                Object var6_4 = null;
                if (ok) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (ok) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequests(List new_requests) {
        try {
            this.requests_mon.enter();
            if (!this.active) {
                Debug.out("request added when not active!!!!");
            }
            for (int i = 0; i < new_requests.size(); ++i) {
                this.requests.add(new_requests.get(i));
                this.request_sem.release();
            }
            this.request_count = this.requests.size();
            if (this.request_thread == null) {
                this.plugin.getPluginInterface().getUtilities().createThread("RequestProcessor", new Runnable(){

                    public void run() {
                        ExternalSeedReaderImpl.this.processRequests();
                    }
                });
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(PeerReadRequest request2) {
        try {
            this.requests_mon.enter();
            if (this.requests.contains(request2) && !request2.isCancelled()) {
                request2.cancel();
                --this.request_count;
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllRequests() {
        try {
            this.requests_mon.enter();
            for (int i = 0; i < this.requests.size(); ++i) {
                PeerReadRequest request2 = (PeerReadRequest)this.requests.get(i);
                if (request2.isCancelled()) continue;
                request2.cancel();
                --this.request_count;
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    public int getRequestCount() {
        return this.request_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getExpiredRequests() {
        ArrayList<PeerReadRequest> res = null;
        try {
            this.requests_mon.enter();
            for (int i = 0; i < this.requests.size(); ++i) {
                PeerReadRequest request2 = (PeerReadRequest)this.requests.get(i);
                if (!request2.isExpired()) continue;
                if (res == null) {
                    res = new ArrayList<PeerReadRequest>();
                }
                res.add(request2);
            }
        }
        finally {
            this.requests_mon.exit();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRequests() {
        ArrayList res = null;
        try {
            this.requests_mon.enter();
            res = new ArrayList(this.requests);
        }
        finally {
            this.requests_mon.exit();
        }
        return res;
    }

    protected void informComplete(PeerReadRequest request2, byte[] buffer) {
        PooledByteBuffer pool_buffer = this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(buffer);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestComplete(request2, pool_buffer);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void informCancelled(PeerReadRequest request2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestCancelled(request2);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void informFailed(PeerReadRequest request2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestFailed(request2);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void addListener(ExternalSeedReaderListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ExternalSeedReaderListener l) {
        this.listeners.remove(l);
    }
}

