/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;

public class SeedingUnchoker
implements Unchoker {
    private ArrayList chokes = new ArrayList();
    private ArrayList unchokes = new ArrayList();

    public ArrayList getImmediateUnchokes(int max_to_unchoke, ArrayList all_peers) {
        ArrayList<PEPeerTransport> to_unchoke = new ArrayList<PEPeerTransport>();
        int num_unchoked = 0;
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)all_peers.get(i);
            if (peer.isChokedByMe()) continue;
            ++num_unchoked;
        }
        int needed = max_to_unchoke - num_unchoked;
        if (needed > 0) {
            PEPeerTransport peer;
            for (int i = 0; i < needed && (peer = UnchokerUtil.getNextOptimisticPeer(all_peers, false, false)) != null; ++i) {
                to_unchoke.add(peer);
                peer.setOptimisticUnchoke(true);
            }
        }
        return to_unchoke;
    }

    public void calculateUnchokes(int max_to_unchoke, ArrayList all_peers, boolean force_refresh) {
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)all_peers.get(i);
            if (peer.isChokedByMe()) continue;
            if (UnchokerUtil.isUnchokable(peer, false)) {
                this.unchokes.add(peer);
                continue;
            }
            this.chokes.add(peer);
        }
        while (this.unchokes.size() > max_to_unchoke) {
            this.chokes.add(this.unchokes.remove(this.unchokes.size() - 1));
        }
        if (force_refresh) {
            int max_optimistic = (max_to_unchoke - 1) / 5 + 1;
            ArrayList peers_ordered_by_rate = new ArrayList();
            ArrayList peers_ordered_by_uploaded = new ArrayList();
            long[] rates = new long[this.unchokes.size()];
            long[] uploaded = new long[rates.length];
            for (int i = 0; i < this.unchokes.size(); ++i) {
                PEPeerTransport peer = (PEPeerTransport)this.unchokes.get(i);
                long rate = peer.getStats().getDataSendRate();
                if (rate <= 256L) continue;
                UnchokerUtil.updateLargestValueFirstSort(rate, rates, peer, peers_ordered_by_rate, 0);
                UnchokerUtil.updateLargestValueFirstSort(peer.getStats().getTotalDataBytesSent(), uploaded, peer, peers_ordered_by_uploaded, 0);
            }
            Collections.reverse(peers_ordered_by_rate);
            ArrayList peers_ordered_by_rank = new ArrayList();
            long[] ranks = new long[peers_ordered_by_rate.size()];
            Arrays.fill(ranks, Long.MIN_VALUE);
            for (int i = 0; i < this.unchokes.size(); ++i) {
                PEPeerTransport peer = (PEPeerTransport)this.unchokes.get(i);
                long rate_factor = peers_ordered_by_rate.indexOf(peer);
                long uploaded_factor = peers_ordered_by_uploaded.indexOf(peer);
                if (rate_factor == -1L) continue;
                long rank_factor = rate_factor + uploaded_factor;
                UnchokerUtil.updateLargestValueFirstSort(rank_factor, ranks, peer, peers_ordered_by_rank, 0);
            }
            while (peers_ordered_by_rank.size() > max_to_unchoke - max_optimistic) {
                peers_ordered_by_rank.remove(peers_ordered_by_rank.size() - 1);
            }
            ArrayList<PEPeerTransport> to_unchoke = new ArrayList<PEPeerTransport>();
            Iterator it = this.unchokes.iterator();
            while (it.hasNext()) {
                PEPeerTransport optimistic_peer;
                PEPeerTransport peer = (PEPeerTransport)it.next();
                peer.setOptimisticUnchoke(false);
                if (peers_ordered_by_rank.contains(peer) || (optimistic_peer = UnchokerUtil.getNextOptimisticPeer(all_peers, false, false)) == null) continue;
                this.chokes.add(peer);
                it.remove();
                to_unchoke.add(optimistic_peer);
                optimistic_peer.setOptimisticUnchoke(true);
            }
            for (int i = 0; i < to_unchoke.size(); ++i) {
                this.unchokes.add(to_unchoke.get(i));
            }
        }
    }

    public ArrayList getChokes() {
        ArrayList to_choke = this.chokes;
        this.chokes = new ArrayList();
        return to_choke;
    }

    public ArrayList getUnchokes() {
        ArrayList to_unchoke = this.unchokes;
        this.unchokes = new ArrayList();
        return to_unchoke;
    }
}

