/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus.session;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZSessionBitfield
implements AZMessage {
    private final DirectByteBuffer bitfield;
    private final int session_id;

    public AZSessionBitfield(int session_id, DirectByteBuffer bitfield) {
        this.session_id = session_id;
        this.bitfield = bitfield;
    }

    public int getSessionID() {
        return this.session_id;
    }

    public DirectByteBuffer getBitfield() {
        return this.bitfield;
    }

    public String getID() {
        return "AZ_SESSION_BITFIELD";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_SESSION_BITFIELD_BYTES;
    }

    public String getFeatureID() {
        throw new RuntimeException("not implemented");
    }

    public int getFeatureSubID() {
        throw new RuntimeException("not implemented");
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.getID() + " session #" + this.session_id;
    }

    public DirectByteBuffer[] getData() {
        DirectByteBuffer sess = DirectByteBufferPool.getBuffer((byte)12, 4);
        sess.putInt((byte)11, this.session_id);
        sess.flip((byte)11);
        return new DirectByteBuffer[]{sess, this.bitfield};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) < 4) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] < 4");
        }
        int id = data.getInt((byte)11);
        return new AZSessionBitfield(id, data);
    }

    public void destroy() {
        if (this.bitfield != null) {
            this.bitfield.returnToPool();
        }
    }
}

