/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.SelectorGuard;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class VirtualChannelSelectorImpl {
    protected Selector selector;
    private final SelectorGuard selector_guard;
    private final LinkedList register_cancel_list = new LinkedList();
    private final AEMonitor register_cancel_list_mon = new AEMonitor("VirtualChannelSelector:RCL");
    private final HashMap paused_states = new HashMap();
    private final int INTEREST_OP;
    private final boolean pause_after_select;
    protected final VirtualChannelSelector parent;
    private volatile boolean destroyed;

    public VirtualChannelSelectorImpl(VirtualChannelSelector _parent, int _interest_op, boolean _pause_after_select) {
        String type;
        this.parent = _parent;
        this.INTEREST_OP = _interest_op;
        this.pause_after_select = _pause_after_select;
        switch (this.INTEREST_OP) {
            case 8: {
                type = "OP_CONNECT";
                break;
            }
            case 1: {
                type = "OP_READ";
                break;
            }
            default: {
                type = "OP_WRITE";
            }
        }
        this.selector_guard = new SelectorGuard(type, new SelectorGuard.GuardListener(){

            public boolean safeModeSelectEnabled() {
                return VirtualChannelSelectorImpl.this.parent.isSafeSelectionModeEnabled();
            }

            public void spinDetected() {
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.parent.enableSafeSelectionMode();
            }

            public void failureDetected() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.selector = VirtualChannelSelectorImpl.this.openNewSelector();
            }
        });
        this.selector = this.openNewSelector();
    }

    protected Selector openNewSelector() {
        Selector sel = null;
        try {
            sel = Selector.open();
        }
        catch (Throwable t) {
            Debug.out("ERROR: caught exception on Selector.open()", t);
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            int fail_count = 1;
            while (fail_count < 10) {
                try {
                    sel = Selector.open();
                    break;
                }
                catch (Throwable f) {
                    Debug.out(f);
                    ++fail_count;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                }
            }
            if (fail_count < 10) {
                Debug.out("NOTICE: socket Selector successfully opened after " + fail_count + " failures.");
            }
            Logger.log(new LogAlert(true, 3, "ERROR: socket Selector.open() failed 10 times in a row, aborting.\nAzureus / Java is likely being firewalled!"));
        }
        return sel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelects(AbstractSelectableChannel channel) {
        if (channel == null) {
            return;
        }
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null && key.isValid()) {
            key.interestOps(key.interestOps() & ~this.INTEREST_OP);
        } else if (channel.isOpen()) {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.put(channel, new Boolean(true));
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelects(AbstractSelectableChannel channel) {
        if (channel == null) {
            Debug.printStackTrace(new Exception("resumeSelects():: channel == null"));
            return;
        }
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null && key.isValid()) {
            key.interestOps(key.interestOps() | this.INTEREST_OP);
        } else {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.remove(channel);
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AbstractSelectableChannel channel) {
        if (this.destroyed) {
            // empty if block
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator it = this.register_cancel_list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (channel != obj && (!(obj instanceof RegistrationData) || ((RegistrationData)obj).channel != channel)) continue;
                it.remove();
                break;
            }
            this.pauseSelects(channel);
            this.register_cancel_list.add(channel);
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractSelectableChannel channel, VirtualChannelSelector.VirtualAbstractSelectorListener listener, Object attachment) {
        if (this.destroyed) {
            Debug.out("register called after selector destroyed");
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator it = this.register_cancel_list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (channel != obj && (!(obj instanceof RegistrationData) || ((RegistrationData)obj).channel != channel)) continue;
                it.remove();
                break;
            }
            this.paused_states.remove(channel);
            this.register_cancel_list.add(new RegistrationData(channel, listener, attachment));
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long timeout) {
        long time_diff;
        long select_start_time = SystemTime.getCurrentTime();
        if (this.selector == null) {
            Debug.out("VirtualChannelSelector.select() op called with null selector");
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            return 0;
        }
        if (!this.selector.isOpen()) {
            Debug.out("VirtualChannelSelector.select() op called with closed selector");
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            return 0;
        }
        RegistrationData select_fail_data = null;
        Throwable select_fail_excep = null;
        try {
            this.register_cancel_list_mon.enter();
            while (this.register_cancel_list.size() > 0) {
                SelectionKey key;
                Object obj = this.register_cancel_list.remove(0);
                if (obj instanceof AbstractSelectableChannel) {
                    AbstractSelectableChannel canceled_channel = (AbstractSelectableChannel)obj;
                    try {
                        key = canceled_channel.keyFor(this.selector);
                        if (key == null) continue;
                        key.cancel();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                RegistrationData data = (RegistrationData)obj;
                if (data == null) {
                    Debug.out("data == null");
                }
                if (data.channel == null) {
                    Debug.out("data.channel == null");
                }
                try {
                    if (data.channel.isOpen()) {
                        Object paused;
                        key = data.channel.keyFor(this.selector);
                        if (key != null && key.isValid()) {
                            key.attach(data);
                            key.interestOps(key.interestOps() | this.INTEREST_OP);
                        } else {
                            data.channel.register(this.selector, this.INTEREST_OP, data);
                        }
                        if ((paused = this.paused_states.get(data.channel)) == null) continue;
                        this.pauseSelects(data.channel);
                        continue;
                    }
                    select_fail_data = data;
                    select_fail_excep = new Throwable("select registration: channel is closed");
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                    select_fail_data = data;
                    select_fail_excep = t;
                }
            }
            this.paused_states.clear();
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
        if (select_fail_data != null) {
            try {
                this.parent.selectFailure(select_fail_data.listener, select_fail_data.channel, select_fail_data.attachment, select_fail_excep);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int count = 0;
        this.selector_guard.markPreSelectTime();
        try {
            count = this.selector.select(timeout);
        }
        catch (Throwable t) {
            Debug.out("Caught exception on selector.select() op: " + t.getMessage(), t);
            try {
                Thread.sleep(timeout);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.destroyed) {
            this.closeExistingSelector();
            return 0;
        }
        this.selector_guard.verifySelectorIntegrity(count, 12L);
        if (!this.selector.isOpen()) {
            return count;
        }
        int progress_made_key_count = 0;
        int total_key_count = 0;
        Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
        while (i.hasNext()) {
            ++total_key_count;
            SelectionKey key = i.next();
            i.remove();
            RegistrationData data = (RegistrationData)key.attachment();
            if (key.isValid()) {
                boolean progress_indicator;
                if ((key.interestOps() & this.INTEREST_OP) == 0) continue;
                if (this.pause_after_select) {
                    key.interestOps(key.interestOps() & ~this.INTEREST_OP);
                }
                if (progress_indicator = this.parent.selectSuccess(data.listener, data.channel, data.attachment)) {
                    ++progress_made_key_count;
                    data.non_progress_count = 0;
                    continue;
                }
                ++data.non_progress_count;
                if (data.non_progress_count != 10 && (data.non_progress_count % 100 != 0 || data.non_progress_count <= 0)) continue;
                Debug.out("VirtualChannelSelector: No progress for op " + this.INTEREST_OP + ": listener = " + data.listener.getClass() + ", count = " + data.non_progress_count + ", socket: open = " + data.channel.isOpen() + (this.INTEREST_OP == 16 ? "" : ", connected = " + ((SocketChannel)data.channel).isConnected()));
                if (data.non_progress_count != 1000) continue;
                Debug.out("No progress for " + data.non_progress_count + ", closing connection");
                try {
                    data.channel.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                continue;
            }
            key.cancel();
            this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("key is invalid"));
        }
        if ((total_key_count == 0 || progress_made_key_count != total_key_count) && (time_diff = SystemTime.getCurrentTime() - select_start_time) < timeout && time_diff >= 0L) {
            try {
                Thread.sleep(timeout - time_diff);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public void destroy() {
        this.destroyed = true;
    }

    protected void closeExistingSelector() {
        Iterator<SelectionKey> i = this.selector.keys().iterator();
        while (i.hasNext()) {
            SelectionKey key = i.next();
            RegistrationData data = (RegistrationData)key.attachment();
            this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("selector destroyed"));
        }
        try {
            this.selector.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static class RegistrationData {
        protected final AbstractSelectableChannel channel;
        protected final VirtualChannelSelector.VirtualAbstractSelectorListener listener;
        protected final Object attachment;
        protected int non_progress_count;

        private RegistrationData(AbstractSelectableChannel _channel, VirtualChannelSelector.VirtualAbstractSelectorListener _listener, Object _attachment) {
            this.channel = _channel;
            this.listener = _listener;
            this.attachment = _attachment;
        }
    }
}

