/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ConnectDisconnectManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportImpl
extends TransportImpl
implements Transport {
    private static final LogIDs LOGID = LogIDs.NET;
    protected ProtocolEndpointTCP protocol_endpoint;
    private ConnectDisconnectManager.ConnectListener connect_request_key = null;
    private String description = "<disconnected>";
    private final boolean is_inbound_connection;
    private int transport_mode = 0;
    public volatile boolean has_been_closed = false;
    private boolean connect_with_crypto;
    private byte[] shared_secret;
    private int fallback_count;
    private final boolean fallback_allowed;

    public TCPTransportImpl(ProtocolEndpointTCP endpoint, boolean use_crypto, boolean allow_fallback, byte[] _shared_secret) {
        this.protocol_endpoint = endpoint;
        this.is_inbound_connection = false;
        this.connect_with_crypto = use_crypto;
        this.shared_secret = _shared_secret;
        this.fallback_allowed = allow_fallback;
    }

    public TCPTransportImpl(ProtocolEndpointTCP endpoint, TransportHelperFilter filter) {
        this.protocol_endpoint = endpoint;
        this.setFilter(filter);
        this.is_inbound_connection = true;
        this.connect_with_crypto = false;
        this.fallback_allowed = false;
        this.description = (this.is_inbound_connection ? "R" : "L") + ": " + this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    public SocketChannel getSocketChannel() {
        return ((TCPTransportHelper)this.getFilter().getHelper()).getSocketChannel();
    }

    public TransportEndpoint getTransportEndpoint() {
        return new TransportEndpointTCP(this.protocol_endpoint, this.getSocketChannel());
    }

    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    public String getDescription() {
        return this.description;
    }

    public void connectOutbound(final ByteBuffer initial_data, final Transport.ConnectListener listener) {
        ConnectDisconnectManager.ConnectListener connect_listener;
        if (!TCPNetworkManager.TCP_OUTGOING_ENABLED) {
            listener.connectFailure(new Throwable("Outbound TCP connections disabled"));
            return;
        }
        if (this.has_been_closed) {
            return;
        }
        if (this.getFilter() != null) {
            Debug.out("socket_channel != null");
            listener.connectSuccess(this, initial_data);
            return;
        }
        final boolean use_proxy = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable");
        final TCPTransportImpl transport_instance = this;
        final InetSocketAddress address = this.protocol_endpoint.getAddress();
        this.connect_request_key = connect_listener = new ConnectDisconnectManager.ConnectListener(){

            public void connectAttemptStarted() {
                listener.connectAttemptStarted();
            }

            public void connectSuccess(SocketChannel channel) {
                if (channel == null) {
                    String msg = "connectSuccess:: given channel == null";
                    Debug.out(msg);
                    listener.connectFailure(new Exception(msg));
                    return;
                }
                if (TCPTransportImpl.this.has_been_closed) {
                    TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel);
                    return;
                }
                TCPTransportImpl.this.connect_request_key = null;
                TCPTransportImpl.this.description = (TCPTransportImpl.this.is_inbound_connection ? "R" : "L") + ": " + channel.socket().getInetAddress().getHostAddress() + ": " + channel.socket().getPort();
                if (use_proxy) {
                    Logger.log(new LogEvent(LOGID, "Socket connection established to proxy server [" + TCPTransportImpl.this.description + "], login initiated..."));
                    TCPTransportImpl.this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel));
                    new ProxyLoginHandler(transport_instance, address, new ProxyLoginHandler.ProxyListener(this, channel){
                        private final /* synthetic */ SocketChannel val$channel;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$channel = val$channel;
                        }

                        public void connectSuccess() {
                            Logger.log(new LogEvent(TCPTransportImpl.access$300(), "Proxy [" + TCPTransportImpl.access$100(1.access$500(this.this$1)) + "] login successful."));
                            1.access$500(this.this$1).handleCrypto(1.access$600(this.this$1), this.val$channel, 1.access$700(this.this$1), 1.access$800(this.this$1));
                        }

                        public void connectFailure(Throwable failure_msg) {
                            TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(this.val$channel);
                            1.access$800(this.this$1).connectFailure(failure_msg);
                        }
                    });
                } else {
                    TCPTransportImpl.this.handleCrypto(address, channel, initial_data, listener);
                }
            }

            public void connectFailure(Throwable failure_msg) {
                TCPTransportImpl.this.connect_request_key = null;
                listener.connectFailure(failure_msg);
            }

            static /* synthetic */ TCPTransportImpl access$500(1 x0) {
                return x0.TCPTransportImpl.this;
            }

            static /* synthetic */ InetSocketAddress access$600(1 x0) {
                return x0.address;
            }

            static /* synthetic */ ByteBuffer access$700(1 x0) {
                return x0.initial_data;
            }

            static /* synthetic */ Transport.ConnectListener access$800(1 x0) {
                return x0.listener;
            }
        };
        InetSocketAddress to_connect = use_proxy ? ProxyLoginHandler.SOCKS_SERVER_ADDRESS : address;
        TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(to_connect, connect_listener);
    }

    protected void handleCrypto(InetSocketAddress address, final SocketChannel channel, final ByteBuffer initial_data, final Transport.ConnectListener listener) {
        if (this.connect_with_crypto) {
            TCPTransportHelper helper = new TCPTransportHelper(channel);
            TransportCryptoManager.getSingleton().manageCrypto(helper, this.shared_secret, false, initial_data, new TransportCryptoManager.HandshakeListener(){

                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    TransportHelperFilter filter = decoder.getFilter();
                    TCPTransportImpl.this.setFilter(filter);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel.socket().getRemoteSocketAddress() + " established, type = " + filter.getName()));
                    }
                    TCPTransportImpl.this.connectedOutbound();
                    listener.connectSuccess(TCPTransportImpl.this, remaining_initial_data);
                }

                public void handshakeFailure(Throwable failure_msg) {
                    if (TCPTransportImpl.this.fallback_allowed && NetworkManager.OUTGOING_HANDSHAKE_FALLBACK_ALLOWED) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, TCPTransportImpl.this.description + " | crypto handshake failure [" + failure_msg.getMessage() + "], attempting non-crypto fallback."));
                        }
                        TCPTransportImpl.this.connect_with_crypto = false;
                        TCPTransportImpl.this.fallback_count++;
                        TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel);
                        TCPTransportImpl.this.close("Handshake failure and retry");
                        TCPTransportImpl.this.has_been_closed = false;
                        TCPTransportImpl.this.connectOutbound(initial_data, listener);
                    } else {
                        TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(channel);
                        listener.connectFailure(failure_msg);
                    }
                }

                public void gotSecret(byte[] session_secret) {
                }

                public int getMaximumPlainHeaderLength() {
                    throw new RuntimeException();
                }

                public int matchPlainHeader(ByteBuffer buffer) {
                    throw new RuntimeException();
                }
            });
        } else {
            this.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Outgoing TCP stream to " + channel.socket().getRemoteSocketAddress() + " established, type = " + this.getFilter().getName() + ", fallback = " + (this.fallback_count == 0 ? "no" : "yes")));
            }
            this.connectedOutbound();
            listener.connectSuccess(this, initial_data);
        }
    }

    private void setTransportBuffersSize(int size_in_bytes) {
        if (this.getFilter() == null) {
            Debug.out("socket_channel == null");
            return;
        }
        try {
            SocketChannel channel = this.getSocketChannel();
            channel.socket().setSendBufferSize(size_in_bytes);
            channel.socket().setReceiveBufferSize(size_in_bytes);
            int snd_real = channel.socket().getSendBufferSize();
            int rcv_real = channel.socket().getReceiveBufferSize();
            Logger.log(new LogEvent(LOGID, "Setting new transport [" + this.description + "] buffer sizes: SND=" + size_in_bytes + " [" + snd_real + "] , RCV=" + size_in_bytes + " [" + rcv_real + "]"));
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    public void setTransportMode(int mode) {
        if (mode == this.transport_mode) {
            return;
        }
        switch (mode) {
            case 0: {
                this.setTransportBuffersSize(8192);
                break;
            }
            case 1: {
                this.setTransportBuffersSize(65536);
                break;
            }
            case 2: {
                this.setTransportBuffersSize(524288);
                break;
            }
            default: {
                Debug.out("invalid transport mode given: " + mode);
            }
        }
        this.transport_mode = mode;
    }

    public int getTransportMode() {
        return this.transport_mode;
    }

    public void close(String reason) {
        this.has_been_closed = true;
        if (this.connect_request_key != null) {
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().cancelRequest(this.connect_request_key);
        }
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter filter = this.getFilter();
        if (filter != null) {
            filter.getHelper().close(reason);
            this.setFilter(null);
        }
    }
}

