/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ConnectDisconnectManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class TCPNetworkManager {
    private static final int SELECT_LOOP_TIME = 25;
    protected static int tcp_mss_size;
    private static final TCPNetworkManager instance;
    public static boolean TCP_INCOMING_ENABLED;
    public static boolean TCP_OUTGOING_ENABLED;
    private final VirtualChannelSelector read_selector = new VirtualChannelSelector(1, true);
    private final VirtualChannelSelector write_selector = new VirtualChannelSelector(4, true);
    private final ConnectDisconnectManager connect_disconnect_manager = new ConnectDisconnectManager();
    private final IncomingSocketChannelManager incoming_socketchannel_manager = new IncomingSocketChannelManager();

    public static TCPNetworkManager getSingleton() {
        return instance;
    }

    public static int getTcpMssSize() {
        return tcp_mss_size;
    }

    public static void refreshRates(int min_rate) {
        tcp_mss_size = COConfigurationManager.getIntParameter("network.tcp.mtu.size") - 40;
        if (tcp_mss_size > min_rate) {
            tcp_mss_size = min_rate - 1;
        }
        if (tcp_mss_size < 512) {
            tcp_mss_size = 512;
        }
    }

    protected TCPNetworkManager() {
        AEThread read_selector_thread = new AEThread("ReadController:ReadSelector"){

            public void runSupport() {
                TCPNetworkManager.this.readSelectorLoop();
            }
        };
        read_selector_thread.setDaemon(true);
        read_selector_thread.setPriority(8);
        read_selector_thread.start();
        AEThread write_selector_thread = new AEThread("WriteController:WriteSelector"){

            public void runSupport() {
                TCPNetworkManager.this.writeSelectorLoop();
            }
        };
        write_selector_thread.setDaemon(true);
        write_selector_thread.setPriority(8);
        write_selector_thread.start();
    }

    public IncomingSocketChannelManager getIncomingSocketChannelManager() {
        return this.incoming_socketchannel_manager;
    }

    public ConnectDisconnectManager getConnectDisconnectManager() {
        return this.connect_disconnect_manager;
    }

    public VirtualChannelSelector getReadSelector() {
        return this.read_selector;
    }

    public VirtualChannelSelector getWriteSelector() {
        return this.write_selector;
    }

    public void closeSocketChannel(SocketChannel channel) {
        this.connect_disconnect_manager.closeConnection(channel);
    }

    public int getTCPListeningPortNumber() {
        return this.incoming_socketchannel_manager.getTCPListeningPortNumber();
    }

    private void readSelectorLoop() {
        while (true) {
            try {
                while (true) {
                    this.read_selector.select(25L);
                }
            }
            catch (Throwable t) {
                Debug.out("readSelectorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private void writeSelectorLoop() {
        while (true) {
            try {
                while (true) {
                    this.write_selector.select(25L);
                }
            }
            catch (Throwable t) {
                Debug.out("writeSelectorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    static {
        instance = new TCPNetworkManager();
        COConfigurationManager.addAndFireParameterListener("TCP.Listen.Port.Enable", new ParameterListener(){

            public void parameterChanged(String name) {
                TCP_INCOMING_ENABLED = TCP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter(name);
            }
        });
    }
}

