/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class ProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int TIMEOUT_CHECK = 5000;
    private static final int LOG_TICKS = 12;
    private static List decoders = new ArrayList();
    private static AEMonitor class_mon = new AEMonitor("TCPProtocolDecoder:class");
    private static int loop = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtocolDecoder(boolean run_timer) {
        if (run_timer) {
            try {
                class_mon.enter();
                decoders.add(this);
            }
            finally {
                class_mon.exit();
            }
        }
    }

    public abstract boolean isComplete(long var1);

    public abstract TransportHelperFilter getFilter();

    public static void addSecret(byte[] secret) {
        ProtocolDecoderPHE.addSecretSupport(secret);
    }

    public static void removeSecret(byte[] secret) {
        ProtocolDecoderPHE.removeSecretSupport(secret);
    }

    static {
        SimpleTimer.addPeriodicEvent("ProtocolDecoder:timeouts", 5000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent ev) {
                loop++;
                long now = SystemTime.getCurrentTime();
                try {
                    class_mon.enter();
                    if (loop % 12 == 0 && Logger.isEnabled() && decoders.size() > 0) {
                        Logger.log(new LogEvent(LOGID, "Active protocol decoders = " + decoders.size()));
                    }
                    Iterator it = decoders.iterator();
                    while (it.hasNext()) {
                        ProtocolDecoder decoder = (ProtocolDecoder)it.next();
                        if (!decoder.isComplete(now)) continue;
                        it.remove();
                    }
                }
                finally {
                    class_mon.exit();
                }
            }
        });
    }
}

