/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class MemoryMappedFile {
    public static final int MODE_READ_ONLY = 0;
    public static final int MODE_READ_WRITE = 1;
    public static long cache_hits = 0L;
    public static long cache_misses = 0L;
    private static final int BLOCK_SIZE = 0xA00000;
    private final File file;
    private int access_mode = 0;
    private FileChannel channel;
    private Object[] mapKeys;
    private int[] counts = new int[10000];

    public MemoryMappedFile(File file) {
        this.file = file;
        this.mapKeys = new Object[new Long(file.length() / 0xA00000L).intValue() + 1];
        Arrays.fill(this.counts, 0);
    }

    public int getAccessMode() {
        return this.access_mode;
    }

    public void setAccessMode(int mode) {
        if (mode == 0 && this.access_mode == 1 && this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            this.channel = null;
        }
        this.access_mode = mode;
    }

    public void write(DirectByteBuffer buffer, int buffer_offset, long file_offset, int length) throws IOException {
        if (this.access_mode == 0) {
            throw new IOException("cannot write to a read-only file");
        }
        if (buffer.limit((byte)2) - buffer_offset < length) {
            throw new IOException("not enough buffer remaining to write given length");
        }
        this.file.createNewFile();
        int key_pos = new Long(file_offset / 0xA00000L).intValue();
        int map_offset = new Long(file_offset % 0xA00000L).intValue();
        int written = 0;
        while (written < length) {
            MappedByteBuffer mbb = null;
            long f_offset = file_offset + (long)written;
            int length_to_write = 0xA00000 - map_offset;
            if (length - written < length_to_write) {
                length_to_write = length - written;
            }
            if (this.mapKeys.length > key_pos) {
                Object key = this.mapKeys[key_pos];
                if (key != null && (mbb = MemoryMapPool.getBuffer(key)) != null && mbb.capacity() < map_offset + length_to_write) {
                    MemoryMapPool.clean(mbb);
                    mbb = null;
                }
            } else {
                this.mapKeys = new Object[key_pos * 2];
            }
            if (mbb == null) {
                int size = 0xA00000;
                if (f_offset + (long)length_to_write > this.file.length()) {
                    size = map_offset + length_to_write;
                }
                mbb = this.createMappedBuffer(f_offset - (long)map_offset, size);
                ++cache_misses;
            } else {
                ++cache_hits;
            }
            buffer.position((byte)2, buffer_offset + written);
            buffer.limit((byte)2, buffer.position((byte)2) + length_to_write);
            mbb.position(map_offset);
            mbb.put(buffer.getBuffer((byte)2));
            written += length_to_write;
            this.mapKeys[key_pos] = MemoryMapPool.addBuffer(mbb);
            ++key_pos;
            map_offset = 0;
        }
    }

    private MappedByteBuffer createMappedBuffer(long file_offset, int length) throws IOException {
        if (this.channel == null) {
            FileChannel fc = new RandomAccessFile(this.file, "rw").getChannel();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, file_offset, length);
            if (this.access_mode == 0) {
                fc.close();
            } else {
                this.channel = fc;
            }
            return mbb;
        }
        return this.channel.map(FileChannel.MapMode.READ_WRITE, file_offset, length);
    }

    private static class MemoryMapPool {
        private static long MAX_SIZE = 0x6400000L;
        private static final MemoryMapPool instance = new MemoryMapPool();
        private long total_size = 0L;
        private final AEMonitor buffers_mon = new AEMonitor("MemoryMappedFile:buffers");
        private final Map buffers = new LinkedHashMap(this, (int)(MAX_SIZE / 0xA00000L), 0.75f, true){
            private final /* synthetic */ MemoryMapPool this$0;
            {
                this.this$0 = this$0;
                super(x0, x1, x2);
            }

            public boolean removeEldestEntry(Map.Entry eldest) {
                boolean remove;
                boolean bl = remove = MemoryMapPool.access$300(this.this$0) > MemoryMapPool.access$400();
                if (remove) {
                    MappedByteBuffer mbb = (MappedByteBuffer)eldest.getValue();
                    MemoryMapPool.access$322(this.this$0, mbb.capacity());
                    MemoryMapPool.access$100(mbb);
                }
                return remove;
            }
        };

        private MemoryMapPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MappedByteBuffer getBuffer(Object key) {
            try {
                MemoryMapPool.instance.buffers_mon.enter();
                MappedByteBuffer mbb = (MappedByteBuffer)MemoryMapPool.instance.buffers.remove(key);
                if (mbb != null) {
                    MemoryMapPool.instance.total_size -= (long)mbb.capacity();
                }
                MappedByteBuffer mappedByteBuffer = mbb;
                return mappedByteBuffer;
            }
            finally {
                MemoryMapPool.instance.buffers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object addBuffer(MappedByteBuffer buffer) {
            Object key = new Object();
            try {
                MemoryMapPool.instance.buffers_mon.enter();
                MemoryMapPool.instance.total_size += (long)buffer.capacity();
                MemoryMapPool.instance.buffers.put(key, buffer);
            }
            finally {
                MemoryMapPool.instance.buffers_mon.exit();
            }
            return key;
        }

        private static void clean(MappedByteBuffer buffer) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return null;
                }
            });
        }

        static /* synthetic */ long access$300(MemoryMapPool x0) {
            return x0.total_size;
        }

        static /* synthetic */ long access$400() {
            return MAX_SIZE;
        }

        static /* synthetic */ long access$322(MemoryMapPool x0, long x1) {
            return x0.total_size -= x1;
        }
    }
}

