/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.updater;

import com.aelitis.azureus.plugins.rating.RatingPlugin;
import com.aelitis.azureus.plugins.rating.updater.CompletionAdapter;
import com.aelitis.azureus.plugins.rating.updater.CompletionListener;
import com.aelitis.azureus.plugins.rating.updater.KeyGenUtils;
import com.aelitis.azureus.plugins.rating.updater.RatingData;
import com.aelitis.azureus.plugins.rating.updater.RatingResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.utils.AggregatedList;
import org.gudy.azureus2.plugins.utils.AggregatedListAcceptor;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class RatingsUpdater
implements DownloadManagerListener,
AggregatedListAcceptor {
    private static final int READ_TIMEOUT = 60000;
    private static final int UPDATE_TIME = 3600000;
    UTTimer timer;
    List downloads;
    Map torrentRatings;
    RatingPlugin plugin;
    DistributedDatabase database;
    TorrentAttribute attributeRating;
    TorrentAttribute attributeComment;
    TorrentAttribute attributeGlobalRating;
    private AggregatedList listToHandle;
    static /* synthetic */ Class array$B;

    public RatingsUpdater(RatingPlugin plugin) {
        this.plugin = plugin;
        this.downloads = new ArrayList();
        this.torrentRatings = new HashMap();
        this.listToHandle = plugin.getPluginInterface().getUtilities().createAggregatedList((AggregatedListAcceptor)this, 20000L, 100L);
        this.attributeRating = this.plugin.getPluginInterface().getTorrentManager().getPluginAttribute("rating");
        this.attributeComment = this.plugin.getPluginInterface().getTorrentManager().getPluginAttribute("comment");
        this.attributeGlobalRating = this.plugin.getPluginInterface().getTorrentManager().getPluginAttribute("globalRating");
    }

    public void initialize() {
        this.plugin.getPluginInterface().getUtilities().createThread("Initializer", new Runnable(){

            public void run() {
                RatingsUpdater.this.pInitialize();
            }
        });
    }

    private void pInitialize() {
        PluginInterface pluginInterface = this.plugin.getPluginInterface();
        this.database = pluginInterface.getDistributedDatabase();
        if (this.database.isAvailable()) {
            pluginInterface.getDownloadManager().addListener((DownloadManagerListener)this);
            this.timer = pluginInterface.getUtilities().createTimer("Ratings Update");
            this.timer.addPeriodicEvent(3600000L, new UTTimerEventPerformer(){

                public void perform(UTTimerEvent event) {
                    RatingsUpdater.this.updateRatings();
                }
            });
        }
    }

    public void downloadAdded(Download download) {
        if (download.getTorrent() != null) {
            String torrentName = download.getTorrent().getName();
            this.plugin.logInfo(torrentName + " : downloaded added");
            this.downloads.add(download);
            this.listToHandle.add((Object)download);
        }
    }

    public void downloadRemoved(Download download) {
        String torrentName = download.getTorrent().getName();
        this.plugin.logInfo(torrentName + " : downloaded removed");
        this.downloads.remove(download);
        this.torrentRatings.remove(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatingResults getRatingsForDownload(Download d) {
        RatingResults result = null;
        Map map = this.torrentRatings;
        synchronized (map) {
            result = (RatingResults)this.torrentRatings.get(d);
        }
        if (result != null) {
            return result;
        }
        result = new RatingResults();
        try {
            String str = d.getAttribute(this.attributeGlobalRating);
            if (str != null) {
                float f = Float.parseFloat(str);
                result.setAverage(f);
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new RatingResults();
    }

    public void accept(final List l) {
        this.plugin.getPluginInterface().getUtilities().createThread("Ratings Updater", new Runnable(){

            public void run() {
                LinkedList downloads = new LinkedList(l);
                RatingsUpdater.this.updateRatings(downloads);
                downloads = new LinkedList(l);
                RatingsUpdater.this.publishAllRatings(downloads);
            }
        });
    }

    public void updateRatings() {
        this.plugin.getPluginInterface().getUtilities().createThread("Ratings Updater", new Runnable(){

            public void run() {
                LinkedList downloads = new LinkedList(RatingsUpdater.this.downloads);
                RatingsUpdater.this.updateRatings(downloads);
            }
        });
    }

    private void updateRatings(final List downloads) {
        if (downloads.size() == 0) {
            return;
        }
        final Download download = (Download)downloads.remove(0);
        final String torrentName = download.getTorrent().getName();
        try {
            this.plugin.logInfo(torrentName + " : getting rating");
            DistributedDatabaseKey ddKey = this.database.createKey((Object)KeyGenUtils.buildRatingKey(download), "Looking-up ratings for " + torrentName);
            this.database.read(new DistributedDatabaseListener(){
                List results = new ArrayList();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void event(DistributedDatabaseEvent event) {
                    if (event.getType() == 2) {
                        this.results.add(event.getValue());
                    }
                    if (event.getType() == 4 || event.getType() == 5) {
                        RatingsUpdater.this.plugin.logInfo(torrentName + " : Rating received");
                        RatingResults ratings = new RatingResults();
                        for (int i = 0; i < this.results.size(); ++i) {
                            DistributedDatabaseValue value = (DistributedDatabaseValue)this.results.get(i);
                            try {
                                byte[] bValue = (byte[])value.getValue(array$B == null ? RatingsUpdater.class$("[B") : array$B);
                                RatingData data = new RatingData(bValue);
                                RatingsUpdater.this.plugin.logInfo("        " + data.getScore() + ", " + value.getContact().getName() + ", " + data.getNick() + " : " + data.getComment());
                                ratings.addRating(data);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Map map = RatingsUpdater.this.torrentRatings;
                        synchronized (map) {
                            RatingsUpdater.this.torrentRatings.put(download, ratings);
                            download.setAttribute(RatingsUpdater.this.attributeGlobalRating, "" + ratings.getRealAverageScore());
                        }
                        RatingsUpdater.this.updateRatings(downloads);
                    }
                }
            }, ddKey, 60000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateRatings(downloads);
        }
    }

    public RatingData loadRatingsFromDownload(Download download) {
        String strRating = download.getAttribute(this.attributeRating);
        String comment = download.getAttribute(this.attributeComment);
        int rating = 0;
        if (strRating != null) {
            try {
                rating = Integer.parseInt(strRating);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (comment == null) {
            comment = "";
        }
        String nick = this.plugin.getNick();
        return new RatingData(rating, nick, comment);
    }

    public void storeRatingsToDownload(Download download, RatingData data) {
        RatingData oldData = this.loadRatingsFromDownload(download);
        boolean updateNeeded = false;
        updateNeeded |= oldData.getScore() != data.getScore();
        if (updateNeeded |= !oldData.getComment().equals(data.getComment())) {
            download.setAttribute(this.attributeRating, "" + data.getScore());
            download.setAttribute(this.attributeComment, data.getComment());
        }
        if ((updateNeeded |= !oldData.getNick().equals(data.getNick())) && this.database != null && this.database.isAvailable()) {
            this.publishDownloadRating(download, data);
        }
    }

    private void publishDownloadRating(Download download) {
        this.publishDownloadRating(download, this.loadRatingsFromDownload(download));
    }

    private void publishDownloadRating(Download download, CompletionListener listener) {
        this.publishDownloadRating(download, this.loadRatingsFromDownload(download), listener);
    }

    private void publishDownloadRating(Download download, RatingData data) {
        this.publishDownloadRating(download, data, new CompletionAdapter());
    }

    private void publishDownloadRating(final Download download, RatingData data, final CompletionListener listener) {
        int score = data.getScore();
        if (score == 0) {
            return;
        }
        final String torrentName = download.getTorrent().getName();
        byte[] value = data.encodes();
        try {
            this.plugin.logInfo(torrentName + " : publishing rating");
            DistributedDatabaseKey ddKey = this.database.createKey((Object)KeyGenUtils.buildRatingKey(download), "Registering ratings for " + torrentName);
            DistributedDatabaseValue ddValue = this.database.createValue((Object)value);
            this.database.write(new DistributedDatabaseListener(){

                public void event(DistributedDatabaseEvent event) {
                    if (event.getType() == 4) {
                        RatingsUpdater.this.plugin.logInfo(torrentName + " : rating registeration successfull");
                        listener.operationComplete();
                        ArrayList<Download> dls = new ArrayList<Download>();
                        dls.add(download);
                        RatingsUpdater.this.updateRatings(dls);
                    }
                    if (event.getType() == 5) {
                        RatingsUpdater.this.plugin.logInfo(torrentName + " : rating registeration failed");
                        listener.operationComplete();
                    }
                }
            }, ddKey, ddValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void publishAllRatings() {
        LinkedList downloads = new LinkedList(this.downloads);
        this.publishAllRatings(downloads);
    }

    private void publishAllRatings(final List downloads) {
        if (downloads.size() == 0) {
            return;
        }
        Download download = (Download)downloads.remove(0);
        this.publishDownloadRating(download, new CompletionListener(){

            public void operationComplete() {
                RatingsUpdater.this.publishAllRatings(downloads);
            }
        });
    }
}

