/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSOldGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSPermGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSYoungGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.ParallelScavengeHeap;
import sun.jvm.hotspot.gc_implementation.shared.MutableSpace;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.ContiguousSpace;
import sun.jvm.hotspot.memory.DefNewGeneration;
import sun.jvm.hotspot.memory.EdenSpace;
import sun.jvm.hotspot.memory.GenCollectedHeap;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;

public class HeapSummary
extends Tool {
    private static String alignment = "   ";
    private static final double FACTOR = 1048576.0;

    public static void main(String[] args) {
        HeapSummary hs = new HeapSummary();
        hs.start(args);
        hs.stop();
    }

    public void run() {
        CollectedHeap heap = VM.getVM().getUniverse().heap();
        VM.Flag[] flags = VM.getVM().getCommandLineFlags();
        HashMap<String, VM.Flag> flagMap = new HashMap<String, VM.Flag>();
        if (flags == null) {
            System.out.println("WARNING: command line flags are not available");
        } else {
            for (int f = 0; f < flags.length; ++f) {
                flagMap.put(flags[f].getName(), flags[f]);
            }
        }
        System.out.println();
        this.printGCAlgorithm(flagMap);
        System.out.println();
        System.out.println("Heap Configuration:");
        this.printValue("MinHeapFreeRatio = ", this.getFlagValue("MinHeapFreeRatio", flagMap));
        this.printValue("MaxHeapFreeRatio = ", this.getFlagValue("MaxHeapFreeRatio", flagMap));
        this.printValMB("MaxHeapSize      = ", this.getFlagValue("MaxHeapSize", flagMap));
        this.printValMB("NewSize          = ", this.getFlagValue("NewSize", flagMap));
        this.printValMB("MaxNewSize       = ", this.getFlagValue("MaxNewSize", flagMap));
        this.printValMB("OldSize          = ", this.getFlagValue("OldSize", flagMap));
        this.printValue("NewRatio         = ", this.getFlagValue("NewRatio", flagMap));
        this.printValue("SurvivorRatio    = ", this.getFlagValue("SurvivorRatio", flagMap));
        this.printValMB("PermSize         = ", this.getFlagValue("PermSize", flagMap));
        this.printValMB("MaxPermSize      = ", this.getFlagValue("MaxPermSize", flagMap));
        System.out.println();
        System.out.println("Heap Usage:");
        if (heap instanceof GenCollectedHeap) {
            GenCollectedHeap genHeap = (GenCollectedHeap)heap;
            for (int n = 0; n < genHeap.nGens(); ++n) {
                Generation gen = genHeap.getGen(n);
                if (gen instanceof DefNewGeneration) {
                    System.out.println("New Generation (Eden + 1 Survivor Space):");
                    this.printGen(gen);
                    EdenSpace eden = ((DefNewGeneration)gen).eden();
                    System.out.println("Eden Space:");
                    this.printSpace(eden);
                    ContiguousSpace from = ((DefNewGeneration)gen).from();
                    System.out.println("From Space:");
                    this.printSpace(from);
                    ContiguousSpace to = ((DefNewGeneration)gen).to();
                    System.out.println("To Space:");
                    this.printSpace(to);
                    continue;
                }
                System.out.println(gen.name() + ":");
                this.printGen(gen);
            }
            Generation permGen = genHeap.permGen();
            System.out.println("Perm Generation:");
            this.printGen(permGen);
        } else if (heap instanceof ParallelScavengeHeap) {
            ParallelScavengeHeap psh = (ParallelScavengeHeap)heap;
            PSYoungGen youngGen = psh.youngGen();
            this.printPSYoungGen(youngGen);
            PSOldGen oldGen = psh.oldGen();
            long oldFree = oldGen.capacity() - oldGen.used();
            System.out.println("PS Old Generation");
            this.printValMB("capacity = ", oldGen.capacity());
            this.printValMB("used     = ", oldGen.used());
            this.printValMB("free     = ", oldFree);
            System.out.println(alignment + (double)oldGen.used() * 100.0 / (double)oldGen.capacity() + "% used");
            PSPermGen permGen = psh.permGen();
            long permFree = permGen.capacity() - permGen.used();
            System.out.println("PS Perm Generation");
            this.printValMB("capacity = ", permGen.capacity());
            this.printValMB("used     = ", permGen.used());
            this.printValMB("free     = ", permFree);
            System.out.println(alignment + (double)permGen.used() * 100.0 / (double)permGen.capacity() + "% used");
        } else {
            throw new RuntimeException("unknown heap type : " + heap.getClass());
        }
    }

    private void printGCAlgorithm(Map flagMap) {
        long l = this.getFlagValue("UseParNewGC", flagMap);
        if (l == 1L) {
            System.out.println("using parallel threads in the new generation.");
        }
        if ((l = this.getFlagValue("UseTLAB", flagMap)) == 1L) {
            System.out.println("using thread-local object allocation.");
        }
        if ((l = this.getFlagValue("UseConcMarkSweepGC", flagMap)) == 1L) {
            System.out.println("Concurrent Mark-Sweep GC");
            return;
        }
        l = this.getFlagValue("UseParallelGC", flagMap);
        if (l == 1L) {
            System.out.print("Parallel GC ");
            l = this.getFlagValue("ParallelGCThreads", flagMap);
            System.out.println("with " + l + " thread(s)");
            return;
        }
        System.out.println("Mark Sweep Compact GC");
    }

    private void printPSYoungGen(PSYoungGen youngGen) {
        System.out.println("PS Young Generation");
        MutableSpace eden = youngGen.edenSpace();
        System.out.println("Eden Space:");
        this.printMutableSpace(eden);
        MutableSpace from = youngGen.fromSpace();
        System.out.println("From Space:");
        this.printMutableSpace(from);
        MutableSpace to = youngGen.toSpace();
        System.out.println("To Space:");
        this.printMutableSpace(to);
    }

    private void printMutableSpace(MutableSpace space) {
        this.printValMB("capacity = ", space.capacity());
        this.printValMB("used     = ", space.used());
        long free = space.capacity() - space.used();
        this.printValMB("free     = ", free);
        System.out.println(alignment + (double)space.used() * 100.0 / (double)space.capacity() + "% used");
    }

    private void printGen(Generation gen) {
        this.printValMB("capacity = ", gen.capacity());
        this.printValMB("used     = ", gen.used());
        this.printValMB("free     = ", gen.free());
        System.out.println(alignment + (double)gen.used() * 100.0 / (double)gen.capacity() + "% used");
    }

    private void printSpace(ContiguousSpace space) {
        this.printValMB("capacity = ", space.capacity());
        this.printValMB("used     = ", space.used());
        this.printValMB("free     = ", space.free());
        System.out.println(alignment + (double)space.used() * 100.0 / (double)space.capacity() + "% used");
    }

    private void printValMB(String title, long value) {
        double mb = (double)value / 1048576.0;
        System.out.println(alignment + title + value + " (" + mb + "MB)");
    }

    private void printValue(String title, long value) {
        System.out.println(alignment + title + value);
    }

    private long getFlagValue(String name, Map flagMap) {
        VM.Flag f = (VM.Flag)flagMap.get(name);
        if (f != null) {
            if (f.isBool()) {
                return f.getBool() ? 1L : 0L;
            }
            return Long.parseLong(f.getValue());
        }
        return -1L;
    }
}

