#!/bin/sh
# toiriver.sh 1.0
# Copyright (C) 2005 John Eriksson
#
# Description:
# Converts a video to a nice format for the iriver U10

NAME="toiriver.sh"
VERSION="1.0"

usage() {
echo "Usage: $NAME [OPTION]..."
echo "Converts a video file to a nice format for use on"
echo "the iriver U10."
echo
echo "  -h, --help		print this help and exit"
echo "  -v, --version		output version information and exit"
echo
echo "Report bugs to <johne@rootlinux.org>."
exit 1
}

version() {
echo "$NAME $VERSION"
exit 0
}

if [ "$1" = "-v" -o "$1" = "--version" ]; then
  version
fi

if [ "$1" = "-h" -o "$1" = "--help" ]; then
  usage
fi

if [ ! -f "$1" ]; then
  echo "error: file not found."
fi

NEWFILENAME="`echo $1 | cut -f1 -d.`_iriver.avi"

mencoder -ofps 15 -ovc lavc -oac mp3lame -lameopts cbr:mode=2:br=128 \
-lavcopts vcodec=mpeg4:vhq:keyint=250:vqmin=3:vqscale=6 -af \
resample=44100 -srate 44100 -vf scale=320:240 -ffourcc XVID -o \
"$NEWFILENAME" "$1"

# EOF

