#!/bin/sh
# systest.sh 0.1
# Copyright (C) 2005 John Eriksson
#
# Description:
# A small script to check for errors (junk files etc)
# in the system. Useful before a ROOT release.

NAME="systest.sh"
VERSION="0.1"

usage() {
echo "Usage: $NAME [OPTION]..."
echo "A small script to check for errors (junk files etc)"
echo "in the system. Useful before a ROOT release."
echo
echo "  -h, --help		print this help and exit"
echo "  -v, --version		output version information and exit"
echo
echo "Report bugs to <johne@rootlinux.org>."
exit 1
}

version() {
echo "$NAME $VERSION"
exit 0
}

if [ "$1" = "-v" -o "$1" = "--version" ]; then
  version
fi

if [ "$1" = "-h" -o "$1" = "--help" ]; then
  usage
fi

echo "Starting $NAME $VERSION by Kohn."

for directory in "/usr/share/locale" "/usr/man" \
"/usr/info"; do
if [ -d "$directory" ]; then
  echo "directory $directory exists. possible junk files."
fi
done

echo "System check complete."

# EOF

