#!/bin/sh
# rmpic.sh 0.1
# Copyright (C) 2004-2005 John Eriksson
#
# Description:
# Removes a picture from the archive and all different versions of it.

if [ -z "$1" ]; then
  echo "Specify name of picture please."
  exit 1
fi

ALBUM="`basename $PWD`"

for resolution in ../../pixverket/$ALBUM/*x*; do
	if [ -d "$resolution" ]; then
		if [ -f "$resolution/$1" ]; then
			rm -f "$resolution/$1"
			echo "removed $resolution/$1"
		fi
	fi
done

rm -f "$1"

if [ -f ../../pixverket/$ALBUM/thumbs/"`echo $1 | sed s/.jpg/_thumb.jpg/`" ]; then
  rm -f ../../pixverket/$ALBUM/thumbs/"`echo $1 | sed s/.jpg/_thumb.jpg/`"
  echo "removed ../../pixverket/$ALBUM/thumbs/`echo $1 | sed s/.jpg/_thumb.jpg/`"
fi

# EOF
