#!/bin/sh
# mkthumbs.sh 0.9.3
# Copyright (C) 2005 John Eriksson
#
# Description:
# Create thumbnails of the JPEG pictures in the current
# directory, for Kohn's pix archive.

NAME="mkthumbs.sh"
VERSION="0.9.3"

usage() {
echo "Usage: $NAME [OPTION]..."
echo "Create thumbnails of the JPEG pictures in the current"
echo "directory, for Kohn's pix archive."
echo
echo "  -h, --help		print this help and exit"
echo "  -v, --version		output version information and exit"
echo
echo "Report bugs to <johne@rootlinux.org>."
exit 1
}

version() {
echo "$NAME $VERSION"
}

if [ "$1" = "-v" -o "$1" = "--version" ]; then
  version
fi

if [ "$1" = "-h" -o "$1" = "--help" ]; then
  usage
fi

echo "Starting $NAME $VERSION by Kohn."
echo

GALLERY="`basename $PWD`"

echo "Making thumbnails in $GALLERY..."

if [ ! -d ../../pixverket/$GALLERY/thumbs ]; then
  echo "Thumbnail directory not found, creating..."
  mkdir -p ../../pixverket/$GALLERY/thumbs
fi

# main loop
for image in *.jpg; do

if [ "$image" = "sample.jpg" ]; then
  continue
fi

if [ ! -f "$image" ]; then
  echo "No images in this directory, exiting..."
  exit 1
fi

echo -n "$image "

THUMB="`echo $image | cut -f1 -d.`_thumb.jpg"

if [ -f "../../pixverket/$GALLERY/thumbs/$THUMB" ]; then
  echo "already done"
  continue
fi

SIZE="`identify -format \"%wx%h\" $image`"
WIDTH="`echo $SIZE | cut -f1 -dx`"
HEIGHT="`echo $SIZE | cut -f2 -dx`"


# print info
echo -n "($SIZE): "

function make_newsize {
	if [ ! -d ../../pixverket/$GALLERY/$1 ]; then
		mkdir -p ../../pixverket/$GALLERY/$1
	fi
	if [ ! -f ../../pixverket/$GALLERY/$1/"$image" ]; then
		if [ ! $SIZE = "$1" ]; then
			convert "$image" -geometry $1 ../../pixverket/$GALLERY/$1/"$image"
			echo -n "$1 "
		else
			ln -sf ../../../albums/$GALLERY/"$image" ../../pixverket/$GALLERY/$1/"$image"
		fi
	fi
}

# make appropriate thumbs and links

if [ $HEIGHT -gt $WIDTH ]; then
	convert "$image" -rotate 90 "$image"
        TMP=$WIDTH
        WIDTH=$HEIGHT
        HEIGHT=$TMP
	SIZE="$WIDTHx$HEIGHT"
fi

# calculate aspect ratio
ASPECT=`echo "scale=0; (100*$WIDTH/$HEIGHT)" | bc -l`

# two cases right now
if [ $ASPECT -ge 130 -a $ASPECT -le 136 ]; then
  ASPECT=1.33
  SIZES="1280x960 1024x768 800x600"
elif [ $ASPECT -ge 147 -a $ASPECT -le 153 ]; then
  ASPECT=1.50
  SIZES="1280x853 1024x683 800x533"
else
  echo "unsupported aspect ratio found, please add support"
  exit 1
fi

# make all $SIZES (if smaller)
for size in $SIZES; do
   width="`echo $size | cut -f1 -dx`"
   if [ $width -lt $WIDTH ]; then
     make_newsize "$size"
   fi
done

# make link for the actual size
make_newsize "$SIZE"

echo "thumb"

if [ ! -f ../../pixverket/$GALLERY/thumbs/$THUMB ]; then
	if [ $ASPECT = 1.50 ]; then
		# cut the image to be 1.33 ratio as thumb
		convert $image -resize x150 ../../pixverket/$GALLERY/thumbs/$THUMB
		convert ../../pixverket/$GALLERY/thumbs/$THUMB -crop 200x150+12+0 ../../pixverket/$GALLERY/thumbs/$THUMB
	else
		convert $image -geometry 200x150 ../../pixverket/$GALLERY/thumbs/$THUMB
	fi
fi
done

# EOF

