/***************************************************************************
 begin                : Tue Jul 30 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFCHECKLISTOUTPUT_H
#define KMFCHECKLISTOUTPUT_H

#include <qdialog.h>
#include <qpixmap.h>
#include <kdemacros.h>
class QLabel;
class QListView;
class QListViewItem;
class QString;
class QPushButton;

/**
  *@author Christian Hubinger
  */

class KDE_EXPORT KMFCheckListOutput : public QDialog {
	Q_OBJECT
public:
	KMFCheckListOutput( QWidget *parent = 0, const char *name = 0, bool modal = FALSE, WFlags fl = 0 );
	~KMFCheckListOutput();

	/**
	Appends one line at the End Of the List
	*/
	void appendLine( const QString &txt );

	/**
	Sets the Status of the last created ListItem
	*/
	void setStatus( bool ok, const QString &err_msg );

	void clearList();

private:

	// Functions
	void loadIcons();

	// Data
	QListView *mlb_outputView;
	QPushButton *mpb_ok;
	QListViewItem *m_currItem;
	QPixmap icon_ok;
	QPixmap icon_err;
	QLabel *text;
};

#endif
