/*
    ziprommetadata.h - ZIP File support.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUZIPROMMETADATA_H
#define KAMEFUZIPROMMETADATA_H

#include <rommetadata.h>

namespace Kamefu {

/**
 * Handle ZIP file. 
 * Check if the files in the ZIP files containts valid ROM file and extract metainformation from them.
 *
 * @author Michaël Larouche <michael.larouche@kdemail.net>
 */
class ZipRomMetaData : public RomMetaData
{
public:
	ZipRomMetaData();
	virtual ~ZipRomMetaData();

	virtual RomMetaInformation extractMetaInformation(KFileItem* item);

private:
	bool isValidRomFile(const QString &mimeType);

private:
	class Private;
	Private *d;
};

}

#endif
