/*
    system.h - Base class for system plugin.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUSYSTEM_H
#define KAMEFUSYSTEM_H

#include <qobject.h>
#include <kdemacros.h>

class KPluginInfo;
namespace Kamefu {

/**
This class is the base class that define a emulated system.

@author Michaël Larouche
*/
class KDE_EXPORT System : public QObject
{
Q_OBJECT
public:
    System(QObject *parent, const char *name);

    virtual ~System();

	/**
	 * Public get method to retrive MIME type that
	 * the system registred to.
	 * @return the list of MIME type registred.
	 */
	QStringList getRegistredSystemMimeTypes() const;

	/**
	 * Set the plugin info associated with that system.
	 * Used by Kamefu::SystemManager.
	 */
	void setPluginInfo(KPluginInfo *info);

	/**
	 * Retrive the display name of the current system;
	 */
	QString displayName() const;

protected:
	/**
	 * Internal method used by System plugins to register
	 * to their ROM mimetype
	 * @param mimeType MIME type in form of application/x-rom-system
	 */
	void registerSystemMimeType(const QString &mimeType);

private:
	class Private;
	Private *d;
};

}

#endif
