/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VolumeDialog
extends Dialog
implements SelectionListener {
    private int volumeFilter;
    private double gain;
    private double volume;
    private Shell shell;
    private Button filterNone;
    private Button filterVolnorm;
    private Button filterVolume;
    private Button dismiss;
    private Text gainText;
    public static final double NONE = Double.MIN_VALUE;
    public static final double VOLNORM = Double.MAX_VALUE;

    public VolumeDialog(Shell shell, int n, int n2, double d) {
        super(shell, n);
        this.volumeFilter = n2;
        this.gain = d;
    }

    public double open() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Volume");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        this.shell.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Volume");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)this.getParent().getDisplay(), fontDataArray));
        Composite composite = new Composite((Composite)this.shell, 0);
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.filterNone = new Button(composite, 16);
        this.filterNone.setText("Apply no volume filter");
        this.filterNone.setSelection(this.volumeFilter == 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.filterNone.setLayoutData((Object)gridData);
        this.filterVolnorm = new Button(composite, 16);
        this.filterVolnorm.setText("Normalize the volume");
        this.filterVolnorm.setSelection(this.volumeFilter == 1);
        this.filterVolnorm.setLayoutData((Object)gridData);
        this.filterVolume = new Button(composite, 16);
        this.filterVolume.setText("Manually specify gain:");
        this.filterVolume.setSelection(this.volumeFilter == 2);
        this.gainText = new Text(composite, 2048);
        this.gainText.setText("-200.0");
        new Label(composite, 0).setText("dB");
        this.dismiss = new Button((Composite)this.shell, 8);
        this.dismiss.setText("Close");
        gridData = new GridData();
        gridData.widthHint = 75;
        gridData.horizontalAlignment = 131072;
        this.dismiss.setLayoutData((Object)gridData);
        this.dismiss.addSelectionListener((SelectionListener)this);
        this.shell.pack();
        this.gainText.setText("" + this.gain);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        return this.volume;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.dismiss) {
            if (this.filterNone.getSelection()) {
                this.volume = Double.MIN_VALUE;
            } else if (this.filterVolnorm.getSelection()) {
                this.volume = Double.MAX_VALUE;
            } else {
                try {
                    this.volume = Double.parseDouble(this.gainText.getText());
                    if (this.volume < -200.0 || this.volume > 60.0) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    MessageBox messageBox = new MessageBox(this.shell, 1);
                    messageBox.setText("Invalid Gain");
                    messageBox.setMessage("The gain must be between -200.0 dB and 60.0 dB.");
                    messageBox.open();
                    return;
                }
            }
            this.shell.dispose();
        }
    }
}

