/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.File;
import java.io.InputStream;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.thestaticvoid.iriverter.ConverterOptions;
import org.thestaticvoid.iriverter.SingleVideoInfo;
import org.thestaticvoid.iriverter.TabItemControl;

public class SingleVideo
extends Composite
implements SelectionListener,
TabItemControl,
SingleVideoInfo {
    private CTabItem tabItem;
    private Text inputVideoInput;
    private Text outputVideoInput;
    private Button inputVideoSelect;
    private Button outputVideoSelect;
    private String syncInputVideo;
    private String syncOutputVideo;

    public SingleVideo(Composite composite, int n, CTabItem cTabItem) {
        super(composite, n);
        this.tabItem = cTabItem;
        InputStream inputStream = this.getClass().getResourceAsStream("icons/singlevideo-16.png");
        cTabItem.setImage(new Image((Device)this.getDisplay(), inputStream));
        cTabItem.setText("New Single Video");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText("Single Video");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)this.getParent().getDisplay(), fontDataArray));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)this, 0);
        label2.setText("Input:");
        this.inputVideoInput = new Text((Composite)this, 2048);
        this.inputVideoInput.setLayoutData((Object)new GridData(768));
        this.inputVideoSelect = new Button((Composite)this, 8);
        this.inputVideoSelect.setText("Select");
        gridData = new GridData();
        gridData.widthHint = 75;
        this.inputVideoSelect.setLayoutData((Object)gridData);
        this.inputVideoSelect.addSelectionListener((SelectionListener)this);
        Label label3 = new Label((Composite)this, 0);
        label3.setText("Output:");
        this.outputVideoInput = new Text((Composite)this, 2048);
        this.outputVideoInput.setLayoutData((Object)new GridData(768));
        this.outputVideoSelect = new Button((Composite)this, 8);
        this.outputVideoSelect.setText("Select");
        gridData = new GridData();
        gridData.widthHint = 75;
        this.outputVideoSelect.setLayoutData((Object)gridData);
        this.outputVideoSelect.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string;
        FileDialog fileDialog;
        if (selectionEvent.getSource() == this.inputVideoSelect) {
            fileDialog = new FileDialog(this.getShell(), 4096);
            fileDialog.setText("Input Video");
            fileDialog.setFilterExtensions(new String[]{"*.avi;*.vob;*.mkv;*.mpg;*.mpeg;*.ogm;*.mov;*.rm;*.ram;*.wmv;*.asf", "*.avi", "*.vob", "*.mkv", "*.mpg;*.mpeg;*.mp4", "*.ogm", "*.mov", "*.rm;*.ram", "*.wmv;*.asf", "*"});
            fileDialog.setFilterNames(new String[]{"All Video Files", "AVI Video (*.avi)", "DVD Video Object (*.vob)", "Matroska Video (*.mkv)", "MPEG Video (*.mpg, *.mpeg, *.mp4)", "Ogg Video (*.ogm)", "Quicktime Movie (*.mov)", "Real Video (*.rm, *.ram)", "Windows Media Video (*.wmv, *.asf)", "All Files"});
            string = fileDialog.open();
            if (string != null) {
                this.inputVideoInput.setText(string);
                this.outputVideoInput.setText(string.substring(0, string.lastIndexOf(46)) + "." + ConverterOptions.getCurrentProfile().getProfileName() + "." + ConverterOptions.getCurrentProfile().getWrapperFormat());
                this.tabItem.setText(new File(string).getName());
            }
        }
        if (selectionEvent.getSource() == this.outputVideoSelect) {
            fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText("Output Video");
            if (ConverterOptions.getCurrentProfile().getWrapperFormat().equals("mp4")) {
                fileDialog.setFilterExtensions(new String[]{"*.mp4"});
                fileDialog.setFilterNames(new String[]{"MP4 Video (*.mp4)"});
            } else {
                fileDialog.setFilterExtensions(new String[]{"*.avi"});
                fileDialog.setFilterNames(new String[]{"AVI Video (*.avi)"});
            }
            string = fileDialog.open();
            if (string != null) {
                this.outputVideoInput.setText(string);
            }
        }
    }

    public void setTabItem(CTabItem cTabItem) {
        this.tabItem = cTabItem;
    }

    public void setInputVideo(String string) {
        this.tabItem.setText(new File(string).getName());
        this.inputVideoInput.setText(string);
        this.outputVideoInput.setText(string.substring(0, string.lastIndexOf(46)) + "." + ConverterOptions.getCurrentProfile().getProfileName() + ".avi");
    }

    public synchronized String getInputVideo() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SingleVideo.this.syncInputVideo = SingleVideo.this.inputVideoInput.getText();
            }
        });
        return this.syncInputVideo;
    }

    public synchronized String getOutputVideo() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SingleVideo.this.syncOutputVideo = SingleVideo.this.outputVideoInput.getText();
            }
        });
        return this.syncOutputVideo;
    }

    public synchronized void setOutputVideo(String string) {
        this.syncOutputVideo = string;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SingleVideo.this.outputVideoInput.setText(SingleVideo.this.syncOutputVideo);
            }
        });
    }
}

