/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.thestaticvoid.iriverter.Config;
import org.thestaticvoid.iriverter.Dimensions;
import org.thestaticvoid.iriverter.ProfileFilter;

public class Profile {
    private File profileFile;

    private Profile(File file) {
        this.profileFile = file;
    }

    public static Profile getProfile(String string) {
        return new Profile(new File(Config.getPackageDataDir() + File.separator + "profiles" + File.separator + string + ".profile"));
    }

    public static Profile[] getAllProfiles() {
        String[] stringArray = new File(Config.getPackageDataDir() + File.separator + "profiles" + File.separator).list(new ProfileFilter());
        Profile[] profileArray = new Profile[stringArray.length];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = new Profile(new File(Config.getPackageDataDir() + File.separator + "profiles" + File.separator + stringArray[i]));
        }
        return profileArray;
    }

    private String readOption(String string) {
        String string2 = "";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.profileFile));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(string + "=") <= -1) continue;
                string2 = string3.substring(string3.indexOf("=") + 1);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public String getProfileName() {
        String string = this.profileFile.getName();
        return string.substring(0, string.indexOf(46));
    }

    public String getBrand() {
        return this.readOption("brand");
    }

    public String getDevice() {
        return this.readOption("device");
    }

    public int getMaxVideoBitrate() {
        return Integer.parseInt(this.readOption("maxVideoBitrate"));
    }

    public int getMaxAudioBitrate() {
        return Integer.parseInt(this.readOption("maxAudioBitrate"));
    }

    public Dimensions[] getDimensions() {
        String[] stringArray = this.readOption("dimensions").split(" ");
        Dimensions[] dimensionsArray = new Dimensions[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dimensionsArray[i] = new Dimensions(stringArray[i]);
        }
        return dimensionsArray;
    }

    public double getMaxFrameRate() {
        return Double.parseDouble(this.readOption("maxFrameRate"));
    }

    public int getMaxLength() {
        try {
            return Integer.parseInt(this.readOption("maxLength"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getWrapperFormat() {
        String string = this.readOption("wrapperFormat");
        if (string.equals("")) {
            return "avi";
        }
        return string;
    }

    public String getVideoFormat() {
        String string = this.readOption("videoFormat");
        if (string.equals("")) {
            return "mpeg4";
        }
        return string;
    }

    public String getAudioFormat() {
        String string = this.readOption("audioFormat");
        if (string.equals("")) {
            return "mp3";
        }
        return string;
    }
}

