/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thestaticvoid.iriverter.Logger;
import org.thestaticvoid.iriverter.ProgressDialogInfo;

public class MencoderStreamParser
extends Thread {
    private ProgressDialogInfo progressDialogInfo;
    private String status;
    private BufferedReader input;
    private String inputLine = "";
    private String lengthLine = "";
    private boolean stopReading = false;

    public MencoderStreamParser(ProgressDialogInfo progressDialogInfo) {
        this.progressDialogInfo = progressDialogInfo;
        this.status = progressDialogInfo.getStatus();
    }

    public void parse(BufferedReader bufferedReader) {
        this.input = bufferedReader;
        this.start();
    }

    public void run() {
        ProgressUpdater progressUpdater = new ProgressUpdater();
        progressUpdater.start();
        try {
            while ((this.inputLine = this.input.readLine()) != null) {
                if (this.inputLine.indexOf("Pos:") == -1) {
                    Logger.logMessage(this.inputLine, 2);
                }
                if (this.inputLine.indexOf("Video stream:") <= -1) continue;
                this.lengthLine = this.inputLine;
            }
            this.input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        progressUpdater.stopUpdating();
    }

    public int getLength() {
        try {
            Matcher matcher = Pattern.compile("[0-9.]* secs").matcher(this.lengthLine);
            matcher.find();
            return (int)Double.parseDouble(matcher.group().substring(0, matcher.group().indexOf(32)));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public class ProgressUpdater
    extends Thread {
        private boolean stopUpdating = false;

        public void run() {
            while (!this.stopUpdating) {
                if (MencoderStreamParser.this.inputLine.indexOf("Pos:") > -1) {
                    MencoderStreamParser.this.progressDialogInfo.setPercentComplete(Integer.parseInt(MencoderStreamParser.this.inputLine.substring(MencoderStreamParser.this.inputLine.indexOf("(") + 1, MencoderStreamParser.this.inputLine.indexOf("%")).trim()));
                    String string = MencoderStreamParser.this.inputLine.substring(MencoderStreamParser.this.inputLine.indexOf("Trem:") + 6, MencoderStreamParser.this.inputLine.indexOf("min")).trim();
                    string = string.equals("0") ? "less than a minute remaining" : (string.equals("1") ? "about " + string + " minute remaining" : "about " + string + " minutes remaining");
                    MencoderStreamParser.this.progressDialogInfo.setStatus(MencoderStreamParser.this.status + " at " + MencoderStreamParser.this.inputLine.substring(MencoderStreamParser.this.inputLine.indexOf(")") + 1, MencoderStreamParser.this.inputLine.indexOf("fps")).trim() + " FPS with " + string);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void stopUpdating() {
            this.stopUpdating = true;
        }
    }
}

