/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thestaticvoid.iriverter.Dimensions;
import org.thestaticvoid.iriverter.Logger;

public class MPlayerInfo {
    private Process proc;
    private StringBuffer mplayerOutput;
    private boolean commandFound = true;

    public MPlayerInfo(String string) {
        this(string, null);
    }

    public MPlayerInfo(String string, String string2) {
        String[] stringArray = null;
        stringArray = string2 != null ? new String[]{MPlayerInfo.getMPlayerPath() + "mplayer", "-vo", "null", "-ao", "null", "-frames", "1", "-dvd-device", string2, string.toString(), "-v", "-identify"} : new String[]{MPlayerInfo.getMPlayerPath() + "mplayer", "-vo", "null", "-ao", "null", "-frames", "1", string.toString(), "-identify"};
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + stringArray[i] + " ";
        }
        Logger.logMessage(string3, 0);
        try {
            this.proc = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mplayerOutput = new StringBuffer();
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                this.mplayerOutput.append(string4 + "\n");
                Logger.logMessage(string4, 2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getVideoFormat() {
        Matcher matcher = Pattern.compile("ID_VIDEO_FORMAT=.*").matcher(this.mplayerOutput);
        matcher.find();
        String string = "";
        try {
            string = matcher.group();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string.substring(string.indexOf(61) + 1);
    }

    public int getLength() {
        Matcher matcher = Pattern.compile("ID_LENGTH=[0-9]*").matcher(this.mplayerOutput);
        matcher.find();
        String string = "";
        try {
            string = matcher.group();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return Integer.parseInt(string.substring(string.indexOf(61) + 1));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getNumberOfTitles() {
        Matcher matcher = Pattern.compile("ID_DVD_TITLES=[0-9]*").matcher(this.mplayerOutput);
        matcher.find();
        String string = matcher.group();
        return Integer.parseInt(string.substring(14));
    }

    public int getNumberOfChapters() {
        Matcher matcher = Pattern.compile("There are [0-9]* chapters").matcher(this.mplayerOutput);
        matcher.find();
        String string = matcher.group();
        return Integer.parseInt(string.substring(10, string.indexOf(" chapters")));
    }

    public Map getAudioStreams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("Default", "-1");
        Matcher matcher = Pattern.compile("audio stream: [0-9]* audio format: ac3.*").matcher(this.mplayerOutput);
        while (matcher.find()) {
            String string = matcher.group();
            String string2 = Integer.parseInt(string.substring(string.indexOf("stream: ") + 8, string.indexOf(" audio format:"))) + 1 + ". " + string.substring(string.indexOf("language: ") + 10, string.indexOf(" aid:"));
            linkedHashMap.put(string2, string.substring(string.indexOf(" aid: ") + 6));
        }
        return linkedHashMap;
    }

    public Map getSubtitleLanguages() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("None", "-1");
        Matcher matcher = Pattern.compile("[0-9]{1,} language: [a-z]{2}").matcher(this.mplayerOutput);
        while (matcher.find()) {
            String string = matcher.group();
            String string2 = Integer.parseInt(string.substring(0, string.indexOf(32))) + 1 + ". " + string.substring(string.indexOf(": ") + 2);
            linkedHashMap.put(string2, string.substring(0, string.indexOf(32)));
        }
        return linkedHashMap;
    }

    public double getFrameRate() {
        double d = 0.0;
        Matcher matcher = Pattern.compile("[0-9.]* fps").matcher(this.mplayerOutput);
        if (!matcher.find()) {
            return -1.0;
        }
        d = Double.parseDouble(matcher.group().substring(0, matcher.group().indexOf(32)));
        return d;
    }

    public Dimensions getDimensions() {
        Matcher matcher = Pattern.compile("=> [0-9]*x[0-9]*").matcher(this.mplayerOutput);
        if (!matcher.find()) {
            return new Dimensions(-1, -1);
        }
        return new Dimensions(matcher.group().substring(matcher.group().indexOf(32) + 1));
    }

    public static String getMPlayerPath() {
        File file = new File(".");
        String[] stringArray = file.list();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("mplayer")) {
                bl = true;
            }
            if (!stringArray[i].equals("mencoder")) continue;
            bl2 = true;
        }
        return bl && bl2 ? file.getAbsolutePath() + File.separator : "";
    }

    public boolean commandFound() {
        return this.commandFound;
    }

    public boolean videoSupported() {
        return this.getFrameRate() != -1.0 && this.getDimensions().getWidth() != -1 && this.getDimensions().getHeight() != -1;
    }
}

