/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.thestaticvoid.iriverter.ConverterOptions;
import org.thestaticvoid.iriverter.LogViewer;

public class Logger {
    public static final int INFO = 0;
    public static final int ERROR = 1;
    public static final int MPLAYER = 2;
    public static final String[] PREFIX = new String[]{"--- ", "!!! ", ">>> "};
    private static PrintWriter output;

    private static void openLogFile() {
        try {
            output = new PrintWriter(new BufferedWriter(new FileWriter(new File(System.getProperty("user.home") + File.separator + ".iriverter.log"))));
            if (LogViewer.getSingleton() != null) {
                LogViewer.getSingleton().clear();
            }
            Logger.logMessage("iriverter 0.16\n", 0);
            Logger.logMessage("Settings:\n" + ConverterOptions.getOptionsText().trim() + "\n", 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void logMessage(String string, int n) {
        String[] stringArray = string.split("\n", -1);
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                Logger.logMessage(stringArray[i], n);
            }
            return;
        }
        string = PREFIX[n] + stringArray[0];
        System.out.println(string);
        System.out.flush();
        if (output == null) {
            Logger.openLogFile();
        }
        output.println(string);
        output.flush();
        if (LogViewer.getSingleton() != null) {
            LogViewer.getSingleton().logMessage(string);
        }
    }

    public static String getLogText() {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(System.getProperty("user.home") + File.separator + ".iriverter.log"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = "";
        if (inputStream != null) {
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) > 0) {
                    string = string + new String(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string;
    }
}

