/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.thestaticvoid.iriverter.Logger;

public class LogViewer
implements SelectionListener {
    private static LogViewer singleton;
    private Shell shell;
    private ToolItem save;
    private StyledText text;
    private List lineColors;

    public LogViewer() {
        if (singleton != null) {
            return;
        }
        this.lineColors = new ArrayList();
        Display display = Display.getDefault();
        this.shell = new Shell(display);
        this.shell.setText("Log Viewer");
        this.shell.setLayout((Layout)new GridLayout());
        ToolBar toolBar = new ToolBar((Composite)this.shell, 0x800100);
        this.save = new ToolItem(toolBar, 8);
        InputStream inputStream = this.getClass().getResourceAsStream("icons/save-24.png");
        this.save.setImage(new Image((Device)display, inputStream));
        this.save.addSelectionListener((SelectionListener)this);
        this.text = new StyledText((Composite)this.shell, 2632);
        this.text.setFont(new Font((Device)display, new FontData("monospace", 10, 0)));
        this.text.setLayoutData((Object)new GridData(1808));
        String[] stringArray = Logger.getLogText().split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.logMessage(stringArray[i]);
        }
        this.shell.open();
        singleton = this;
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.shell.dispose();
        singleton = null;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.save) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText("Output Video");
            fileDialog.setFilterExtensions(new String[]{"*.txt"});
            fileDialog.setFilterNames(new String[]{"Text Files (*.txt)"});
            fileDialog.setFileName("iriverter-" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".txt");
            String string = fileDialog.open();
            if (string != null) {
                try {
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(string))));
                    String[] stringArray = Logger.getLogText().split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        printWriter.println(stringArray[i]);
                    }
                    printWriter.close();
                }
                catch (IOException iOException) {
                    Logger.logMessage("Could not write file " + string, 1);
                }
            }
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void close() {
        this.shell.dispose();
        singleton = null;
    }

    public void logMessage(final String string) {
        if (string.equals("")) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                LogViewer.this.text.append(string + "\n");
                if (string.charAt(0) == Logger.PREFIX[0].charAt(0)) {
                    LogViewer.this.lineColors.add(new Color((Device)Display.getDefault(), 240, 255, 126));
                } else if (string.charAt(0) == Logger.PREFIX[1].charAt(0)) {
                    LogViewer.this.lineColors.add(new Color((Device)Display.getDefault(), 255, 137, 126));
                } else if (string.charAt(0) == Logger.PREFIX[2].charAt(0)) {
                    LogViewer.this.lineColors.add(new Color((Device)Display.getDefault(), 126, 160, 255));
                } else {
                    LogViewer.this.lineColors.add(new Color((Device)Display.getDefault(), 255, 255, 255));
                }
                for (int i = 0; i < LogViewer.this.lineColors.size(); ++i) {
                    LogViewer.this.text.setLineBackground(i, 1, (Color)LogViewer.this.lineColors.get(i));
                }
                LogViewer.this.text.setSelection(LogViewer.this.text.getCharCount());
            }
        });
    }

    public void clear() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                LogViewer.this.text.setText("");
                LogViewer.this.lineColors.clear();
            }
        });
    }

    public static LogViewer getSingleton() {
        return singleton;
    }
}

