/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.File;
import java.io.InputStream;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.thestaticvoid.iriverter.ConverterOptions;
import org.thestaticvoid.iriverter.DirectoryInfo;
import org.thestaticvoid.iriverter.TabItemControl;

public class Directory
extends Composite
implements SelectionListener,
TabItemControl,
DirectoryInfo {
    private CTabItem tabItem;
    private Text inputDirectoryInput;
    private Text outputDirectoryInput;
    private Button inputDirectorySelect;
    private Button outputDirectorySelect;
    private Button convertSubdirectories;
    private String syncInputDirectory;
    private String syncOutputDirectory;
    private boolean syncConvertSubdirectories;

    public Directory(Composite composite, int n, CTabItem cTabItem) {
        super(composite, n);
        this.tabItem = cTabItem;
        InputStream inputStream = this.getClass().getResourceAsStream("icons/directory-16.png");
        cTabItem.setImage(new Image((Device)this.getDisplay(), inputStream));
        cTabItem.setText("New Directory");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText("Directory");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)this.getParent().getDisplay(), fontDataArray));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)this, 0);
        label2.setText("Input:");
        this.inputDirectoryInput = new Text((Composite)this, 2048);
        this.inputDirectoryInput.setLayoutData((Object)new GridData(768));
        this.inputDirectorySelect = new Button((Composite)this, 8);
        this.inputDirectorySelect.setText("Select");
        gridData = new GridData();
        gridData.widthHint = 75;
        this.inputDirectorySelect.setLayoutData((Object)gridData);
        this.inputDirectorySelect.addSelectionListener((SelectionListener)this);
        Label label3 = new Label((Composite)this, 0);
        label3.setText("Output:");
        this.outputDirectoryInput = new Text((Composite)this, 2048);
        this.outputDirectoryInput.setLayoutData((Object)new GridData(768));
        this.outputDirectorySelect = new Button((Composite)this, 8);
        this.outputDirectorySelect.setText("Select");
        gridData = new GridData();
        gridData.widthHint = 75;
        this.outputDirectorySelect.setLayoutData((Object)gridData);
        this.outputDirectorySelect.addSelectionListener((SelectionListener)this);
        new Label((Composite)this, 0);
        this.convertSubdirectories = new Button((Composite)this, 32);
        this.convertSubdirectories.setText("Convert Subdirectories");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.convertSubdirectories.setLayoutData((Object)gridData);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string;
        DirectoryDialog directoryDialog;
        if (selectionEvent.getSource() == this.inputDirectorySelect) {
            directoryDialog = new DirectoryDialog(this.getShell());
            directoryDialog.setText("Input Directory");
            string = directoryDialog.open();
            if (string != null) {
                this.inputDirectoryInput.setText(string);
                this.outputDirectoryInput.setText(string + "-" + ConverterOptions.getCurrentProfile().getProfileName());
                this.tabItem.setText(new File(string).getName());
            }
        }
        if (selectionEvent.getSource() == this.outputDirectorySelect) {
            directoryDialog = new DirectoryDialog(this.getShell());
            directoryDialog.setText("Output Directory");
            string = directoryDialog.open();
            if (string != null) {
                this.outputDirectoryInput.setText(string);
            }
        }
    }

    public void setTabItem(CTabItem cTabItem) {
        this.tabItem = cTabItem;
    }

    public void setInputDirectory(String string) {
        this.tabItem.setText(new File(string).getName());
        this.inputDirectoryInput.setText(string);
        this.outputDirectoryInput.setText(string + "-" + ConverterOptions.getCurrentProfile().getProfileName());
    }

    public synchronized String getInputDirectory() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Directory.this.syncInputDirectory = Directory.this.inputDirectoryInput.getText();
            }
        });
        return this.syncInputDirectory;
    }

    public synchronized String getOutputDirectory() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Directory.this.syncOutputDirectory = Directory.this.outputDirectoryInput.getText();
            }
        });
        return this.syncOutputDirectory;
    }

    public synchronized boolean getConvertSubdirectories() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Directory.this.syncConvertSubdirectories = Directory.this.convertSubdirectories.getSelection();
            }
        });
        return this.syncConvertSubdirectories;
    }
}

