/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.thestaticvoid.iriverter.ChapterDialog;
import org.thestaticvoid.iriverter.Chapters;
import org.thestaticvoid.iriverter.ConverterOptions;
import org.thestaticvoid.iriverter.DVDInfo;
import org.thestaticvoid.iriverter.DVDInfoReader;
import org.thestaticvoid.iriverter.DVDProgressDialog;
import org.thestaticvoid.iriverter.DVDTitleInfo;
import org.thestaticvoid.iriverter.Logger;
import org.thestaticvoid.iriverter.MPlayerInfo;
import org.thestaticvoid.iriverter.TabItemControl;

public class DVD
extends Composite
implements SelectionListener,
TabItemControl,
DVDInfo {
    private CTabItem tabItem;
    private Combo dvdCombo;
    private Combo titleCombo;
    private Combo audioStreamCombo;
    private Combo subtitlesCombo;
    private Map titleInfo;
    private Map audioStreams;
    private Map subtitles;
    private Button chapterSelection;
    private Button previewButton;
    private Button outputVideoSelect;
    private Text outputVideoInput;
    private Chapters[] chapters;
    private String syncDrive;
    private String syncOutputVideo;
    private DVDProgressDialog progressDialog;
    private int syncTitle;
    private int syncAudioStream;
    private int syncSubtitles;
    private Process proc;

    public DVD(Composite composite, int n, CTabItem cTabItem) {
        super(composite, n);
        this.tabItem = cTabItem;
        this.titleInfo = new LinkedHashMap();
        InputStream inputStream = this.getClass().getResourceAsStream("icons/dvd-16.png");
        cTabItem.setImage(new Image((Device)this.getDisplay(), inputStream));
        cTabItem.setText("New DVD");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 12;
        gridLayout.marginTop = 12;
        gridLayout.marginBottom = 0;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText("DVD");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)this.getParent().getDisplay(), fontDataArray));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        Group group = new Group(composite3, 0);
        group.setText("Locations");
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1808));
        Label label2 = new Label((Composite)group, 0);
        label2.setText("DVD Drive:");
        this.dvdCombo = new Combo((Composite)group, 12);
        this.dvdCombo.setItems(this.getDVDDrives());
        this.dvdCombo.select(0);
        this.dvdCombo.setLayoutData((Object)new GridData(768));
        this.dvdCombo.addSelectionListener((SelectionListener)this);
        Label label3 = new Label((Composite)group, 0);
        label3.setText("Title:");
        this.titleCombo = new Combo((Composite)group, 12);
        this.titleCombo.setLayoutData((Object)new GridData(768));
        this.titleCombo.addSelectionListener((SelectionListener)this);
        this.chapterSelection = new Button((Composite)group, 8);
        this.chapterSelection.setText("Chapters");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.chapterSelection.setLayoutData((Object)gridData);
        this.chapterSelection.addSelectionListener((SelectionListener)this);
        Group group2 = new Group(composite3, 0);
        group2.setText("Languages");
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        group2.setLayoutData((Object)new GridData(1808));
        Label label4 = new Label((Composite)group2, 0);
        label4.setText("Audio Stream:");
        this.audioStreamCombo = new Combo((Composite)group2, 12);
        this.audioStreamCombo.setLayoutData((Object)new GridData(768));
        Label label5 = new Label((Composite)group2, 0);
        label5.setText("Subtitles:");
        this.subtitlesCombo = new Combo((Composite)group2, 12);
        this.subtitlesCombo.setLayoutData((Object)new GridData(768));
        this.previewButton = new Button((Composite)group2, 8);
        this.previewButton.setText("Preview");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.previewButton.setLayoutData((Object)gridData);
        this.previewButton.addSelectionListener((SelectionListener)this);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        composite4.setLayout((Layout)gridLayout);
        Label label6 = new Label(composite4, 0);
        label6.setText("Output:");
        this.outputVideoInput = new Text(composite4, 2048);
        this.outputVideoInput.setLayoutData((Object)new GridData(768));
        this.outputVideoSelect = new Button(composite4, 8);
        this.outputVideoSelect.setText("Select");
        gridData = new GridData();
        gridData.widthHint = 75;
        this.outputVideoSelect.setLayoutData((Object)gridData);
        this.outputVideoSelect.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string;
        Object object;
        if (selectionEvent.getSource() == this.dvdCombo) {
            if (this.dvdCombo.getText().equals("Other...")) {
                object = new DirectoryDialog(this.getShell(), 0);
                object.setText("DVD Device");
                string = object.open();
                if (string != null && new File(string + File.separator + "VIDEO_TS").exists()) {
                    if (this.dvdCombo.getItem(0).equals("None Found")) {
                        this.dvdCombo.remove(0);
                    }
                    this.dvdCombo.add(string, 0);
                    this.dvdCombo.select(0);
                }
            }
            this.setTitleCombo();
        }
        if (selectionEvent.getSource() == this.titleCombo) {
            this.chapters = null;
            this.setLanguageCombos();
        }
        if (selectionEvent.getSource() == this.chapterSelection) {
            if (this.dvdCombo.getText().equals("None Found") || this.dvdCombo.getText().equals("Other...")) {
                return;
            }
            object = null;
            object = this.chapters == null ? new ChapterDialog(this.getParent().getShell(), 0, ((DVDTitleInfo)this.titleInfo.get(this.titleCombo.getText())).getNumberOfChapters(), true) : new ChapterDialog(this.getParent().getShell(), 0, ((DVDTitleInfo)this.titleInfo.get(this.titleCombo.getText())).getNumberOfChapters(), this.chapters);
            this.chapters = object.open();
        }
        if (selectionEvent.getSource() == this.previewButton && !this.getDrive().equals("")) {
            try {
                object = new ArrayList();
                object.add(MPlayerInfo.getMPlayerPath() + "mplayer");
                object.add("-dvd-device");
                object.add(this.getDrive());
                object.add("dvd://" + this.getTitle());
                if (this.getAudioStream() > -1) {
                    object.add("-aid");
                    object.add("" + this.getAudioStream());
                }
                if (this.getSubtitles() > -1) {
                    object.add("-sid");
                    object.add("" + this.getSubtitles());
                }
                string = "";
                String[] stringArray = new String[object.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)object.get(i);
                    string = string + stringArray[i] + " ";
                }
                Logger.logMessage(string, 0);
                this.proc = Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (selectionEvent.getSource() == this.outputVideoSelect) {
            object = new FileDialog(this.getShell(), 8192);
            object.setText("Output Video");
            if (ConverterOptions.getCurrentProfile().getWrapperFormat().equals("mp4")) {
                object.setFilterExtensions(new String[]{"*.mp4"});
                object.setFilterNames(new String[]{"MP4 Video (*.mp4)"});
            } else {
                object.setFilterExtensions(new String[]{"*.avi"});
                object.setFilterNames(new String[]{"AVI Video (*.avi)"});
            }
            string = object.open();
            if (string != null) {
                this.outputVideoInput.setText(string);
            }
        }
    }

    private String[] getDVDDrives() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (System.getProperty("os.name").indexOf("Windows") > -1) {
            for (char c = 'D'; c <= 'Z'; c = (char)(c + 1)) {
                try {
                    object = new File(c + ":\\");
                    if (!((File)object).canRead() || !new File(((File)object).getAbsolutePath() + "VIDEO_TS").exists()) continue;
                    arrayList.add(((File)object).getAbsolutePath());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            try {
                String string;
                Process process = Runtime.getRuntime().exec("mount");
                object = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    String string2;
                    if (!string.substring(0, 4).equals("/dev") || !new File((string2 = string.split(" ")[2]) + File.separator + "VIDEO_TS").exists()) continue;
                    arrayList.add(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add("None Found");
        }
        arrayList.add("Other...");
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public void setTitleCombo() {
        if (this.dvdCombo.getText().equals("None Found") || this.dvdCombo.getText().equals("Other...")) {
            this.titleCombo.removeAll();
            this.audioStreamCombo.removeAll();
            this.subtitlesCombo.removeAll();
            return;
        }
        this.tabItem.setText(this.dvdCombo.getText());
        this.progressDialog = new DVDProgressDialog(this.getShell(), 0);
        DVDInfoReader dVDInfoReader = new DVDInfoReader(this.progressDialog, this.dvdCombo.getText());
        this.progressDialog.open();
        this.titleInfo = dVDInfoReader.getTitleInfo();
        this.titleCombo.removeAll();
        for (int i = 0; i < this.titleInfo.keySet().toArray().length; ++i) {
            this.titleCombo.add((String)this.titleInfo.keySet().toArray()[i]);
        }
        this.titleCombo.select(0);
        this.setLanguageCombos();
    }

    private void setLanguageCombos() {
        int n;
        this.audioStreams = ((DVDTitleInfo)this.titleInfo.get(this.titleCombo.getText())).getAudioStreams();
        this.subtitles = ((DVDTitleInfo)this.titleInfo.get(this.titleCombo.getText())).getSubtitles();
        this.audioStreamCombo.removeAll();
        for (n = 0; n < this.audioStreams.keySet().size(); ++n) {
            this.audioStreamCombo.add((String)this.audioStreams.keySet().toArray()[n]);
        }
        this.audioStreamCombo.select(0);
        this.subtitlesCombo.removeAll();
        for (n = 0; n < this.subtitles.keySet().size(); ++n) {
            this.subtitlesCombo.add((String)this.subtitles.keySet().toArray()[n]);
        }
        this.subtitlesCombo.select(0);
    }

    public Map getTitleInfo() {
        return this.titleInfo;
    }

    public void setTitleInfo(Map map) {
        this.titleInfo = map;
        for (int i = 0; i < map.size(); ++i) {
            this.titleCombo.add((String)map.keySet().toArray()[i]);
        }
        if (map.size() > 0) {
            this.titleCombo.select(0);
            this.setLanguageCombos();
        }
    }

    public void setTabItem(CTabItem cTabItem) {
        this.tabItem = cTabItem;
    }

    public void setDrive(String string) {
        for (int i = 0; i < this.dvdCombo.getItemCount(); ++i) {
            if (!this.dvdCombo.getItem(i).equals(string)) continue;
            this.tabItem.setText(string);
            return;
        }
        this.tabItem.setText(string);
        if (this.dvdCombo.getItem(0).equals("None Found")) {
            this.dvdCombo.remove(0);
        }
        this.dvdCombo.add(string, 0);
        this.dvdCombo.select(0);
    }

    public synchronized String getDrive() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DVD.this.syncDrive = DVD.this.dvdCombo.getText().equals("None Found") || DVD.this.dvdCombo.getText().equals("Other...") ? "" : DVD.this.dvdCombo.getText();
            }
        });
        return this.syncDrive;
    }

    public synchronized int getTitle() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DVD.this.syncTitle = DVD.this.titleCombo.getText().equals("") ? -1 : Integer.parseInt(DVD.this.titleCombo.getText().substring(0, DVD.this.titleCombo.getText().indexOf(46)));
            }
        });
        return this.syncTitle;
    }

    public synchronized Chapters[] getChapters() {
        return this.chapters;
    }

    public synchronized int getAudioStream() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DVD.this.syncAudioStream = DVD.this.audioStreams.get(DVD.this.audioStreamCombo.getText()).equals("") ? -1 : Integer.parseInt((String)DVD.this.audioStreams.get(DVD.this.audioStreamCombo.getText()));
            }
        });
        return this.syncAudioStream;
    }

    public synchronized int getSubtitles() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DVD.this.syncSubtitles = DVD.this.subtitles.get(DVD.this.subtitlesCombo.getText()).equals("") ? -1 : Integer.parseInt((String)DVD.this.subtitles.get(DVD.this.subtitlesCombo.getText()));
            }
        });
        return this.syncSubtitles;
    }

    public synchronized String getOutputVideo() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DVD.this.syncOutputVideo = DVD.this.outputVideoInput.getText();
            }
        });
        return this.syncOutputVideo;
    }

    public synchronized void setOutputVideo(String string) {
        this.syncOutputVideo = string;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DVD.this.outputVideoInput.setText(DVD.this.syncOutputVideo);
            }
        });
    }
}

