/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.thestaticvoid.iriverter.AboutDialog;
import org.thestaticvoid.iriverter.AudioSyncDialog;
import org.thestaticvoid.iriverter.AutomaticallySplitDialog;
import org.thestaticvoid.iriverter.Bitrate;
import org.thestaticvoid.iriverter.BitrateDialog;
import org.thestaticvoid.iriverter.Config;
import org.thestaticvoid.iriverter.Converter;
import org.thestaticvoid.iriverter.ConverterOptions;
import org.thestaticvoid.iriverter.DVD;
import org.thestaticvoid.iriverter.Dimensions;
import org.thestaticvoid.iriverter.Directory;
import org.thestaticvoid.iriverter.HelpBrowser;
import org.thestaticvoid.iriverter.JoinVideos;
import org.thestaticvoid.iriverter.LogViewer;
import org.thestaticvoid.iriverter.Logger;
import org.thestaticvoid.iriverter.MPlayerInfo;
import org.thestaticvoid.iriverter.ManualSplit;
import org.thestaticvoid.iriverter.Profile;
import org.thestaticvoid.iriverter.ProgressDialog;
import org.thestaticvoid.iriverter.SingleVideo;
import org.thestaticvoid.iriverter.TabItemControl;
import org.thestaticvoid.iriverter.VideoFileFilter;
import org.thestaticvoid.iriverter.VolumeDialog;

public class ConverterUI
implements SelectionListener,
CTabFolder2Listener,
DropTargetListener {
    private Display display = new Display();
    private Shell shell = new Shell(this.display);
    private ToolItem convertTool;
    private ToolItem newSingleVideoTool;
    private ToolItem newDirectoryTool;
    private ToolItem newDVDTool;
    private CTabFolder tabFolder;
    private Map profileMenuItems;
    private Map dimensionsMenuItems;
    private MenuItem convert;
    private MenuItem playFile;
    private MenuItem newSingleVideo;
    private MenuItem newDirectory;
    private MenuItem newDVD;
    private MenuItem advancedJobs;
    private MenuItem manualSplit;
    private MenuItem joinVideos;
    private MenuItem moveUp;
    private MenuItem moveDown;
    private MenuItem closeJob;
    private MenuItem closeAllJobs;
    private MenuItem quit;
    private MenuItem bitrate;
    private MenuItem videoSize;
    private MenuItem panAndScan;
    private MenuItem advancedOptions;
    private MenuItem audioSync;
    private MenuItem automaticallySplit;
    private MenuItem volume;
    private MenuItem contents;
    private MenuItem logViewer;
    private MenuItem about;
    private Menu videoSizeMenu;
    private DropTarget target;
    private String fileName;
    private Process proc;
    private ProgressDialog progressDialog;

    public ConverterUI() {
        this.shell.setText("iriverter");
        InputStream inputStream = this.getClass().getResourceAsStream("icons/iriverter.png");
        this.shell.setImage(new Image((Device)this.display, inputStream));
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.shell.setLayout((Layout)gridLayout);
        this.setupMenus();
        this.setupToolBar();
        this.tabFolder = new CTabFolder((Composite)this.shell, 64);
        this.tabFolder.setSimple(false);
        this.tabFolder.setBorderVisible(true);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.addSelectionListener((SelectionListener)this);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)this);
        this.target = new DropTarget((Control)this.shell, 3);
        this.target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        this.target.addDropListener((DropTargetListener)this);
        this.shell.setMinimumSize(400, 267);
        this.shell.setSize(500, 334);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    public void setupMenus() {
        MenuItem menuItem;
        String string;
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem menuItem2 = new MenuItem(menu, 64);
        menuItem2.setText("&Jobs");
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem2.setMenu(menu2);
        this.convert = new MenuItem(menu2, 8);
        this.convert.setText("&Convert...\tShift+Ctrl+C");
        this.convert.setAccelerator(393283);
        this.convert.addSelectionListener((SelectionListener)this);
        this.playFile = new MenuItem(menu2, 8);
        this.playFile.setText("&Play File...\tShift+Ctrl+F");
        this.playFile.setAccelerator(393286);
        this.playFile.addSelectionListener((SelectionListener)this);
        new MenuItem(menu2, 2);
        MenuItem menuItem3 = new MenuItem(menu2, 64);
        menuItem3.setText("&New");
        Menu menu3 = new Menu((Decorations)this.shell, 4);
        menuItem3.setMenu(menu3);
        this.newSingleVideo = new MenuItem(menu3, 8);
        this.newSingleVideo.setText("&Single Video\tShift+Ctrl+S");
        this.newSingleVideo.setAccelerator(393299);
        this.newSingleVideo.addSelectionListener((SelectionListener)this);
        this.newDirectory = new MenuItem(menu3, 8);
        this.newDirectory.setText("&Directory\tShift+Ctrl+D");
        this.newDirectory.setAccelerator(393284);
        this.newDirectory.addSelectionListener((SelectionListener)this);
        this.newDVD = new MenuItem(menu3, 8);
        this.newDVD.setText("D&VD\tShift+Ctrl+V");
        this.newDVD.setAccelerator(393302);
        this.newDVD.addSelectionListener((SelectionListener)this);
        this.advancedJobs = new MenuItem(menu3, 64);
        this.advancedJobs.setText("&Advanced");
        this.advancedJobs.setEnabled(ConverterOptions.getCurrentProfile().getWrapperFormat().equals("avi"));
        Menu menu4 = new Menu((Decorations)this.shell, 4);
        this.advancedJobs.setMenu(menu4);
        this.manualSplit = new MenuItem(menu4, 8);
        this.manualSplit.setText("Manual &Split");
        this.manualSplit.addSelectionListener((SelectionListener)this);
        this.joinVideos = new MenuItem(menu4, 8);
        this.joinVideos.setText("&Join Videos");
        this.joinVideos.addSelectionListener((SelectionListener)this);
        new MenuItem(menu2, 2);
        this.moveUp = new MenuItem(menu2, 8);
        this.moveUp.setText("Move &Up\tPage Up");
        this.moveUp.setAccelerator(0x1000005);
        this.moveUp.setEnabled(false);
        this.moveUp.addSelectionListener((SelectionListener)this);
        this.moveDown = new MenuItem(menu2, 8);
        this.moveDown.setText("Move &Down\tPage Down");
        this.moveDown.setAccelerator(0x1000006);
        this.moveDown.setEnabled(false);
        this.moveDown.addSelectionListener((SelectionListener)this);
        new MenuItem(menu2, 2);
        this.closeJob = new MenuItem(menu2, 8);
        this.closeJob.setText("&Close\tCtrl+W");
        this.closeJob.setAccelerator(262231);
        this.closeJob.setEnabled(false);
        this.closeJob.addSelectionListener((SelectionListener)this);
        this.closeAllJobs = new MenuItem(menu2, 8);
        this.closeAllJobs.setText("&Close All\tShift+Ctrl+W");
        this.closeAllJobs.setAccelerator(393303);
        this.closeAllJobs.setEnabled(false);
        this.closeAllJobs.addSelectionListener((SelectionListener)this);
        this.quit = new MenuItem(menu2, 8);
        this.quit.setText("&Quit\tCtrl+Q");
        this.quit.setAccelerator(262225);
        this.quit.addSelectionListener((SelectionListener)this);
        MenuItem menuItem4 = new MenuItem(menu, 64);
        menuItem4.setText("&Options");
        Menu menu5 = new Menu((Decorations)this.shell, 4);
        menuItem4.setMenu(menu5);
        MenuItem menuItem5 = new MenuItem(menu5, 64);
        menuItem5.setText("&Device");
        Menu menu6 = new Menu((Decorations)this.shell, 4);
        menuItem5.setMenu(menu6);
        this.profileMenuItems = new HashMap();
        Profile[] profileArray = Profile.getAllProfiles();
        Profile profile = ConverterOptions.getCurrentProfile();
        HashMap<String, Profile> hashMap = new HashMap<String, Profile>();
        TreeMap<String, TreeSet<String>> treeMap = new TreeMap<String, TreeSet<String>>();
        for (int i = 0; i < profileArray.length; ++i) {
            TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(profileArray[i].getBrand());
            if (treeSet == null) {
                treeSet = new TreeSet<String>();
                treeMap.put(profileArray[i].getBrand(), treeSet);
            }
            treeSet.add(profileArray[i].getDevice());
            hashMap.put(profileArray[i].getDevice(), profileArray[i]);
        }
        Iterator iterator = treeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            menuItem = new MenuItem(menu6, 64);
            menuItem.setText("&" + (n + 1) + " " + string);
            Menu menu7 = new Menu((Decorations)this.shell, 4);
            menuItem.setMenu(menu7);
            Iterator iterator2 = ((Set)treeMap.get(string)).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                Profile profile2 = (Profile)hashMap.get(string2);
                MenuItem menuItem6 = new MenuItem(menu7, 16);
                menuItem6.setText("&" + (n2 + 1) + " " + string2);
                menuItem6.setSelection(profile2.getProfileName().equals(profile.getProfileName()));
                menuItem6.addSelectionListener((SelectionListener)this);
                this.profileMenuItems.put(menuItem6, profile2.getProfileName());
                ++n2;
            }
            ++n;
        }
        new MenuItem(menu5, 2);
        this.bitrate = new MenuItem(menu5, 8);
        this.bitrate.setText("&Bitrate...\tShift+Ctrl+B");
        this.bitrate.setAccelerator(393282);
        this.bitrate.addSelectionListener((SelectionListener)this);
        new MenuItem(menu5, 2);
        this.videoSize = new MenuItem(menu5, 64);
        this.videoSize.setText("Video &Size");
        this.videoSizeMenu = new Menu((Decorations)this.shell, 4);
        this.videoSize.setMenu(this.videoSizeMenu);
        new MenuItem(menu5, 2);
        this.panAndScan = new MenuItem(menu5, 32);
        this.panAndScan.setText("&Pan and Scan\tShift+Ctrl+P");
        this.panAndScan.setAccelerator(393296);
        this.panAndScan.setSelection(ConverterOptions.getPanAndScan());
        this.panAndScan.addSelectionListener((SelectionListener)this);
        this.advancedOptions = new MenuItem(menu5, 64);
        this.advancedOptions.setText("&Advanced");
        Menu menu8 = new Menu((Decorations)this.shell, 4);
        this.advancedOptions.setMenu(menu8);
        this.audioSync = new MenuItem(menu8, 8);
        this.audioSync.setText("Audio &Sync...");
        this.audioSync.addSelectionListener((SelectionListener)this);
        this.automaticallySplit = new MenuItem(menu8, 8);
        this.automaticallySplit.setText("&Automatically Split...");
        this.automaticallySplit.addSelectionListener((SelectionListener)this);
        this.automaticallySplit.setEnabled(ConverterOptions.getCurrentProfile().getWrapperFormat().equals("avi"));
        this.volume = new MenuItem(menu8, 8);
        this.volume.setText("&Volume...");
        this.volume.addSelectionListener((SelectionListener)this);
        string = new MenuItem(menu, 64);
        string.setText("&Help");
        menuItem = new Menu((Decorations)this.shell, 4);
        string.setMenu((Menu)menuItem);
        this.contents = new MenuItem((Menu)menuItem, 8);
        this.contents.setText("&Contents\tF1");
        this.contents.setAccelerator(0x100000A);
        this.contents.addSelectionListener((SelectionListener)this);
        this.logViewer = new MenuItem((Menu)menuItem, 8);
        this.logViewer.setText("&Log Viewer");
        this.logViewer.addSelectionListener((SelectionListener)this);
        new MenuItem((Menu)menuItem, 2);
        this.about = new MenuItem((Menu)menuItem, 8);
        this.about.setText("&About");
        this.about.addSelectionListener((SelectionListener)this);
        this.dimensionsMenuItems = new HashMap();
        this.profileChanged();
    }

    public void setupToolBar() {
        ToolBar toolBar = new ToolBar((Composite)this.shell, 0x800100);
        toolBar.setLayoutData((Object)new GridData(768));
        this.convertTool = new ToolItem(toolBar, 8);
        InputStream inputStream = this.getClass().getResourceAsStream("icons/convert-24.png");
        this.convertTool.setImage(new Image((Device)this.display, inputStream));
        this.convertTool.setToolTipText("Convert");
        this.convertTool.addSelectionListener((SelectionListener)this);
        new ToolItem(toolBar, 2);
        this.newSingleVideoTool = new ToolItem(toolBar, 8);
        inputStream = this.getClass().getResourceAsStream("icons/singlevideo-24.png");
        this.newSingleVideoTool.setImage(new Image((Device)this.display, inputStream));
        this.newSingleVideoTool.setToolTipText("Single Video");
        this.newSingleVideoTool.addSelectionListener((SelectionListener)this);
        this.newDirectoryTool = new ToolItem(toolBar, 8);
        inputStream = this.getClass().getResourceAsStream("icons/directory-24.png");
        this.newDirectoryTool.setImage(new Image((Device)this.display, inputStream));
        this.newDirectoryTool.setToolTipText("Directory");
        this.newDirectoryTool.addSelectionListener((SelectionListener)this);
        this.newDVDTool = new ToolItem(toolBar, 8);
        inputStream = this.getClass().getResourceAsStream("icons/dvd-24.png");
        this.newDVDTool.setImage(new Image((Device)this.display, inputStream));
        this.newDVDTool.setToolTipText("DVD");
        this.newDVDTool.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        CTabItem cTabItem;
        int n;
        Object object;
        Object object2;
        Object object3;
        if (selectionEvent.getSource() == this.tabFolder) {
            this.tabChanged(false);
        }
        if (selectionEvent.getSource() == this.convert || selectionEvent.getSource() == this.convertTool) {
            object3 = new ArrayList();
            for (int i = 0; i < this.tabFolder.getItemCount(); ++i) {
                object3.add(this.tabFolder.getItem(i).getControl());
            }
            this.progressDialog = new ProgressDialog(this.shell, 0);
            object2 = new Converter((List)object3, this.progressDialog);
            ((Thread)object2).start();
            this.progressDialog.open();
            ((Converter)object2).cancel();
        }
        if (selectionEvent.getSource() == this.playFile) {
            object3 = new FileDialog(this.shell, 4096);
            object3.setText("Input Video");
            object3.setFilterExtensions(new String[]{"*.avi;*.vob;*.mkv;*.mpg;*.mpeg;*.ogm;*.mov;*.rm;*.ram;*.wmv;*.asf", "*.avi", "*.vob", "*.mkv", "*.mpg;*.mpeg", "*.ogm", "*.mov", "*.rm;*.ram", "*.wmv;*.asf"});
            object3.setFilterNames(new String[]{"All Video Files", "AVI Video (*.avi)", "DVD Video Object (*.vob)", "Matroska Video (*.mkv)", "MPEG Video (*.mpg, *.mpeg)", "Ogg Video (*.ogm)", "Quicktime Movie (*.mov)", "Real Video (*.rm, *.ram)", "Windows Media Video (*.wmv, *.asf)"});
            object2 = object3.open();
            if (object2 != null) {
                try {
                    this.proc = Runtime.getRuntime().exec(new String[]{MPlayerInfo.getMPlayerPath() + "mplayer", object2});
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (selectionEvent.getSource() == this.newSingleVideo || selectionEvent.getSource() == this.newSingleVideoTool) {
            this.newSingleVideo();
        }
        if (selectionEvent.getSource() == this.newDirectory || selectionEvent.getSource() == this.newDirectoryTool) {
            this.newDirectory();
        }
        if (selectionEvent.getSource() == this.newDVD || selectionEvent.getSource() == this.newDVDTool) {
            this.newDVD();
        }
        if (selectionEvent.getSource() == this.manualSplit) {
            this.newManualSplit();
        }
        if (selectionEvent.getSource() == this.joinVideos) {
            this.newJoinVideos();
        }
        if (selectionEvent.getSource() == this.moveUp) {
            object3 = this.tabFolder.getSelection().getImage();
            object2 = this.tabFolder.getSelection().getText();
            object = this.tabFolder.getSelection().getControl();
            n = this.tabFolder.getSelectionIndex();
            this.tabFolder.getSelection().dispose();
            cTabItem = new CTabItem(this.tabFolder, 0, --n);
            cTabItem.setImage((Image)object3);
            cTabItem.setText((String)object2);
            cTabItem.setControl((Control)object);
            ((TabItemControl)object).setTabItem(cTabItem);
            this.tabFolder.setSelection(n);
            this.tabChanged(false);
        }
        if (selectionEvent.getSource() == this.moveDown) {
            object3 = this.tabFolder.getSelection().getImage();
            object2 = this.tabFolder.getSelection().getText();
            object = this.tabFolder.getSelection().getControl();
            n = this.tabFolder.getSelectionIndex();
            this.tabFolder.getSelection().dispose();
            cTabItem = new CTabItem(this.tabFolder, 0, ++n);
            cTabItem.setImage((Image)object3);
            cTabItem.setText((String)object2);
            cTabItem.setControl((Control)object);
            ((TabItemControl)object).setTabItem(cTabItem);
            this.tabFolder.setSelection(n);
            this.tabChanged(false);
        }
        if (selectionEvent.getSource() == this.closeJob) {
            this.tabFolder.getSelection().dispose();
            this.tabChanged(false);
        }
        if (selectionEvent.getSource() == this.closeAllJobs) {
            object3 = this.tabFolder.getItems();
            for (int i = 0; i < ((CTabItem[])object3).length; ++i) {
                object3[i].dispose();
            }
            this.tabChanged(false);
        }
        if (selectionEvent.getSource() == this.quit) {
            this.shell.dispose();
        }
        if (this.profileMenuItems.containsKey(selectionEvent.getSource())) {
            object3 = (MenuItem)selectionEvent.getSource();
            String string = (String)this.profileMenuItems.get(object3);
            if (string.equals(ConverterOptions.getCurrentProfile().getProfileName())) {
                return;
            }
            object = this.profileMenuItems.keySet().iterator();
            while (object.hasNext()) {
                ((MenuItem)object.next()).setSelection(false);
            }
            object3.setSelection(true);
            ConverterOptions.setCurrentProfile(Profile.getProfile(string));
            this.profileChanged();
        }
        if (selectionEvent.getSource() == this.bitrate) {
            object3 = new BitrateDialog(this.shell, 0, new Bitrate(ConverterOptions.getCurrentProfile().getMaxVideoBitrate(), ConverterOptions.getCurrentProfile().getMaxAudioBitrate()), new Bitrate(ConverterOptions.getVideoBitrate(), ConverterOptions.getAudioBitrate()));
            Bitrate bitrate = ((BitrateDialog)((Object)object3)).open();
            ConverterOptions.writeOption("videoBitrate", "" + bitrate.getVideo());
            ConverterOptions.writeOption("audioBitrate", "" + bitrate.getAudio());
        }
        if (this.dimensionsMenuItems.containsKey(selectionEvent.getSource())) {
            // empty if block
        }
        if (selectionEvent.getSource() == this.panAndScan) {
            ConverterOptions.writeOption("panAndScan", "" + this.panAndScan.getSelection());
        }
        if (selectionEvent.getSource() == this.audioSync) {
            int n2 = new AudioSyncDialog(this.shell, 0, ConverterOptions.getAutoSync() ? Integer.MAX_VALUE : ConverterOptions.getAudioDelay()).open();
            if (n2 == Integer.MAX_VALUE) {
                ConverterOptions.writeOption("autoSync", "true");
                ConverterOptions.writeOption("audioDelay", "0");
            } else {
                ConverterOptions.writeOption("autoSync", "false");
                ConverterOptions.writeOption("audioDelay", "" + n2);
            }
        }
        if (selectionEvent.getSource() == this.automaticallySplit) {
            int n3 = new AutomaticallySplitDialog(this.shell, 0, ConverterOptions.getAutoSplit(), ConverterOptions.getSplitTime()).open();
            if (n3 == Integer.MAX_VALUE) {
                ConverterOptions.writeOption("autoSplit", "false");
            } else {
                ConverterOptions.writeOption("autoSplit", "true");
                ConverterOptions.writeOption("splitTime", "" + n3);
            }
        }
        if (selectionEvent.getSource() == this.volume) {
            double d = new VolumeDialog(this.shell, 0, ConverterOptions.getVolumeFilter(), ConverterOptions.getGain()).open();
            if (d == Double.MIN_VALUE) {
                ConverterOptions.writeOption("volumeFilter", "none");
            } else if (d == Double.MAX_VALUE) {
                ConverterOptions.writeOption("volumeFilter", "volnorm");
            } else {
                ConverterOptions.writeOption("volumeFilter", "volume");
                ConverterOptions.writeOption("gain", "" + d);
            }
        }
        if (selectionEvent.getSource() == this.contents) {
            String string = Config.getPackageDataDir().equals(".") ? "file://" + System.getProperty("user.dir") + "/doc/html/index.html" : "file://" + Config.getPackageDataDir() + "/doc/html/index.html";
            new HelpBrowser(string);
        }
        if (selectionEvent.getSource() == this.logViewer) {
            if (LogViewer.getSingleton() == null) {
                new LogViewer();
            } else {
                LogViewer.getSingleton().getShell().setActive();
            }
        }
        if (selectionEvent.getSource() == this.about) {
            new AboutDialog(this.shell, 0).open();
        }
    }

    public void profileChanged() {
        Dimensions[] dimensionsArray = this.dimensionsMenuItems.keySet().iterator();
        while (dimensionsArray.hasNext()) {
            ((MenuItem)dimensionsArray.next()).dispose();
        }
        this.dimensionsMenuItems.clear();
        dimensionsArray = ConverterOptions.getCurrentProfile().getDimensions();
        Dimensions dimensions = ConverterOptions.getDimensions();
        for (int i = 0; i < dimensionsArray.length; ++i) {
            MenuItem menuItem = new MenuItem(this.videoSizeMenu, 16);
            menuItem.setText("&" + (i + 1) + " " + dimensionsArray[i].toString());
            menuItem.setSelection(dimensionsArray[i].toString().equals(dimensions.toString()));
            menuItem.addSelectionListener((SelectionListener)this);
            this.dimensionsMenuItems.put(menuItem, dimensionsArray[i]);
        }
        this.advancedJobs.setEnabled(ConverterOptions.getCurrentProfile().getWrapperFormat().equals("avi"));
        this.automaticallySplit.setEnabled(ConverterOptions.getCurrentProfile().getWrapperFormat().equals("avi"));
    }

    public void close(CTabFolderEvent cTabFolderEvent) {
        this.tabChanged(true);
    }

    public void maximize(CTabFolderEvent cTabFolderEvent) {
    }

    public void minimize(CTabFolderEvent cTabFolderEvent) {
    }

    public void restore(CTabFolderEvent cTabFolderEvent) {
    }

    public void showList(CTabFolderEvent cTabFolderEvent) {
    }

    public void tabChanged(boolean bl) {
        int n = this.tabFolder.getSelectionIndex();
        if (bl) {
            --n;
        }
        if (n == -1) {
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
            this.closeJob.setEnabled(false);
            this.closeAllJobs.setEnabled(false);
        } else {
            this.moveUp.setEnabled(true);
            this.moveDown.setEnabled(true);
            this.closeJob.setEnabled(true);
            this.closeAllJobs.setEnabled(true);
            if (n == 0) {
                this.moveUp.setEnabled(false);
            }
            if (n == this.tabFolder.getItemCount() - (bl ? 2 : 1)) {
                this.moveDown.setEnabled(false);
            }
        }
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        if (dropTargetEvent.getSource() == this.target) {
            if (dropTargetEvent.data == null) {
                dropTargetEvent.detail = 0;
                return;
            }
            String[] stringArray = (String[])dropTargetEvent.data;
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (file.isFile() && new VideoFileFilter().accept(file)) {
                    this.newSingleVideo().setInputVideo(stringArray[i]);
                    continue;
                }
                if (!file.isDirectory()) continue;
                if (new File(stringArray[i] + File.separator + "VIDEO_TS").exists()) {
                    this.newDVD().setDrive(stringArray[i]);
                    continue;
                }
                this.newDirectory().setInputDirectory(stringArray[i]);
            }
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
    }

    private SingleVideo newSingleVideo() {
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        SingleVideo singleVideo = new SingleVideo((Composite)this.tabFolder, 0, cTabItem);
        cTabItem.setControl((Control)singleVideo);
        this.tabFolder.setSelection(cTabItem);
        this.tabChanged(false);
        return singleVideo;
    }

    private Directory newDirectory() {
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        Directory directory = new Directory((Composite)this.tabFolder, 0, cTabItem);
        cTabItem.setControl((Control)directory);
        this.tabFolder.setSelection(cTabItem);
        this.tabChanged(false);
        return directory;
    }

    private DVD newDVD() {
        DVD dVD = null;
        for (int i = this.tabFolder.getItemCount() - 1; i >= 0 && dVD == null; --i) {
            if (!(this.tabFolder.getItem(i).getControl() instanceof DVD)) continue;
            dVD = (DVD)this.tabFolder.getItem(i).getControl();
        }
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        DVD dVD2 = new DVD((Composite)this.tabFolder, 0, cTabItem);
        cTabItem.setControl((Control)dVD2);
        this.tabFolder.setSelection(cTabItem);
        this.tabChanged(false);
        if (dVD != null && !dVD.getDrive().equals("")) {
            dVD2.setDrive(dVD.getDrive());
            dVD2.setTitleInfo(dVD.getTitleInfo());
        } else {
            dVD2.setTitleCombo();
        }
        return dVD2;
    }

    private ManualSplit newManualSplit() {
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        ManualSplit manualSplit = new ManualSplit((Composite)this.tabFolder, 0, cTabItem);
        cTabItem.setControl((Control)manualSplit);
        this.tabFolder.setSelection(cTabItem);
        this.tabChanged(false);
        return manualSplit;
    }

    private JoinVideos newJoinVideos() {
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        JoinVideos joinVideos = new JoinVideos((Composite)this.tabFolder, 0, cTabItem);
        cTabItem.setControl((Control)joinVideos);
        this.tabFolder.setSelection(cTabItem);
        this.tabChanged(false);
        return joinVideos;
    }

    public static void main(String[] stringArray) {
        try {
            new ConverterUI();
        }
        catch (Throwable throwable) {
            String string = "An unhandled exception occured: " + throwable.getClass() + "\n" + throwable.getMessage() + "\n\n";
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string = string + stackTraceElementArray[i] + "\n";
            }
            Logger.logMessage(string, 1);
            MessageBox messageBox = new MessageBox(new Shell(Display.getDefault()), 33);
            messageBox.setText("Error");
            messageBox.setMessage("An unhandled exception occured.  The program will close.  Please see the log for details.");
            messageBox.open();
        }
    }
}

