/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.thestaticvoid.iriverter.Dimensions;
import org.thestaticvoid.iriverter.Logger;
import org.thestaticvoid.iriverter.Profile;

public class ConverterOptions {
    private static File optionsFile = new File(System.getProperty("user.home") + File.separator + ".iriverter.conf");

    public static String getOptionsText() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(optionsFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = "";
        if (bufferedReader != null) {
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string + string2 + "\n";
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string;
    }

    public static void writeOption(String string, String string2) {
        try {
            String string3;
            Logger.logMessage("Setting: " + string + "=" + string2, 0);
            if (!optionsFile.exists()) {
                optionsFile.createNewFile();
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(optionsFile));
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(string + "=") > -1) {
                    stringBuffer.append(string + "=" + string2 + "\n");
                    bl = true;
                    continue;
                }
                stringBuffer.append(string3 + "\n");
            }
            if (!bl) {
                stringBuffer.append(string + "=" + string2 + "\n");
            }
            bufferedReader.close();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(optionsFile)));
            printWriter.print(stringBuffer.toString());
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readOption(String string) {
        String string2 = "";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(optionsFile));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(string + "=") <= -1) continue;
                string2 = string3.substring(string3.indexOf("=") + 1);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public static void setCurrentProfile(Profile profile) {
        ConverterOptions.writeOption("currentProfile", profile.getProfileName());
        ConverterOptions.writeOption("videoBitrate", "");
        ConverterOptions.writeOption("audioBitrate", "");
        ConverterOptions.writeOption("frameRate", "");
        ConverterOptions.writeOption("dimensions", "");
        ConverterOptions.writeOption("autoSplit", "");
        ConverterOptions.writeOption("splitTime", "");
    }

    public static Profile getCurrentProfile() {
        String string = ConverterOptions.readOption("currentProfile");
        if (string.equals("")) {
            return Profile.getProfile("h300");
        }
        return Profile.getProfile(string);
    }

    public static boolean getPanAndScan() {
        String string = ConverterOptions.readOption("panAndScan");
        if (string.equals("")) {
            return false;
        }
        return string.equals("true");
    }

    public static int getVideoBitrate() {
        String string = ConverterOptions.readOption("videoBitrate");
        if (string.equals("")) {
            return ConverterOptions.getCurrentProfile().getMaxVideoBitrate();
        }
        return Integer.parseInt(string);
    }

    public static int getAudioBitrate() {
        String string = ConverterOptions.readOption("audioBitrate");
        if (string.equals("")) {
            return ConverterOptions.getCurrentProfile().getMaxAudioBitrate();
        }
        return Integer.parseInt(string);
    }

    public static Dimensions getDimensions() {
        String string = ConverterOptions.readOption("dimensions");
        if (string.equals("")) {
            return ConverterOptions.getCurrentProfile().getDimensions()[0];
        }
        return new Dimensions(string);
    }

    public static boolean getAutoSync() {
        String string = ConverterOptions.readOption("autoSync");
        if (string.equals("")) {
            return true;
        }
        return string.equals("true");
    }

    public static int getAudioDelay() {
        String string = ConverterOptions.readOption("audioDelay");
        if (string.equals("")) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static boolean getAutoSplit() {
        String string = ConverterOptions.readOption("autoSplit");
        if (string.equals("")) {
            return ConverterOptions.getCurrentProfile().getMaxLength() > 0;
        }
        return string.equals("true");
    }

    public static int getSplitTime() {
        String string = ConverterOptions.readOption("splitTime");
        if (string.equals("")) {
            return ConverterOptions.getCurrentProfile().getMaxLength();
        }
        return Integer.parseInt(string);
    }

    public static int getVolumeFilter() {
        String string = ConverterOptions.readOption("volumeFilter");
        if (string.equals("") || string.equals("none")) {
            return 0;
        }
        if (string.equals("volnorm")) {
            return 1;
        }
        return 2;
    }

    public static double getGain() {
        String string = ConverterOptions.readOption("gain");
        if (string.equals("")) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }
}

