/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import org.thestaticvoid.iriverter.Chapters;
import org.thestaticvoid.iriverter.ConverterOptions;
import org.thestaticvoid.iriverter.DVDAdapter;
import org.thestaticvoid.iriverter.DVDInfo;
import org.thestaticvoid.iriverter.DirectoryAdapter;
import org.thestaticvoid.iriverter.DirectoryInfo;
import org.thestaticvoid.iriverter.JoinVideosInfo;
import org.thestaticvoid.iriverter.ListOfFiles;
import org.thestaticvoid.iriverter.Logger;
import org.thestaticvoid.iriverter.MPlayerInfo;
import org.thestaticvoid.iriverter.ManualSplitAdapter;
import org.thestaticvoid.iriverter.ManualSplitInfo;
import org.thestaticvoid.iriverter.Mark;
import org.thestaticvoid.iriverter.MencoderStreamParser;
import org.thestaticvoid.iriverter.OutputVideoInfo;
import org.thestaticvoid.iriverter.OverwriteDialog;
import org.thestaticvoid.iriverter.ProgressDialogInfo;
import org.thestaticvoid.iriverter.SingleVideoAdapter;
import org.thestaticvoid.iriverter.SingleVideoInfo;
import org.thestaticvoid.iriverter.VideoFileFilter;

public class Converter
extends Thread {
    private List jobs;
    private List notSplitVideos;
    private ProgressDialogInfo progressDialogInfo;
    private Process proc;
    private boolean isCanceled;
    private int exitCode;

    public Converter(List list, ProgressDialogInfo progressDialogInfo) {
        this.jobs = Converter.checkForOverwritingFiles(Converter.expandSingleJobsToMultiple(Converter.removeInvalidJobs(list)));
        this.progressDialogInfo = progressDialogInfo;
        this.isCanceled = false;
        this.notSplitVideos = new ArrayList();
        progressDialogInfo.setTotalJobs(this.jobs.size());
    }

    public static List removeInvalidJobs(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            boolean bl = true;
            if (list.get(i) instanceof OutputVideoInfo) {
                object = (OutputVideoInfo)list.get(i);
                if (object.getOutputVideo().equals("")) continue;
                if (!object.getOutputVideo().endsWith("." + ConverterOptions.getCurrentProfile().getWrapperFormat()) && !object.getOutputVideo().equals("")) {
                    object.setOutputVideo(object.getOutputVideo() + "." + ConverterOptions.getCurrentProfile().getWrapperFormat());
                }
                if (!new File(object.getOutputVideo()).getParentFile().exists()) {
                    bl = new File(object.getOutputVideo()).getParentFile().mkdirs();
                }
                boolean bl2 = bl = bl && new File(object.getOutputVideo()).getParentFile().canWrite();
            }
            if (list.get(i) instanceof SingleVideoInfo) {
                object = (SingleVideoInfo)list.get(i);
                if (!new File(object.getInputVideo()).exists() || !bl) continue;
                arrayList.add(object);
                continue;
            }
            if (list.get(i) instanceof DirectoryInfo) {
                object = (DirectoryInfo)list.get(i);
                if (new File(object.getInputDirectory()).exists() && !object.getOutputDirectory().equals("") && !new File(object.getOutputDirectory()).exists()) {
                    bl = new File(object.getOutputDirectory()).mkdirs();
                }
                if (!bl) continue;
                arrayList.add(object);
                continue;
            }
            if (list.get(i) instanceof DVDInfo) {
                object = (DVDInfo)list.get(i);
                if (object.getDrive().equals("") || !bl) continue;
                arrayList.add(object);
                continue;
            }
            if (list.get(i) instanceof ManualSplitInfo) {
                object = (ManualSplitInfo)list.get(i);
                if (object.getVideo().equals("") || object.getMarks().length <= 2) continue;
                arrayList.add(object);
                continue;
            }
            if (!(list.get(i) instanceof JoinVideosInfo) || (object = (JoinVideosInfo)list.get(i)).getInputVideos().length <= 0 || !bl) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static List expandSingleJobsToMultiple(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof DirectoryInfo) {
                arrayList.addAll(Converter.convertDirectoryToSingleVideos((DirectoryInfo)list.get(i)));
                continue;
            }
            if (list.get(i) instanceof DVDInfo) {
                arrayList.addAll(Converter.separateDVDChaptersToSingleDVDJobs((DVDInfo)list.get(i)));
                continue;
            }
            if (list.get(i) instanceof ManualSplitInfo) {
                arrayList.addAll(Converter.separateMultipleSplitJobsToOneSplitJob((ManualSplitInfo)list.get(i)));
                continue;
            }
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public static List convertDirectoryToSingleVideos(DirectoryInfo directoryInfo) {
        ArrayList<SingleVideoAdapter> arrayList = new ArrayList<SingleVideoAdapter>();
        String[] stringArray = new File(directoryInfo.getInputDirectory()).list(new VideoFileFilter());
        for (int i = 0; i < stringArray.length; ++i) {
            if (new File(directoryInfo.getInputDirectory() + File.separator + stringArray[i]).isDirectory() && directoryInfo.getConvertSubdirectories()) {
                arrayList.addAll(Converter.convertDirectoryToSingleVideos(new DirectoryAdapter(directoryInfo.getInputDirectory() + File.separator + stringArray[i], directoryInfo.getOutputDirectory() + File.separator + stringArray[i], directoryInfo.getConvertSubdirectories())));
                continue;
            }
            if (!new File(directoryInfo.getInputDirectory() + File.separator + stringArray[i]).isFile()) continue;
            arrayList.add(new SingleVideoAdapter(directoryInfo.getInputDirectory() + File.separator + stringArray[i], directoryInfo.getOutputDirectory() + File.separator + stringArray[i].substring(0, stringArray[i].lastIndexOf(46)) + "." + ConverterOptions.getCurrentProfile().getProfileName() + ".avi"));
        }
        return arrayList;
    }

    public static List separateDVDChaptersToSingleDVDJobs(DVDInfo dVDInfo) {
        ArrayList<DVDInfo> arrayList = new ArrayList<DVDInfo>();
        Chapters[] chaptersArray = dVDInfo.getChapters();
        if (chaptersArray == null) {
            arrayList.add(dVDInfo);
        } else {
            for (int i = 0; i < chaptersArray.length; ++i) {
                String string = "";
                string = chaptersArray[i].getFirstChapter() == chaptersArray[i].getLastChapter() ? dVDInfo.getOutputVideo().substring(0, dVDInfo.getOutputVideo().lastIndexOf(46)) + ".ch" + chaptersArray[i].getFirstChapterPadded() + ".avi" : dVDInfo.getOutputVideo().substring(0, dVDInfo.getOutputVideo().lastIndexOf(46)) + ".ch" + chaptersArray[i].getFirstChapterPadded() + "-" + chaptersArray[i].getLastChapterPadded() + ".avi";
                arrayList.add(new DVDAdapter(dVDInfo.getDrive(), dVDInfo.getTitle(), new Chapters[]{chaptersArray[i]}, dVDInfo.getAudioStream(), dVDInfo.getSubtitles(), string));
            }
        }
        return arrayList;
    }

    public static List separateMultipleSplitJobsToOneSplitJob(ManualSplitInfo manualSplitInfo) {
        ArrayList<ManualSplitAdapter> arrayList = new ArrayList<ManualSplitAdapter>();
        int n = 0;
        while (n + 1 < manualSplitInfo.getMarks().length) {
            arrayList.add(new ManualSplitAdapter(manualSplitInfo.getVideo(), new Mark[]{manualSplitInfo.getMarks()[n], manualSplitInfo.getMarks()[n + 1]}, n + 1));
            ++n;
        }
        return arrayList;
    }

    public static List checkForOverwritingFiles(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof OutputVideoInfo)) {
                arrayList.add(list.get(i));
                continue;
            }
            if (new File(((OutputVideoInfo)list.get(i)).getOutputVideo()).exists()) {
                if (!OverwriteDialog.overwriteFile(((OutputVideoInfo)list.get(i)).getOutputVideo())) continue;
                arrayList.add(list.get(i));
                continue;
            }
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public void run() {
        for (int i = 0; i < this.jobs.size() && !this.isCanceled; ++i) {
            this.progressDialogInfo.setCurrentJob(i + 1);
            if (this.jobs.get(i) instanceof SingleVideoInfo) {
                this.convertSingleVideo((SingleVideoInfo)this.jobs.get(i));
            }
            if (this.jobs.get(i) instanceof DVDInfo) {
                this.convertDVD((DVDInfo)this.jobs.get(i));
            }
            if (this.jobs.get(i) instanceof ManualSplitInfo) {
                this.manuallySplitVideo((ManualSplitInfo)this.jobs.get(i));
            }
            if (!(this.jobs.get(i) instanceof JoinVideosInfo)) continue;
            this.joinVideos((JoinVideosInfo)this.jobs.get(i));
        }
        if (!this.isCanceled) {
            this.progressDialogInfo.complete(this.exitCode == 0);
        }
    }

    public void cancel() {
        this.isCanceled = true;
        if (this.proc != null) {
            this.proc.destroy();
        }
    }

    private List prepareBaseCommandList(String string, String string2, MPlayerInfo mPlayerInfo) {
        double d;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(MPlayerInfo.getMPlayerPath() + "mencoder");
        arrayList.add(string);
        arrayList.add("-o");
        arrayList.add(string2);
        if (ConverterOptions.getCurrentProfile().getWrapperFormat().equals("mp4")) {
            arrayList.add("-of");
            arrayList.add("lavf");
            arrayList.add("-lavfopts");
            arrayList.add("format=mp4:i_certify_that_my_video_stream_does_not_use_b_frames");
        }
        arrayList.add("-ovc");
        if (ConverterOptions.getCurrentProfile().getVideoFormat().equals("h264")) {
            arrayList.add("x264");
            arrayList.add("-x264encopts");
            arrayList.add("bitrate=" + ConverterOptions.getVideoBitrate() + ":bframes=0:level_idc=13:nocabac");
        } else {
            arrayList.add("xvid");
            arrayList.add("-xvidencopts");
            arrayList.add("bitrate=" + ConverterOptions.getVideoBitrate() + ":max_bframes=0");
        }
        arrayList.add("-oac");
        if (ConverterOptions.getCurrentProfile().getAudioFormat().equals("aac")) {
            arrayList.add("faac");
            arrayList.add("-faacopts");
            arrayList.add("br=" + ConverterOptions.getAudioBitrate() + ":object=1");
        } else {
            arrayList.add("mp3lame");
            arrayList.add("-lameopts");
            arrayList.add("mode=0:cbr:br=" + ConverterOptions.getAudioBitrate());
        }
        double d2 = d = mPlayerInfo.getFrameRate() > ConverterOptions.getCurrentProfile().getMaxFrameRate() ? ConverterOptions.getCurrentProfile().getMaxFrameRate() : mPlayerInfo.getFrameRate();
        if (mPlayerInfo.getFrameRate() != d && mPlayerInfo.getFrameRate() < 1000.0) {
            arrayList.add("-vf-add");
            arrayList.add("filmdint=io=" + (int)Math.round(mPlayerInfo.getFrameRate() * 1000.0) + ":" + (int)Math.round(d * 1000.0));
        }
        int n = ConverterOptions.getDimensions().getWidth();
        int n2 = mPlayerInfo.getDimensions().getHeight() * ConverterOptions.getDimensions().getWidth() / mPlayerInfo.getDimensions().getWidth();
        if (n2 > ConverterOptions.getDimensions().getHeight()) {
            n = n * ConverterOptions.getDimensions().getHeight() / n2;
            n2 = ConverterOptions.getDimensions().getHeight();
        }
        arrayList.add("-vf-add");
        if (ConverterOptions.getPanAndScan()) {
            arrayList.add("scale=" + (int)((double)mPlayerInfo.getDimensions().getWidth() * ((double)ConverterOptions.getDimensions().getHeight() / (double)mPlayerInfo.getDimensions().getHeight())) + ":" + ConverterOptions.getDimensions().getHeight() + ",crop=" + ConverterOptions.getDimensions().getWidth() + ":" + ConverterOptions.getDimensions().getHeight());
        } else {
            arrayList.add("scale=" + n + ":" + n2 + ",expand=" + ConverterOptions.getDimensions().getWidth() + ":" + ConverterOptions.getDimensions().getHeight());
        }
        arrayList.add("-vf-add");
        arrayList.add("harddup");
        if (ConverterOptions.getVolumeFilter() == 1) {
            arrayList.add("-af");
            arrayList.add("volnorm");
        } else if (ConverterOptions.getVolumeFilter() == 2) {
            arrayList.add("-af");
            arrayList.add("volume=" + ConverterOptions.getGain());
        }
        arrayList.add("-ofps");
        arrayList.add("" + d);
        arrayList.add("-srate");
        arrayList.add("44100");
        if (!ConverterOptions.getAutoSync()) {
            arrayList.add("-delay");
            arrayList.add("" + (double)ConverterOptions.getAudioDelay() / 1000.0);
        }
        return arrayList;
    }

    public void convertSingleVideo(SingleVideoInfo singleVideoInfo) {
        Logger.logMessage("Single Video: " + singleVideoInfo.getInputVideo(), 0);
        this.progressDialogInfo.setInputVideo(new File(singleVideoInfo.getInputVideo()).getName());
        this.progressDialogInfo.setOutputVideo(new File(singleVideoInfo.getOutputVideo()).getName());
        this.progressDialogInfo.setStatus("Gathering information about the input video...");
        MPlayerInfo mPlayerInfo = new MPlayerInfo(singleVideoInfo.getInputVideo());
        if (!mPlayerInfo.videoSupported()) {
            Logger.logMessage("Unsupported video", 1);
            return;
        }
        List list = this.prepareBaseCommandList(singleVideoInfo.getInputVideo(), singleVideoInfo.getOutputVideo(), mPlayerInfo);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)list.get(i);
        }
        if (!this.isCanceled) {
            new File(singleVideoInfo.getOutputVideo()).getParentFile().mkdirs();
            this.progressDialogInfo.setStatus("Converting");
            this.splitVideo(singleVideoInfo.getOutputVideo(), this.runConversionCommand(stringArray));
        }
    }

    public void convertDVD(DVDInfo dVDInfo) {
        String string = "Title " + dVDInfo.getTitle() + " of the DVD at " + dVDInfo.getDrive();
        Chapters[] chaptersArray = dVDInfo.getChapters();
        if (chaptersArray != null) {
            string = chaptersArray[0].getFirstChapter() == chaptersArray[0].getLastChapter() ? "Chapter " + chaptersArray[0].getFirstChapter() + " of " + string : "Chapters " + chaptersArray[0].getFirstChapter() + "-" + chaptersArray[0].getLastChapter() + " of " + string;
        }
        Logger.logMessage("DVD: " + string, 0);
        this.progressDialogInfo.setInputVideo(string);
        this.progressDialogInfo.setOutputVideo(new File(dVDInfo.getOutputVideo()).getName());
        this.progressDialogInfo.setStatus("Gathering information about the input video...");
        MPlayerInfo mPlayerInfo = new MPlayerInfo("dvd://" + dVDInfo.getTitle(), dVDInfo.getDrive());
        List list = this.prepareBaseCommandList("dvd://" + dVDInfo.getTitle(), dVDInfo.getOutputVideo(), mPlayerInfo);
        list.add("-dvd-device");
        list.add(dVDInfo.getDrive());
        if (dVDInfo.getAudioStream() > -1) {
            list.add("-aid");
            list.add("" + dVDInfo.getAudioStream());
        }
        if (dVDInfo.getSubtitles() > -1) {
            list.add("-sid");
            list.add("" + dVDInfo.getSubtitles());
        }
        if (dVDInfo.getChapters() != null) {
            list.add("-chapter");
            list.add(dVDInfo.getChapters()[0].getFirstChapter() + "-" + dVDInfo.getChapters()[0].getLastChapter());
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)list.get(i);
        }
        if (!this.isCanceled) {
            new File(dVDInfo.getOutputVideo()).getParentFile().mkdirs();
            this.progressDialogInfo.setStatus("Converting");
            this.splitVideo(dVDInfo.getOutputVideo(), this.runConversionCommand(stringArray));
        }
    }

    public void manuallySplitVideo(ManualSplitInfo manualSplitInfo) {
        Logger.logMessage("Manual Split: " + manualSplitInfo.getVideo(), 0);
        String string = manualSplitInfo.getVideo().substring(0, manualSplitInfo.getVideo().lastIndexOf(46)) + ".part" + manualSplitInfo.getPart() + ".avi";
        this.progressDialogInfo.setInputVideo(manualSplitInfo.getVideo());
        this.progressDialogInfo.setOutputVideo(string);
        this.progressDialogInfo.setStatus("Splitting");
        if (manualSplitInfo.getMarks()[0].getTime() == 0) {
            this.runConversionCommand(new String[]{MPlayerInfo.getMPlayerPath() + "mencoder", manualSplitInfo.getVideo(), "-o", string, "-ovc", "copy", "-oac", "copy", "-endpos", "" + manualSplitInfo.getMarks()[1].getTime()});
        } else if (manualSplitInfo.getMarks()[1].getTime() == Integer.MAX_VALUE) {
            this.runConversionCommand(new String[]{MPlayerInfo.getMPlayerPath() + "mencoder", manualSplitInfo.getVideo(), "-o", string, "-ovc", "copy", "-oac", "copy", "-ss", "" + manualSplitInfo.getMarks()[0].getTime()});
        } else {
            this.runConversionCommand(new String[]{MPlayerInfo.getMPlayerPath() + "mencoder", manualSplitInfo.getVideo(), "-o", string, "-ovc", "copy", "-oac", "copy", "-ss", "" + manualSplitInfo.getMarks()[0].getTime(), "-endpos", "" + (manualSplitInfo.getMarks()[1].getTime() - manualSplitInfo.getMarks()[0].getTime())});
        }
    }

    public void joinVideos(JoinVideosInfo joinVideosInfo) {
        try {
            int n;
            String[] stringArray = joinVideosInfo.getInputVideos();
            File file = File.createTempFile("iriverter-", ".avi");
            file.deleteOnExit();
            Logger.logMessage("Join Videos: " + file, 0);
            this.progressDialogInfo.setOutputVideo(file.getName());
            this.progressDialogInfo.setStatus("Concatenating videos to a temporary file...");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(new ListOfFiles(stringArray, this.progressDialogInfo));
            byte[] byArray = new byte[4096];
            while ((n = sequenceInputStream.read(byArray)) != -1 && !this.isCanceled) {
                fileOutputStream.write(byArray, 0, n);
            }
            this.progressDialogInfo.setPercentComplete(100);
            if (!this.isCanceled) {
                Logger.logMessage("Writing header...", 0);
                this.progressDialogInfo.setInputVideo(file.getName());
                this.progressDialogInfo.setOutputVideo(new File(joinVideosInfo.getOutputVideo()).getName());
                this.progressDialogInfo.setStatus("Writing header");
                this.splitVideo(joinVideosInfo.getOutputVideo(), this.runConversionCommand(new String[]{MPlayerInfo.getMPlayerPath() + "mencoder", "-forceidx", file.toString(), "-o", joinVideosInfo.getOutputVideo(), "-ovc", "copy", "-oac", "copy"}));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int runConversionCommand(String[] stringArray) {
        MencoderStreamParser mencoderStreamParser = null;
        MencoderStreamParser mencoderStreamParser2 = null;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + " ";
        }
        Logger.logMessage(string, 0);
        try {
            this.proc = Runtime.getRuntime().exec(stringArray);
            mencoderStreamParser = new MencoderStreamParser(this.progressDialogInfo);
            mencoderStreamParser.parse(new BufferedReader(new InputStreamReader(this.proc.getInputStream())));
            mencoderStreamParser2 = new MencoderStreamParser(this.progressDialogInfo);
            mencoderStreamParser2.parse(new BufferedReader(new InputStreamReader(this.proc.getErrorStream())));
            this.exitCode = this.proc.waitFor();
            this.proc = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.exitCode != 0) {
            this.isCanceled = true;
        }
        return this.isCanceled ? 0 : (mencoderStreamParser2.getLength() > -1 ? mencoderStreamParser2.getLength() : mencoderStreamParser.getLength());
    }

    public void splitVideo(String string, int n) {
        if (n < ConverterOptions.getSplitTime() * 60) {
            return;
        }
        if (!ConverterOptions.getAutoSplit()) {
            this.notSplitVideos.add(string);
            return;
        }
        int n2 = n / (ConverterOptions.getSplitTime() * 60) + 1;
        for (int i = 0; i < n2; ++i) {
            String string2 = string.substring(0, string.lastIndexOf(46)) + ".part" + (i + 1) + ".avi";
            this.progressDialogInfo.setInputVideo(new File(string).getName());
            this.progressDialogInfo.setOutputVideo(new File(string2).getName());
            this.progressDialogInfo.setStatus("Splitting");
            if (i + 1 == 1) {
                this.runConversionCommand(new String[]{MPlayerInfo.getMPlayerPath() + "mencoder", string, "-o", string2, "-ovc", "copy", "-oac", "copy", "-endpos", "" + n / n2});
                continue;
            }
            if (i + 1 == n2) {
                this.runConversionCommand(new String[]{MPlayerInfo.getMPlayerPath() + "mencoder", string, "-o", string2, "-ovc", "copy", "-oac", "copy", "-ss", "" + n / n2 * i});
                continue;
            }
            this.runConversionCommand(new String[]{MPlayerInfo.getMPlayerPath() + "mencoder", string, "-o", string2, "-ovc", "copy", "-oac", "copy", "-ss", "" + n / n2 * i, "-endpos", "" + n / n2});
        }
    }

    public List getNotSplitVideos() {
        return this.notSplitVideos;
    }
}

