/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.thestaticvoid.iriverter.Chapters;

public class ChapterDialog
extends Dialog
implements SelectionListener {
    private int totalChapters;
    private Chapters[] chapters;
    private Shell shell;
    private Table chaptersTable;
    private Button all;
    private Button none;
    private Button oneFile;
    private Button dismiss;
    private boolean[] chaptersTableAfterDispose;
    private boolean oneFileAfterDispose;

    public ChapterDialog(Shell shell, int n, int n2, boolean bl) {
        super(shell, n);
        this.totalChapters = n2;
        this.chapters = new Chapters[]{new Chapters(1, n2)};
    }

    public ChapterDialog(Shell shell, int n, int n2, Chapters[] chaptersArray) {
        super(shell, n);
        this.totalChapters = n2;
        this.chapters = chaptersArray;
    }

    public Chapters[] open() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Chapters");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Chapters");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)this.getParent().getDisplay(), fontDataArray));
        Composite composite = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.pack = false;
        rowLayout.spacing = 6;
        composite.setLayout((Layout)rowLayout);
        composite.setLayoutData((Object)new GridData(128));
        this.all = new Button(composite, 8);
        this.all.setText("All");
        this.all.addSelectionListener((SelectionListener)this);
        this.none = new Button(composite, 8);
        this.none.setText("None");
        this.none.addSelectionListener((SelectionListener)this);
        this.chaptersTable = new Table((Composite)this.shell, 2596);
        for (int i = 1; i <= this.totalChapters; ++i) {
            TableItem tableItem = new TableItem(this.chaptersTable, 0);
            tableItem.setText("Chapter " + i);
        }
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.chaptersTable.setLayoutData((Object)gridData);
        this.chaptersTable.addSelectionListener((SelectionListener)this);
        this.oneFile = new Button((Composite)this.shell, 32);
        this.oneFile.setText("One file per continuous selection");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.oneFile.setLayoutData((Object)gridData);
        this.dismiss = new Button((Composite)this.shell, 8);
        this.dismiss.setText("Close");
        gridData = new GridData();
        gridData.widthHint = 75;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 131072;
        this.dismiss.setLayoutData((Object)gridData);
        this.dismiss.addSelectionListener((SelectionListener)this);
        this.setSelection();
        this.shell.setSize(300, 300);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        if (this.chaptersTableAfterDispose != null) {
            return this.getChapters();
        }
        return this.chapters;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        if (selectionEvent.getSource() == this.all) {
            for (n = 0; n < this.chaptersTable.getItemCount(); ++n) {
                this.chaptersTable.getItem(n).setChecked(true);
            }
        }
        if (selectionEvent.getSource() == this.none) {
            for (n = 0; n < this.chaptersTable.getItemCount(); ++n) {
                this.chaptersTable.getItem(n).setChecked(false);
            }
        }
        if (selectionEvent.getSource() == this.dismiss) {
            int n2;
            n = 1;
            for (n2 = 0; n2 < this.chaptersTable.getItemCount() && n != 0; ++n2) {
                n = !this.chaptersTable.getItem(n2).getChecked() ? 1 : 0;
            }
            if (n != 0) {
                MessageBox messageBox = new MessageBox(this.shell, 33);
                messageBox.setText("Empty Selection");
                messageBox.setMessage("You must select at least one chapter.");
                messageBox.open();
                return;
            }
            this.chaptersTableAfterDispose = new boolean[this.chaptersTable.getItemCount()];
            for (n2 = 0; n2 < this.chaptersTableAfterDispose.length; ++n2) {
                this.chaptersTableAfterDispose[n2] = this.chaptersTable.getItem(n2).getChecked();
            }
            this.oneFileAfterDispose = this.oneFile.getSelection();
            this.shell.dispose();
        }
    }

    private void setSelection() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.chapters.length; ++n2) {
            for (n = this.chapters[n2].getFirstChapter() - 1; n < this.chapters[n2].getLastChapter(); ++n) {
                this.chaptersTable.getItem(n).setChecked(true);
            }
        }
        n2 = 0;
        for (n = 0; n < this.chapters.length && n2 == 0; ++n) {
            n2 = this.chapters[n].getFirstChapter() != this.chapters[n].getLastChapter() ? 1 : 0;
        }
        this.oneFile.setSelection(n2 != 0);
    }

    private Chapters[] getChapters() {
        int n;
        int n2;
        ArrayList<Chapters> arrayList = new ArrayList<Chapters>();
        if (this.oneFileAfterDispose) {
            for (n2 = 0; n2 < this.chaptersTableAfterDispose.length; ++n2) {
                n = 0;
                int n3 = n2;
                while (n3 < this.chaptersTableAfterDispose.length && this.chaptersTableAfterDispose[n3]) {
                    ++n3;
                    ++n;
                }
                if (n > 0) {
                    arrayList.add(new Chapters(n2 + 1, n2 + n));
                }
                n2 += n;
            }
        } else {
            for (n2 = 0; n2 < this.chaptersTableAfterDispose.length; ++n2) {
                if (!this.chaptersTableAfterDispose[n2]) continue;
                arrayList.add(new Chapters(n2 + 1, n2 + 1));
            }
        }
        Chapters[] chaptersArray = new Chapters[arrayList.size()];
        for (n = 0; n < chaptersArray.length; ++n) {
            chaptersArray[n] = (Chapters)arrayList.get(n);
        }
        if (chaptersArray.length == 1 && chaptersArray[0].getFirstChapter() == 1 && chaptersArray[0].getLastChapter() == this.totalChapters) {
            chaptersArray = null;
        }
        return chaptersArray;
    }
}

