/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.thestaticvoid.iriverter.Bitrate;

public class BitrateDialog
extends Dialog
implements SelectionListener {
    private Shell shell;
    private Bitrate maxBitrate;
    private Bitrate currentBitrate;
    private int currentVideoBitrate;
    private int currentAudioBitrate;
    private Scale videoBitrateScale;
    private Scale audioBitrateScale;
    private Label currentVideoBitrateLabel;
    private Label currentAudioBitrateLabel;
    private Button dismiss;

    public BitrateDialog(Shell shell, int n, Bitrate bitrate, Bitrate bitrate2) {
        super(shell, n);
        this.maxBitrate = bitrate;
        this.currentBitrate = bitrate2;
        this.currentVideoBitrate = bitrate2.getVideo();
        this.currentAudioBitrate = bitrate2.getAudio();
    }

    public Bitrate open() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Bitrate");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 3;
        this.shell.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Bitrate");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)this.getParent().getDisplay(), fontDataArray));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)this.shell, 0);
        label2.setText("Video:");
        this.videoBitrateScale = new Scale((Composite)this.shell, 256);
        this.videoBitrateScale.setMinimum(50);
        this.videoBitrateScale.setMaximum(this.maxBitrate.getVideo() / 2);
        this.videoBitrateScale.setSelection(this.currentVideoBitrate / 2);
        this.videoBitrateScale.setPageIncrement(25);
        this.videoBitrateScale.setLayoutData((Object)new GridData(768));
        this.videoBitrateScale.addSelectionListener((SelectionListener)this);
        this.currentVideoBitrateLabel = new Label((Composite)this.shell, 0);
        this.currentVideoBitrateLabel.setText(this.currentVideoBitrate + " Kbps");
        Label label3 = new Label((Composite)this.shell, 0);
        label3.setText("Audio:");
        this.audioBitrateScale = new Scale((Composite)this.shell, 256);
        this.audioBitrateScale.setMinimum(2);
        this.audioBitrateScale.setMaximum(this.maxBitrate.getAudio() / 16);
        this.audioBitrateScale.setSelection(this.currentAudioBitrate / 16);
        this.audioBitrateScale.setPageIncrement(1);
        this.audioBitrateScale.setLayoutData((Object)new GridData(768));
        this.audioBitrateScale.addSelectionListener((SelectionListener)this);
        this.currentAudioBitrateLabel = new Label((Composite)this.shell, 0);
        this.currentAudioBitrateLabel.setText(this.currentAudioBitrate + " Kbps");
        this.dismiss = new Button((Composite)this.shell, 8);
        this.dismiss.setText("Close");
        gridData = new GridData();
        gridData.widthHint = 75;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 131072;
        this.dismiss.setLayoutData((Object)gridData);
        this.dismiss.addSelectionListener((SelectionListener)this);
        this.shell.pack();
        this.shell.setSize(400, this.shell.getSize().y);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        return new Bitrate(this.currentVideoBitrate, this.currentAudioBitrate);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.videoBitrateScale) {
            this.currentVideoBitrate = this.videoBitrateScale.getSelection() * 2;
            this.currentVideoBitrateLabel.setText(this.currentVideoBitrate + " Kbps");
            this.currentVideoBitrateLabel.pack();
        }
        if (selectionEvent.getSource() == this.audioBitrateScale) {
            this.currentAudioBitrate = this.audioBitrateScale.getSelection() * 16;
            this.currentAudioBitrateLabel.setText(this.currentAudioBitrate + " Kbps");
            this.currentAudioBitrateLabel.pack();
        }
        if (selectionEvent.getSource() == this.dismiss) {
            this.shell.dispose();
        }
    }
}

