/*
 * Decompiled with CFR 0.152.
 */
package org.thestaticvoid.iriverter;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class AudioSyncDialog
extends Dialog
implements SelectionListener {
    private Shell shell;
    private int delay;
    private Label bringAudioLabel;
    private Label millisecondsLabel;
    private Label videoLabel;
    private Spinner delayInput;
    private Button autoSync;
    private Button before;
    private Button after;
    private Button dismiss;
    public static final int AUTO_SYNC = Integer.MAX_VALUE;

    public AudioSyncDialog(Shell shell, int n, int n2) {
        super(shell, n);
        this.delay = n2;
    }

    public int open() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Audio Sync");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 5;
        this.shell.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Audio Sync");
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)this.getParent().getDisplay(), fontDataArray));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 5;
        label.setLayoutData((Object)gridData);
        this.autoSync = new Button((Composite)this.shell, 32);
        this.autoSync.setText("Automatically Sync");
        this.autoSync.setSelection(this.delay == Integer.MAX_VALUE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        this.autoSync.setLayoutData((Object)gridData);
        this.autoSync.addSelectionListener((SelectionListener)this);
        this.bringAudioLabel = new Label((Composite)this.shell, 0);
        this.bringAudioLabel.setText("Bring audio");
        this.delayInput = new Spinner((Composite)this.shell, 2048);
        this.delayInput.setSelection(Math.abs(this.delay));
        this.delayInput.setMinimum(0);
        this.delayInput.setMaximum(1000);
        this.millisecondsLabel = new Label((Composite)this.shell, 0);
        this.millisecondsLabel.setText("milliseconds");
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout());
        this.before = new Button(composite, 16);
        this.before.setText("before");
        this.before.setSelection(this.delay <= 0);
        this.after = new Button(composite, 16);
        this.after.setText("after");
        this.after.setSelection(this.delay > 0);
        this.videoLabel = new Label((Composite)this.shell, 0);
        this.videoLabel.setText("video");
        this.dismiss = new Button((Composite)this.shell, 8);
        this.dismiss.setText("Close");
        gridData = new GridData();
        gridData.widthHint = 75;
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 131072;
        this.dismiss.setLayoutData((Object)gridData);
        this.dismiss.addSelectionListener((SelectionListener)this);
        if (this.autoSync.getSelection()) {
            this.toggleSelection();
            this.delayInput.setSelection(0);
            this.before.setSelection(true);
            this.after.setSelection(false);
        }
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        return this.delay;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.dismiss) {
            try {
                if (this.autoSync.getSelection()) {
                    this.delay = Integer.MAX_VALUE;
                    this.shell.dispose();
                }
                this.delay = this.delayInput.getSelection();
                if (this.before.getSelection()) {
                    this.delay = -this.delay;
                }
            }
            catch (Exception exception) {
                return;
            }
            this.shell.dispose();
        }
        if (selectionEvent.getSource() == this.autoSync) {
            this.toggleSelection();
        }
    }

    public void toggleSelection() {
        this.bringAudioLabel.setEnabled(!this.bringAudioLabel.getEnabled());
        this.delayInput.setEnabled(!this.delayInput.getEnabled());
        this.millisecondsLabel.setEnabled(!this.millisecondsLabel.getEnabled());
        this.before.setEnabled(!this.before.getEnabled());
        this.after.setEnabled(!this.after.getEnabled());
        this.videoLabel.setEnabled(!this.videoLabel.getEnabled());
    }
}

