/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JarPackageWriter
implements IJarDescriptionWriter {
    private final OutputStream fOutputStream;
    private final String fEncoding;

    public JarPackageWriter(OutputStream outputStream, String encoding) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
        this.fEncoding = encoding;
    }

    public void write(JarPackageData jarPackage) throws CoreException {
        try {
            this.writeXML(jarPackage);
        }
        catch (IOException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, (Throwable)ex));
        }
    }

    public void writeXML(JarPackageData jarPackage) throws IOException {
        Assert.isNotNull((Object)jarPackage);
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(JarPackagerMessages.JarWriter_error_couldNotGetXmlBuilder);
        }
        Document document = docBuilder.newDocument();
        Element xmlJarDesc = document.createElement("jardesc");
        document.appendChild(xmlJarDesc);
        this.xmlWriteJarLocation(jarPackage, document, xmlJarDesc);
        this.xmlWriteOptions(jarPackage, document, xmlJarDesc);
        this.xmlWriteRefactoring(jarPackage, document, xmlJarDesc);
        this.xmlWriteSelectedProjects(jarPackage, document, xmlJarDesc);
        if (jarPackage.areGeneratedFilesExported()) {
            this.xmlWriteManifest(jarPackage, document, xmlJarDesc);
        }
        this.xmlWriteSelectedElements(jarPackage, document, xmlJarDesc);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.fEncoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.fOutputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            throw new IOException(JarPackagerMessages.JarWriter_error_couldNotTransformToXML);
        }
    }

    private void xmlWriteJarLocation(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element jar = document.createElement("jar");
        xmlJarDesc.appendChild(jar);
        jar.setAttribute("path", jarPackage.getJarLocation().toPortableString());
    }

    private void xmlWriteOptions(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element options = document.createElement("options");
        xmlJarDesc.appendChild(options);
        options.setAttribute("overwrite", "" + jarPackage.allowOverwrite());
        options.setAttribute("compress", "" + jarPackage.isCompressed());
        options.setAttribute("exportErrors", "" + jarPackage.areErrorsExported());
        options.setAttribute("exportWarnings", "" + jarPackage.exportWarnings());
        options.setAttribute("saveDescription", "" + jarPackage.isDescriptionSaved());
        options.setAttribute("descriptionLocation", jarPackage.getDescriptionLocation().toPortableString());
        options.setAttribute("useSourceFolders", "" + jarPackage.useSourceFolderHierarchy());
        options.setAttribute("buildIfNeeded", "" + jarPackage.isBuildingIfNeeded());
        options.setAttribute("includeDirectoryEntries", "" + jarPackage.areDirectoryEntriesIncluded());
        options.setAttribute("storeRefactorings", "" + jarPackage.isRefactoringAware());
    }

    private void xmlWriteRefactoring(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        RefactoringDescriptorProxy[] proxies;
        Element refactoring = document.createElement("storedRefactorings");
        xmlJarDesc.appendChild(refactoring);
        refactoring.setAttribute("structuralOnly", "" + jarPackage.isExportStructuralOnly());
        refactoring.setAttribute("deprecationInfo", "" + jarPackage.isDeprecationAware());
        IProject[] projects = jarPackage.getRefactoringProjects();
        if (projects != null && projects.length > 0) {
            int index = 0;
            while (index < projects.length) {
                refactoring.setAttribute("project" + (index + 1), projects[index].getName());
                ++index;
            }
        }
        if ((proxies = jarPackage.getRefactoringDescriptors()) != null && proxies.length > 0) {
            int count = 1;
            IRefactoringHistoryService service = RefactoringCore.getHistoryService();
            try {
                service.connect();
                int index = 0;
                while (index < proxies.length) {
                    try {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        service.writeRefactoringDescriptors(new RefactoringDescriptorProxy[]{proxies[index]}, (OutputStream)stream, 0, true, null);
                        refactoring.setAttribute("refactoring" + count, stream.toString("UTF-8"));
                    }
                    catch (CoreException exception) {
                        JavaPlugin.log(exception);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Assert.isTrue((boolean)false);
                    }
                    ++index;
                    ++count;
                }
            }
            finally {
                service.disconnect();
            }
        }
    }

    private void xmlWriteManifest(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element manifest = document.createElement("manifest");
        xmlJarDesc.appendChild(manifest);
        manifest.setAttribute("manifestVersion", jarPackage.getManifestVersion());
        manifest.setAttribute("usesManifest", "" + jarPackage.usesManifest());
        manifest.setAttribute("reuseManifest", "" + jarPackage.isManifestReused());
        manifest.setAttribute("saveManifest", "" + jarPackage.isManifestSaved());
        manifest.setAttribute("generateManifest", "" + jarPackage.isManifestGenerated());
        manifest.setAttribute("manifestLocation", jarPackage.getManifestLocation().toPortableString());
        if (jarPackage.getManifestMainClass() != null) {
            manifest.setAttribute("mainClassHandleIdentifier", jarPackage.getManifestMainClass().getHandleIdentifier());
        }
        this.xmlWriteSealingInfo(jarPackage, document, manifest);
    }

    private void xmlWriteSealingInfo(JarPackageData jarPackage, Document document, Element manifest) throws DOMException {
        Element sealing = document.createElement("sealing");
        manifest.appendChild(sealing);
        sealing.setAttribute("sealJar", "" + jarPackage.isJarSealed());
        Element packagesToSeal = document.createElement("packagesToSeal");
        sealing.appendChild(packagesToSeal);
        this.add(jarPackage.getPackagesToSeal(), packagesToSeal, document);
        Element packagesToUnSeal = document.createElement("packagesToUnSeal");
        sealing.appendChild(packagesToUnSeal);
        this.add(jarPackage.getPackagesToUnseal(), packagesToUnSeal, document);
    }

    private void xmlWriteSelectedElements(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element selectedElements = document.createElement("selectedElements");
        xmlJarDesc.appendChild(selectedElements);
        selectedElements.setAttribute("exportClassFiles", "" + jarPackage.areClassFilesExported());
        selectedElements.setAttribute("exportOutputFolder", "" + jarPackage.areOutputFoldersExported());
        selectedElements.setAttribute("exportJavaFiles", "" + jarPackage.areJavaFilesExported());
        Object[] elements = jarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IResource) {
                this.add((IResource)element, selectedElements, document);
            } else if (element instanceof IJavaElement) {
                this.add((IJavaElement)element, selectedElements, document);
            }
            ++i;
        }
    }

    private void xmlWriteSelectedProjects(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element selectedElements = document.createElement("selectedProjects");
        xmlJarDesc.appendChild(selectedElements);
        IProject[] elements = jarPackage.getRefactoringProjects();
        int index = 0;
        while (index < elements.length) {
            IProject element = elements[index];
            if (element instanceof IResource) {
                this.add((IResource)element, selectedElements, document);
            }
            ++index;
        }
    }

    public void close() throws CoreException {
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (IOException ex) {
                String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, (Throwable)ex));
            }
        }
    }

    private void add(IResource resource, Element parent, Document document) {
        if (resource.getType() == 4) {
            Element element = document.createElement("project");
            parent.appendChild(element);
            element.setAttribute("name", resource.getName());
        } else if (resource.getType() == 1) {
            Element element = document.createElement("file");
            parent.appendChild(element);
            element.setAttribute("path", resource.getFullPath().toString());
        } else if (resource.getType() == 2) {
            Element element = document.createElement("folder");
            parent.appendChild(element);
            element.setAttribute("path", resource.getFullPath().toString());
        }
    }

    private void add(IJavaElement javaElement, Element parent, Document document) {
        Element element = document.createElement("javaElement");
        parent.appendChild(element);
        element.setAttribute("handleIdentifier", javaElement.getHandleIdentifier());
    }

    private void add(IPackageFragment[] packages, Element parent, Document document) {
        int i = 0;
        while (i < packages.length) {
            Element pkg = document.createElement("package");
            parent.appendChild(pkg);
            pkg.setAttribute("handleIdentifier", packages[i].getHandleIdentifier());
            ++i;
        }
    }

    public IStatus getStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }
}

