/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.ImportsFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ImportsCleanUp
extends AbstractCleanUp {
    private CodeGenerationSettings fCodeGeneratorSettings;
    private RefactoringStatus fStatus;

    public ImportsCleanUp(Map options) {
        super(options);
    }

    public ImportsCleanUp() {
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        return this.isEnabled("cleanup.organize_imports");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return ImportsFix.createCleanUp(compilationUnit, this.fCodeGeneratorSettings, this.isEnabled("cleanup.organize_imports"), this.fStatus);
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = super.checkPreConditions(project, compilationUnits, monitor);
        if (this.isEnabled("cleanup.organize_imports")) {
            this.fCodeGeneratorSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
            this.fStatus = new RefactoringStatus();
        }
        return result;
    }

    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        this.fCodeGeneratorSettings = null;
        if (this.fStatus == null || this.fStatus.isOK()) {
            return super.checkPostConditions(monitor);
        }
        return this.fStatus;
    }

    public String[] getDescriptions() {
        if (this.isEnabled("cleanup.organize_imports")) {
            return new String[]{MultiFixMessages.ImportsCleanUp_OrganizeImports_Description};
        }
        return null;
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.organize_imports")) {
            buf.append("import org.model.Engine;\n");
        } else {
            buf.append("import org.model.*;\n");
        }
        return buf.toString();
    }

    public Map getRequiredOptions() {
        return null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public boolean needsFreshAST(CompilationUnit compilationUnit) {
        if (this.isEnabled("cleanup.organize_imports")) {
            return true;
        }
        return super.needsFreshAST(compilationUnit);
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }
}

