/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.plugin.PluginAttribute;

public abstract class PluginDocumentNode
implements IDocumentNode {
    private transient IDocumentNode fParent;
    private transient boolean fIsErrorNode;
    private transient int fLength = -1;
    private transient int fOffset = -1;
    private transient IDocumentNode fPreviousSibling;
    private transient int fIndent = 0;
    private ArrayList fChildren = new ArrayList();
    protected Map fAttributes = new TreeMap();
    private String fTag;
    protected IDocumentTextNode fTextNode;

    public IDocumentNode[] getChildNodes() {
        return this.fChildren.toArray(new IDocumentNode[this.fChildren.size()]);
    }

    public int indexOf(IDocumentNode child) {
        return this.fChildren.indexOf(child);
    }

    public IDocumentNode getChildAt(int index) {
        if (index < this.fChildren.size()) {
            return (IDocumentNode)this.fChildren.get(index);
        }
        return null;
    }

    public IDocumentNode getParentNode() {
        return this.fParent;
    }

    public void setParentNode(IDocumentNode node) {
        this.fParent = node;
    }

    public void addChildNode(IDocumentNode child) {
        this.addChildNode(child, this.fChildren.size());
    }

    public void addChildNode(IDocumentNode child, int position) {
        this.fChildren.add(position, child);
        if (position > 0 && this.fChildren.size() > 1) {
            child.setPreviousSibling((IDocumentNode)this.fChildren.get(position - 1));
        }
        if (this.fChildren.size() > 1 && position < this.fChildren.size() - 1) {
            ((IDocumentNode)this.fChildren.get(position + 1)).setPreviousSibling(child);
        }
        child.setParentNode(this);
    }

    public IDocumentNode removeChildNode(IDocumentNode child) {
        int index = this.fChildren.indexOf(child);
        if (index != -1) {
            this.fChildren.remove(child);
            if (index < this.fChildren.size()) {
                IDocumentNode prevSibling = index == 0 ? null : (IDocumentNode)this.fChildren.get(index - 1);
                ((IDocumentNode)this.fChildren.get(index)).setPreviousSibling(prevSibling);
                return child;
            }
        }
        return null;
    }

    public boolean isErrorNode() {
        return this.fIsErrorNode;
    }

    public void setIsErrorNode(boolean isErrorNode) {
        this.fIsErrorNode = isErrorNode;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setXMLAttribute(IDocumentAttribute attribute) {
        this.fAttributes.put(attribute.getAttributeName(), attribute);
    }

    public String getXMLAttributeValue(String name) {
        PluginAttribute attr = (PluginAttribute)this.fAttributes.get(name);
        return attr == null ? null : attr.getValue();
    }

    public void setXMLTagName(String tag) {
        this.fTag = tag;
    }

    public String getXMLTagName() {
        return this.fTag;
    }

    public IDocumentAttribute getDocumentAttribute(String name) {
        return (IDocumentAttribute)this.fAttributes.get(name);
    }

    public int getLineIndent() {
        return this.fIndent;
    }

    public void setLineIndent(int indent) {
        this.fIndent = indent;
    }

    public IDocumentAttribute[] getNodeAttributes() {
        ArrayList list = new ArrayList();
        Iterator iter = this.fAttributes.values().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list.toArray(new IDocumentAttribute[list.size()]);
    }

    public IDocumentNode getPreviousSibling() {
        return this.fPreviousSibling;
    }

    public void setPreviousSibling(IDocumentNode sibling) {
        this.fPreviousSibling = sibling;
    }

    protected String getIndent() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.fIndent) {
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    public void swap(IDocumentNode child1, IDocumentNode child2) {
        int index1 = this.fChildren.indexOf(child1);
        int index2 = this.fChildren.indexOf(child2);
        this.fChildren.set(index1, child2);
        this.fChildren.set(index2, child1);
        child1.setPreviousSibling(index2 == 0 ? null : (IDocumentNode)this.fChildren.get(index2 - 1));
        child2.setPreviousSibling(index1 == 0 ? null : (IDocumentNode)this.fChildren.get(index1 - 1));
        if (index1 < this.fChildren.size() - 1) {
            ((IDocumentNode)this.fChildren.get(index1 + 1)).setPreviousSibling(child2);
        }
        if (index2 < this.fChildren.size() - 1) {
            ((IDocumentNode)this.fChildren.get(index2 + 1)).setPreviousSibling(child1);
        }
    }

    public void addTextNode(IDocumentTextNode textNode) {
        this.fTextNode = textNode;
    }

    public IDocumentTextNode getTextNode() {
        return this.fTextNode;
    }

    public void removeTextNode() {
        this.fTextNode = null;
    }

    public void removeDocumentAttribute(IDocumentAttribute attr) {
        this.fAttributes.remove(attr.getAttributeName());
    }

    public void reconnect(ISharedPluginModel model, ISchema schema, IDocumentNode parent) {
        this.reconnectDocument();
        this.reconnectParent(parent);
        this.reconnectPreviousSibling(parent);
        this.reconnectText();
        this.reconnectAttributes(model, schema);
        this.reconnectChildren(model, schema);
    }

    private void reconnectAttributes(ISharedPluginModel model, ISchema schema) {
        Iterator keys = this.fAttributes.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            IDocumentAttribute attribute = (IDocumentAttribute)this.fAttributes.get(key);
            attribute.reconnect(model, schema, this);
        }
    }

    private void reconnectChildren(ISharedPluginModel model, ISchema schema) {
        int i = 0;
        while (i < this.fChildren.size()) {
            IDocumentNode child = (IDocumentNode)this.fChildren.get(i);
            child.reconnect(model, schema, this);
            ++i;
        }
    }

    private void reconnectDocument() {
        this.fIndent = 0;
        this.fIsErrorNode = false;
        this.fLength = -1;
        this.fOffset = -1;
    }

    private void reconnectParent(IDocumentNode parent) {
        this.fParent = parent;
    }

    private void reconnectPreviousSibling(IDocumentNode parent) {
        int childCount = parent.getChildCount();
        this.fPreviousSibling = childCount < 1 ? null : parent.getChildAt(childCount - 1);
    }

    private void reconnectText() {
        if (this.fTextNode != null) {
            this.fTextNode.reconnect(this);
        }
    }

    public int getChildCount() {
        return this.fChildren.size();
    }
}

