/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSRunContainerObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleCSSubItem
extends SimpleCSObject
implements ISimpleCSSubItem {
    private String fLabel;
    private boolean fSkip;
    private String fWhen;
    private ISimpleCSRunContainerObject fExecutable;
    private static final long serialVersionUID = 1L;
    private static final HashMap LABEL_SUBSTITUTE_CHARS = new HashMap(7);

    static {
        LABEL_SUBSTITUTE_CHARS.putAll(SUBSTITUTE_CHARS);
        LABEL_SUBSTITUTE_CHARS.put(new Character('\n'), " ");
        LABEL_SUBSTITUTE_CHARS.put(new Character('\r'), "");
    }

    public SimpleCSSubItem(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public ISimpleCSRunContainerObject getExecutable() {
        return this.fExecutable;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public boolean getSkip() {
        return this.fSkip;
    }

    public String getWhen() {
        return this.fWhen;
    }

    public void setExecutable(ISimpleCSRunContainerObject executable) {
        ISimpleCSRunContainerObject old = this.fExecutable;
        this.fExecutable = executable;
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)executable, old);
        }
    }

    public void setLabel(String label) {
        String old = this.fLabel;
        this.fLabel = label;
        if (this.isEditable()) {
            this.firePropertyChanged("label", old, this.fLabel);
        }
    }

    public void setSkip(boolean skip) {
        Boolean old = this.fSkip;
        this.fSkip = skip;
        if (this.isEditable()) {
            this.firePropertyChanged("skip", old, this.fSkip);
        }
    }

    public void setWhen(String when) {
        String old = this.fWhen;
        this.fWhen = when;
        if (this.isEditable()) {
            this.firePropertyChanged("when", old, this.fWhen);
        }
    }

    public void parse(Element element) {
        this.fLabel = element.getAttribute("label").trim();
        if (element.getAttribute("skip").compareTo("true") == 0) {
            this.fSkip = true;
        }
        this.fWhen = element.getAttribute("when");
        NodeList children = element.getChildNodes();
        ISimpleCSModelFactory factory = this.getModel().getFactory();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                Element childElement = (Element)child;
                if (name.equals("action")) {
                    this.fExecutable = factory.createSimpleCSAction(this);
                    this.fExecutable.parse(childElement);
                } else if (name.equals("command")) {
                    this.fExecutable = factory.createSimpleCSCommand(this);
                    this.fExecutable.parse(childElement);
                } else if (name.equals("perform-when")) {
                    this.fExecutable = factory.createSimpleCSPerformWhen(this);
                    this.fExecutable.parse(childElement);
                }
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = String.valueOf(indent) + "   ";
        try {
            buffer.append("subitem");
            if (this.fLabel != null && this.fLabel.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("label", PDETextHelper.translateWriteText(this.fLabel.trim(), LABEL_SUBSTITUTE_CHARS)));
            }
            buffer.append(XMLPrintHandler.wrapAttribute("skip", new Boolean(this.fSkip).toString()));
            if (this.fWhen != null && this.fWhen.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("when", this.fWhen));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            if (this.fExecutable != null) {
                this.fExecutable.write(newIndent, writer);
            }
            XMLPrintHandler.printEndElement(writer, "subitem", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fLabel = null;
        this.fSkip = false;
        this.fWhen = null;
        this.fExecutable = null;
    }

    public int getType() {
        return 10;
    }

    public String getName() {
        return this.fLabel;
    }

    public List getChildren() {
        ArrayList<ISimpleCSRunContainerObject> list = new ArrayList<ISimpleCSRunContainerObject>();
        if (this.fExecutable != null && this.fExecutable.getType() == 8) {
            list.add(this.fExecutable);
        }
        return list;
    }
}

