/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSAction;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSCommand;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSPerformWhen;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSRunObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleCSPerformWhen
extends SimpleCSObject
implements ISimpleCSPerformWhen {
    private String fCondition;
    private ArrayList fExecutables;
    private static final long serialVersionUID = 1L;

    public SimpleCSPerformWhen(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public String getCondition() {
        return this.fCondition;
    }

    public ISimpleCSRunObject[] getExecutables() {
        return this.fExecutables.toArray(new ISimpleCSRunObject[this.fExecutables.size()]);
    }

    public void setCondition(String condition) {
        String old = this.fCondition;
        this.fCondition = condition;
        if (this.isEditable()) {
            this.firePropertyChanged("condition", old, this.fCondition);
        }
    }

    public void parse(Element element) {
        this.fCondition = element.getAttribute("condition");
        NodeList children = element.getChildNodes();
        ISimpleCSModelFactory factory = this.getModel().getFactory();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                Element childElement = (Element)child;
                if (name.equals("command")) {
                    ISimpleCSCommand command = factory.createSimpleCSCommand(this);
                    this.fExecutables.add(command);
                    command.parse(childElement);
                } else if (name.equals("action")) {
                    ISimpleCSAction action = factory.createSimpleCSAction(this);
                    this.fExecutables.add(action);
                    action.parse(childElement);
                }
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = String.valueOf(indent) + "   ";
        try {
            buffer.append("perform-when");
            if (this.fCondition != null && this.fCondition.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("condition", this.fCondition));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            Iterator iterator = this.fExecutables.iterator();
            while (iterator.hasNext()) {
                ISimpleCSRunObject executable = (ISimpleCSRunObject)iterator.next();
                executable.write(newIndent, writer);
            }
            XMLPrintHandler.printEndElement(writer, "perform-when", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fCondition = null;
        this.fExecutables = new ArrayList();
    }

    public int getType() {
        return 8;
    }

    public String getName() {
        return "perform-when";
    }

    public List getChildren() {
        return new ArrayList();
    }

    public void addExecutable(ISimpleCSRunObject executable) {
        this.fExecutables.add(executable);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)executable, 1);
        }
    }

    public void removeExecutable(ISimpleCSRunObject executable) {
        this.fExecutables.remove(executable);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)executable, 2);
        }
    }
}

