/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSDescription;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleCSIntro
extends SimpleCSObject
implements ISimpleCSIntro {
    private ISimpleCSDescription fDescription;
    private String fContextId;
    private String fHref;
    private static final long serialVersionUID = 1L;

    public SimpleCSIntro(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public String getContextId() {
        return this.fContextId;
    }

    public ISimpleCSDescription getDescription() {
        return this.fDescription;
    }

    public String getHref() {
        return this.fHref;
    }

    public void setContextId(String contextId) {
        String old = this.fContextId;
        this.fContextId = contextId;
        if (this.isEditable()) {
            this.firePropertyChanged("contextId", old, this.fContextId);
        }
    }

    public void setDescription(ISimpleCSDescription description) {
        ISimpleCSDescription old = this.fDescription;
        this.fDescription = description;
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)description, old);
        }
    }

    public void setHref(String href) {
        String old = this.fHref;
        this.fHref = href;
        if (this.isEditable()) {
            this.firePropertyChanged("href", old, this.fHref);
        }
    }

    public void parse(Element element) {
        this.fContextId = element.getAttribute("contextId").trim();
        this.fHref = element.getAttribute("href").trim();
        NodeList children = element.getChildNodes();
        ISimpleCSModelFactory factory = this.getModel().getFactory();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element childElement = (Element)child;
                String name = child.getNodeName();
                if (name.equals("description")) {
                    this.fDescription = factory.createSimpleCSDescription(this);
                    this.fDescription.parse(childElement);
                }
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = String.valueOf(indent) + "   ";
        try {
            buffer.append("intro");
            if (this.fContextId != null && this.fContextId.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("contextId", PDETextHelper.translateWriteText(this.fContextId.trim(), SUBSTITUTE_CHARS)));
            } else if (this.fHref != null && this.fHref.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("href", PDETextHelper.translateWriteText(this.fHref.trim(), SUBSTITUTE_CHARS)));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            if (this.fDescription != null) {
                this.fDescription.write(newIndent, writer);
            }
            XMLPrintHandler.printEndElement(writer, "intro", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fDescription = null;
        this.fContextId = null;
        this.fHref = null;
    }

    public int getType() {
        return 5;
    }

    public String getName() {
        return PDECoreMessages.SimpleCSIntro_0;
    }

    public List getChildren() {
        return new ArrayList();
    }
}

